/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.nativ;

import com.orientechnologies.orient.core.query.OQueryContext;
import com.orientechnologies.orient.core.query.OQueryHelper;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryContextNative<T extends ORecordInternal<?>>
extends OQueryContext<T> {
    protected Boolean result;
    protected Boolean partialResult;
    protected Object currentValue;

    @Override
    public void setRecord(T iRecord) {
        super.setRecord(iRecord);
        this.result = null;
        this.partialResult = null;
        this.currentValue = null;
    }

    public OQueryContextNative<T> and() {
        if (this.result == null && this.partialResult != null && !this.partialResult.booleanValue()) {
            this.result = this.partialResult;
        }
        return this;
    }

    public OQueryContextNative<T> or() {
        if (this.result == null && this.partialResult != null && this.partialResult.booleanValue()) {
            this.result = this.partialResult;
        }
        return this;
    }

    public OQueryContextNative<T> not() {
        if (this.result == null && this.partialResult != null) {
            this.partialResult = this.partialResult == false;
        }
        return this;
    }

    public OQueryContextNative<T> like(String iValue) {
        if (this.checkOperator()) {
            this.partialResult = OQueryHelper.like(this.currentValue.toString(), iValue);
        }
        return this;
    }

    public OQueryContextNative<T> matches(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = this.currentValue.toString().matches(iValue.toString());
        }
        return this;
    }

    public OQueryContextNative<T> eq(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = this.currentValue.equals(iValue);
        }
        return this;
    }

    public OQueryContextNative<T> different(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = !this.currentValue.equals(iValue);
        }
        return this;
    }

    public OQueryContextNative<T> between(Object iFrom, Object iTo) {
        if (this.checkOperator()) {
            this.partialResult = ((Comparable)this.currentValue).compareTo(iFrom) >= 0 && ((Comparable)this.currentValue).compareTo(iTo) <= 0;
        }
        return this;
    }

    public OQueryContextNative<T> minor(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = ((Comparable)this.currentValue).compareTo(iValue) < 0;
        }
        return this;
    }

    public OQueryContextNative<T> minorEq(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = ((Comparable)this.currentValue).compareTo(iValue) <= 0;
        }
        return this;
    }

    public OQueryContextNative<T> major(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = ((Comparable)this.currentValue).compareTo(iValue) > 0;
        }
        return this;
    }

    public OQueryContextNative<T> majorEq(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = ((Comparable)this.currentValue).compareTo(iValue) >= 0;
        }
        return this;
    }

    public OQueryContextNative<T> toInt() {
        if (this.checkOperator()) {
            this.currentValue = Integer.valueOf(this.currentValue.toString());
        }
        return this;
    }

    public OQueryContextNative<T> toLong() {
        if (this.checkOperator()) {
            this.currentValue = Long.valueOf(this.currentValue.toString());
        }
        return this;
    }

    public OQueryContextNative<T> toFloat() {
        if (this.checkOperator()) {
            this.currentValue = Float.valueOf(this.currentValue.toString());
        }
        return this;
    }

    public OQueryContextNative<T> toDouble() {
        if (this.checkOperator()) {
            this.currentValue = Double.valueOf(this.currentValue.toString());
        }
        return this;
    }

    public OQueryContextNative<T> toChar() {
        if (this.checkOperator()) {
            this.currentValue = Character.valueOf(this.currentValue.toString().charAt(0));
        }
        return this;
    }

    public OQueryContextNative<T> toDate() {
        if (this.checkOperator()) {
            this.currentValue = new Date(Long.valueOf(this.currentValue.toString()));
        }
        return this;
    }

    public boolean go() {
        return this.result != null ? this.result : (this.partialResult != null ? this.partialResult : false);
    }

    protected boolean checkOperator() {
        if (this.result != null) {
            return false;
        }
        if (this.currentValue == null) {
            this.result = false;
            return false;
        }
        return true;
    }
}

