/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORecordAbstract<T>
implements ORecord<T>,
ORecordInternal<T> {
    protected ODatabaseRecord _database;
    protected ORecordId _recordId;
    protected int _version;
    protected byte[] _source;
    protected int _size;
    protected ORecordSerializer _recordFormat;
    protected boolean _pinned = true;
    protected boolean _dirty = true;
    protected ORecordElement.STATUS _status = ORecordElement.STATUS.LOADED;
    protected ORecordListener _listener = null;

    public ORecordAbstract() {
    }

    public ORecordAbstract(ODatabaseRecord iDatabase) {
        this._database = iDatabase;
    }

    public ORecordAbstract(ODatabaseRecord iDatabase, byte[] iSource) {
        this(iDatabase);
        this._source = iSource;
        this._size = iSource.length;
        this.unsetDirty();
    }

    @Override
    public ORecordAbstract<?> fill(ODatabaseRecord iDatabase, ORecordId iRid, int iVersion, byte[] iBuffer, boolean iDirty) {
        this._database = iDatabase;
        this._recordId.clusterId = iRid.clusterId;
        this._recordId.clusterPosition = iRid.clusterPosition;
        this._version = iVersion;
        this._status = ORecordElement.STATUS.LOADED;
        this._source = iBuffer;
        int n = this._size = iBuffer != null ? iBuffer.length : 0;
        if (this._source != null && this._source.length > 0) {
            this._dirty = iDirty;
        }
        return this;
    }

    @Override
    public ORID getIdentity() {
        return this._recordId;
    }

    @Override
    public ORecord<?> getRecord() {
        return this;
    }

    @Override
    public ORecordAbstract<?> setIdentity(int iClusterId, long iClusterPosition) {
        if (this._recordId == null || this._recordId == ORecordId.EMPTY_RECORD_ID) {
            this._recordId = new ORecordId(iClusterId, iClusterPosition);
        } else {
            this._recordId.clusterId = iClusterId;
            this._recordId.clusterPosition = iClusterPosition;
        }
        return this;
    }

    @Override
    public ORecordAbstract<?> setIdentity(ORecordId iIdentity) {
        this._recordId = iIdentity;
        return this;
    }

    @Override
    public boolean detach() {
        this._database = null;
        return true;
    }

    @Override
    public ORecordAbstract<T> clear() {
        this.setDirty();
        this.invokeListenerEvent(ORecordListener.EVENT.CLEAR);
        return this;
    }

    @Override
    public ORecordAbstract<T> reset() {
        this._status = ORecordElement.STATUS.LOADED;
        this._version = 0;
        this.setDirty();
        if (this._recordId != null) {
            this._recordId.reset();
        }
        this.invokeListenerEvent(ORecordListener.EVENT.RESET);
        return this;
    }

    @Override
    public byte[] toStream() {
        if (this._source == null) {
            this._source = this._recordFormat.toStream(this._database, this, false);
        }
        this.invokeListenerEvent(ORecordListener.EVENT.MARSHALL);
        return this._source;
    }

    @Override
    public ORecordAbstract<T> fromStream(byte[] iRecordBuffer) {
        this._dirty = false;
        this._source = iRecordBuffer;
        this._size = iRecordBuffer != null ? iRecordBuffer.length : 0;
        this._status = ORecordElement.STATUS.LOADED;
        this.invokeListenerEvent(ORecordListener.EVENT.UNMARSHALL);
        return this;
    }

    @Override
    public void unsetDirty() {
        if (this._dirty) {
            this._dirty = false;
        }
    }

    public ORecordAbstract<T> setDirty() {
        if (!this._dirty && this._status != ORecordElement.STATUS.UNMARSHALLING) {
            this._dirty = true;
        }
        this._source = null;
        return this;
    }

    @Override
    public void onBeforeIdentityChanged(ORID iRID) {
    }

    @Override
    public void onAfterIdentityChanged(ORecord<?> iRecord) {
    }

    @Override
    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public boolean isPinned() {
        return this._pinned;
    }

    @Override
    public ORecordAbstract<T> pin() {
        if (!this._pinned) {
            this._pinned = true;
        }
        return this;
    }

    @Override
    public ORecordAbstract<T> unpin() {
        if (this._pinned) {
            this._pinned = false;
        }
        return this;
    }

    @Override
    public ODatabaseRecord getDatabase() {
        return this._database;
    }

    @Override
    public boolean setDatabase(ODatabaseRecord iDatabase) {
        if (this._database != iDatabase) {
            this._database = iDatabase;
            return true;
        }
        return false;
    }

    @Override
    public <RET extends ORecord<T>> RET fromJSON(String iSource) {
        ORecordSerializerJSON.INSTANCE.fromString(this._database, iSource, this);
        return (RET)this;
    }

    @Override
    public String toJSON() {
        return this.toJSON("rid,version,class,type,attribSameRow");
    }

    @Override
    public String toJSON(String iFormat) {
        return ORecordSerializerJSON.INSTANCE.toString(this, new StringBuilder(), iFormat).toString();
    }

    public String toString() {
        return (this._recordId.isValid() ? this._recordId : "") + (this._source != null ? Arrays.toString(this._source) : "[]") + " v" + this._version;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(int iVersion) {
        this._version = iVersion;
    }

    @Override
    public ORecordAbstract<T> unload() {
        this._status = ORecordElement.STATUS.NOT_LOADED;
        this._source = null;
        this.unsetDirty();
        this.invokeListenerEvent(ORecordListener.EVENT.UNLOAD);
        return this;
    }

    @Override
    public ORecordInternal<T> load() {
        if (this._database == null) {
            throw new ODatabaseException("No database assigned to current record");
        }
        if (!this.getIdentity().isValid()) {
            throw new ORecordNotFoundException("The record has no id, probably it's new or transient yet ");
        }
        try {
            ORecordInternal result = (ORecordInternal)this._database.load(this);
            if (result == null) {
                throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' was not found");
            }
            return result;
        }
        catch (Exception e) {
            throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' was not found", e);
        }
    }

    @Override
    public ORecordInternal<T> reload() {
        return this.reload(null);
    }

    public ORecordInternal<T> reload(String iFetchPlan) {
        return this.reload(null, true);
    }

    public ORecordInternal<T> reload(String iFetchPlan, boolean iIgnoreCache) {
        if (this._database == null) {
            throw new ODatabaseException("No database assigned to current record");
        }
        if (!this.getIdentity().isValid()) {
            throw new ORecordNotFoundException("The record has no id, probably it's new or transient yet ");
        }
        try {
            this._database.reload(this, iFetchPlan, iIgnoreCache);
            return this;
        }
        catch (Exception e) {
            throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' was not found", e);
        }
    }

    @Override
    public ORecordAbstract<T> save() {
        if (this._database == null) {
            throw new ODatabaseException("No database assigned to current record. Create it using the <DB>.newInstance()");
        }
        this._database.save(this);
        return this;
    }

    @Override
    public ORecordAbstract<T> save(String iClusterName) {
        if (this._database == null) {
            throw new ODatabaseException("No database assigned to current record. Create it using the <DB>.newInstance()");
        }
        this._database.save(this, iClusterName);
        return this;
    }

    @Override
    public ORecordAbstract<T> delete() {
        if (this._database == null) {
            throw new ODatabaseException("No database assigned to current record");
        }
        this._database.delete(this);
        this.setDirty();
        return this;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    protected void setup() {
        if (this._recordId == null) {
            this._recordId = new ORecordId();
        }
    }

    public int hashCode() {
        return this._recordId != null ? this._recordId.hashCode() : 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof OIdentifiable) {
            return this._recordId.equals(((OIdentifiable)obj).getIdentity());
        }
        return false;
    }

    @Override
    public int compare(OIdentifiable iFirst, OIdentifiable iSecond) {
        if (iFirst == null || iSecond == null) {
            return -1;
        }
        return iFirst.compareTo(iSecond);
    }

    @Override
    public int compareTo(OIdentifiable iOther) {
        if (iOther == null) {
            return 1;
        }
        if (this._recordId == null && iOther.getIdentity() == null) {
            return 0;
        }
        return this._recordId.compareTo(iOther.getIdentity());
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this._status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this._status = iStatus;
    }

    public ORecordAbstract<T> copyTo(ORecordAbstract<T> cloned) {
        cloned._source = this._source;
        cloned._size = this._size;
        cloned._database = this._database;
        cloned._recordId = this._recordId.copy();
        cloned._version = this._version;
        cloned._pinned = this._pinned;
        cloned._status = this._status;
        cloned._recordFormat = this._recordFormat;
        cloned._listener = null;
        cloned._dirty = false;
        return cloned;
    }

    public void setListener(ORecordListener iListener) {
        this._listener = iListener;
    }

    public void removeListener() {
        this._listener = null;
    }

    protected void invokeListenerEvent(ORecordListener.EVENT iEvent) {
        if (this._listener != null) {
            this._listener.onEvent(this, iEvent);
        }
    }

    @Override
    public <RET extends ORecord<T>> RET flatCopy() {
        return this.copy();
    }
}

