/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OMemoryInputStreamCursor;
import java.io.IOException;
import java.io.OutputStream;

public class OMemoryOutputStream
extends OutputStream {
    private byte[] buffer;
    private int position;
    private static final int NATIVE_COPY_THRESHOLD = 9;
    private static final int DEF_SIZE = 1024;

    public OMemoryOutputStream() {
        this(1024);
    }

    public OMemoryOutputStream(int initialCapacity) {
        this.buffer = new byte[initialCapacity];
    }

    public OMemoryOutputStream(byte[] stream) {
        this.buffer = stream;
    }

    public final void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.position);
    }

    public final byte[] getByteArray() {
        this.position = 0;
        return this.buffer;
    }

    public final byte[] toByteArray() {
        int pos = this.position;
        byte[] result = new byte[pos];
        byte[] mbuf = this.buffer;
        if (pos < 9) {
            for (int i = 0; i < pos; ++i) {
                result[i] = mbuf[i];
            }
        } else {
            System.arraycopy(mbuf, 0, result, 0, pos);
        }
        return result;
    }

    public final int size() {
        return this.position;
    }

    public final int capacity() {
        return this.buffer.length;
    }

    public final void reset() {
        this.position = 0;
    }

    public final void write(int b) {
        this.assureSpaceFor(1);
        this.buffer[this.position++] = (byte)b;
    }

    public final void write(byte[] iBuffer, int iOffset, int iLength) {
        int pos = this.position;
        int tot = pos + iLength;
        this.assureSpaceFor(iLength);
        byte[] mbuf = this.buffer;
        if (iLength < 9) {
            for (int i = 0; i < iLength; ++i) {
                mbuf[pos + i] = iBuffer[iOffset + i];
            }
        } else {
            System.arraycopy(iBuffer, iOffset, mbuf, pos, iLength);
        }
        this.position = tot;
    }

    public final void close() {
        this.reset();
    }

    public final void addAsFixed(byte[] iContent) throws IOException {
        if (iContent == null) {
            return;
        }
        this.write(iContent, 0, iContent.length);
    }

    public int copy(OMemoryInputStreamCursor iInput) throws IOException {
        if (iInput == null) {
            return -1;
        }
        int begin = this.position;
        int size = iInput.getSize();
        this.assureSpaceFor(4 + size);
        this.add(size);
        for (int i = 0; i < size; ++i) {
            this.write(iInput.read());
        }
        return begin;
    }

    public int add(byte[] iContent) throws IOException {
        if (iContent == null) {
            return -1;
        }
        int begin = this.position;
        this.assureSpaceFor(4 + iContent.length);
        OBinaryProtocol.int2bytes(iContent.length, this.buffer, this.position);
        this.position += 4;
        this.write(iContent, 0, iContent.length);
        return begin;
    }

    public void add(byte iContent) throws IOException {
        this.write(iContent);
    }

    public final int add(String iContent) throws IOException {
        return this.add(OBinaryProtocol.string2bytes(iContent));
    }

    public void add(boolean iContent) throws IOException {
        this.write(iContent ? 1 : 0);
    }

    public void add(char iContent) throws IOException {
        this.assureSpaceFor(2);
        OBinaryProtocol.char2bytes(iContent, this.buffer, this.position);
        this.position += 2;
    }

    public void add(int iContent) throws IOException {
        this.assureSpaceFor(4);
        OBinaryProtocol.int2bytes(iContent, this.buffer, this.position);
        this.position += 4;
    }

    public int add(long iContent) throws IOException {
        this.assureSpaceFor(8);
        int begin = this.position;
        OBinaryProtocol.long2bytes(iContent, this.buffer, this.position);
        this.position += 8;
        return begin;
    }

    public int add(short iContent) throws IOException {
        this.assureSpaceFor(2);
        int begin = this.position;
        OBinaryProtocol.short2bytes(iContent, this.buffer, this.position);
        this.position += 2;
        return begin;
    }

    public int getPosition() {
        return this.position;
    }

    private void assureSpaceFor(int iLength) {
        byte[] mbuf = this.buffer;
        int pos = this.position;
        int mbuflen = mbuf.length;
        int capacity = this.position + iLength;
        if (mbuflen <= capacity) {
            OProfiler.getInstance().updateCounter("OMemOutStream.resize", 1L);
            byte[] newbuf = new byte[Math.max(mbuflen << 1, capacity)];
            if (pos < 9) {
                for (int i = 0; i < pos; ++i) {
                    newbuf[i] = mbuf[i];
                }
            } else {
                System.arraycopy(mbuf, 0, newbuf, 0, pos);
            }
            this.buffer = newbuf;
        }
    }
}

