/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.object;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.annotation.OAccess;
import com.orientechnologies.orient.core.annotation.OAfterDeserialization;
import com.orientechnologies.orient.core.annotation.OAfterSerialization;
import com.orientechnologies.orient.core.annotation.OBeforeDeserialization;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.annotation.ODocumentInstance;
import com.orientechnologies.orient.core.annotation.OId;
import com.orientechnologies.orient.core.annotation.OVersion;
import com.orientechnologies.orient.core.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.object.ODatabaseObjectTx;
import com.orientechnologies.orient.core.db.object.OLazyObjectList;
import com.orientechnologies.orient.core.db.object.OLazyObjectMap;
import com.orientechnologies.orient.core.db.object.OLazyObjectSet;
import com.orientechnologies.orient.core.db.object.OObjectNotDetachedException;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializerContext;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectSerializerHelper {
    private static final Class<?>[] callbackAnnotationClasses = new Class[]{OBeforeDeserialization.class, OAfterDeserialization.class, OBeforeSerialization.class, OAfterSerialization.class};
    private static final Class<?>[] NO_ARGS = new Class[0];
    private static HashMap<Class<?>, OObjectSerializerContext> serializerContexts = new LinkedHashMap();
    private static HashMap<String, List<Field>> classes = new HashMap();
    private static HashMap<String, Method> callbacks = new HashMap();
    private static HashMap<String, Object> getters = new HashMap();
    private static HashMap<String, Object> setters = new HashMap();
    private static HashMap<Class<?>, String> boundDocumentFields = new HashMap();
    private static HashMap<Class<?>, String> fieldIds = new HashMap();
    private static HashMap<Class<?>, String> fieldVersions = new HashMap();
    private static Class jpaIdClass;
    private static Class jpaVersionClass;
    private static Class jpaAccessClass;

    public static boolean hasField(Object iPojo, String iProperty) {
        Class<?> c = iPojo.getClass();
        String className = c.getName();
        OObjectSerializerHelper.getClassFields(c);
        return getters.get(className + "." + iProperty) != null;
    }

    public static String getDocumentBoundField(Class<?> iClass) {
        OObjectSerializerHelper.getClassFields(iClass);
        return boundDocumentFields.get(iClass);
    }

    public static Class<?> getFieldType(Object iPojo, String iProperty) {
        Class<?> c = iPojo.getClass();
        String className = c.getName();
        OObjectSerializerHelper.getClassFields(c);
        try {
            Object o = getters.get(className + "." + iProperty);
            if (o == null) {
                return null;
            }
            if (o instanceof Field) {
                return ((Field)o).getType();
            }
            return ((Method)o).getReturnType();
        }
        catch (Exception e) {
            throw new OSchemaException("Can't get the value of the property: " + iProperty, e);
        }
    }

    public static Class<?> getFieldType(ODocument iDocument, OEntityManager iEntityManager) {
        if (iDocument.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            iDocument = (ODocument)iDocument.load();
        }
        if (iDocument.getClassName() == null) {
            return null;
        }
        return iEntityManager.getEntityClass(iDocument.getClassName());
    }

    public static Object getFieldValue(Object iPojo, String iProperty) {
        Class<?> c = iPojo.getClass();
        String className = c.getName();
        OObjectSerializerHelper.getClassFields(c);
        try {
            Object o = getters.get(className + "." + iProperty);
            if (o instanceof Method) {
                return ((Method)o).invoke(iPojo, new Object[0]);
            }
            if (o instanceof Field) {
                return ((Field)o).get(iPojo);
            }
            return null;
        }
        catch (Exception e) {
            throw new OSchemaException("Can't get the value of the property: " + iProperty, e);
        }
    }

    public static void setFieldValue(Object iPojo, String iProperty, Object iValue) {
        Class<?> c = iPojo.getClass();
        String className = c.getName();
        OObjectSerializerHelper.getClassFields(c);
        try {
            Object o = setters.get(className + "." + iProperty);
            if (o instanceof Method) {
                ((Method)o).invoke(iPojo, OType.convert(iValue, ((Method)o).getParameterTypes()[0]));
            } else if (o instanceof Field) {
                ((Field)o).set(iPojo, OType.convert(iValue, ((Field)o).getType()));
            }
        }
        catch (Exception e) {
            throw new OSchemaException("Can't set the value '" + iValue + "' to the property '" + iProperty + "' for the pojo: " + iPojo, e);
        }
    }

    public static Object fromStream(final ODocument iRecord, final Object iPojo, final OEntityManager iEntityManager, final OUserObject2RecordHandler iObj2RecHandler, final String iFetchPlan) {
        OFetchHelper.checkFetchPlanValid(iFetchPlan);
        long timer = OProfiler.getInstance().startChrono();
        Class<?> pojoClass = iPojo.getClass();
        List<Field> properties = OObjectSerializerHelper.getClassFields(pojoClass);
        String idFieldName = OObjectSerializerHelper.setObjectID(iRecord.getIdentity(), iPojo);
        String vFieldName = OObjectSerializerHelper.setObjectVersion(iRecord.getVersion(), iPojo);
        OObjectSerializerHelper.invokeCallback(iPojo, iRecord, OBeforeDeserialization.class);
        for (Field p : properties) {
            Object fieldValue;
            String fieldName = p.getName();
            if (fieldName.equals(idFieldName) || fieldName.equals(vFieldName) || !iRecord.containsField(fieldName) || (fieldValue = iRecord.field(fieldName)) != null && fieldValue instanceof ODocument && (!(fieldValue instanceof Collection) || ((Collection)fieldValue).size() != 0 && ((Collection)fieldValue).iterator().next() instanceof ODocument) && fieldValue instanceof Map && ((Map)fieldValue).size() != 0 && ((Map)fieldValue).values().iterator().next() instanceof ODocument) continue;
            Class<?> genericTypeClass = OObjectSerializerHelper.getGenericMultivalueType(p);
            if (genericTypeClass != null && genericTypeClass.isEnum()) {
                Object v;
                if (fieldValue instanceof List) {
                    List list = (List)fieldValue;
                    for (int i = 0; i < list.size(); ++i) {
                        v = list.get(i);
                        if (v == null) continue;
                        v = Enum.valueOf(genericTypeClass, v.toString());
                        list.set(i, v);
                    }
                } else if (fieldValue instanceof Set) {
                    HashSet newColl = new HashSet();
                    Set set = (Set)fieldValue;
                    for (Object v2 : set) {
                        if (v2 == null) continue;
                        v2 = Enum.valueOf(genericTypeClass, v2.toString());
                        newColl.add(v2);
                    }
                    fieldValue = newColl;
                } else if (fieldValue instanceof Map) {
                    Map map = (Map)fieldValue;
                    for (Map.Entry entry : map.entrySet()) {
                        v = entry.getValue();
                        if (v == null) continue;
                        v = Enum.valueOf(genericTypeClass, v.toString());
                        map.put(entry.getKey(), v);
                    }
                }
            }
            OObjectSerializerHelper.setFieldValue(iPojo, fieldName, OObjectSerializerHelper.unserializeFieldValue(iPojo, fieldName, fieldValue));
        }
        Map<String, Integer> fetchPlan = OFetchHelper.buildFetchPlan(iFetchPlan);
        OFetchHelper.fetch(iRecord, iPojo, fetchPlan, null, 0, -1, new OFetchListener(){

            public int size() {
                return 0;
            }

            public Object fetchLinked(ODocument iRoot, Object iUserObject, String iFieldName, Object iLinked) {
                Class<?> type = iLinked != null && iLinked instanceof ODocument ? OObjectSerializerHelper.getFieldType((ODocument)iLinked, iEntityManager) : OObjectSerializerHelper.getFieldType(iUserObject, iFieldName);
                if (type == null) {
                    throw new OSerializationException("Linked type of field '" + iRoot.getClassName() + "." + iFieldName + "' is unknown. Probably needs to be registered with <db>.getEntityManager().registerEntityClasses(<package>) or <db>.getEntityManager().registerEntityClass(<class>) or the package can't be loaded correctly due to a classpath problem. In this case register the single classes one by one.");
                }
                Object fieldValue = null;
                boolean propagate = false;
                if (Set.class.isAssignableFrom(type)) {
                    Collection set = (Collection)iLinked;
                    OLazyObjectSet<Object> target = new OLazyObjectSet<Object>((ODatabaseObjectTx)iRecord.getDatabase().getDatabaseOwner(), iRoot, set).setFetchPlan(iFetchPlan);
                    fieldValue = target;
                } else if (Collection.class.isAssignableFrom(type)) {
                    Collection list = (Collection)iLinked;
                    OLazyObjectList<Object> targetList = new OLazyObjectList<Object>((ODatabaseObjectTx)iRecord.getDatabase().getDatabaseOwner()).setFetchPlan(iFetchPlan);
                    fieldValue = targetList;
                    if (list != null && list.size() > 0) {
                        targetList.addAll(list);
                    }
                } else if (Map.class.isAssignableFrom(type)) {
                    Map map = (Map)iLinked;
                    OLazyObjectMap<Object> target = new OLazyObjectMap<Object>((ODatabaseObjectTx)iRecord.getDatabase().getDatabaseOwner(), iRoot, map).setFetchPlan(iFetchPlan);
                    fieldValue = target;
                } else if (type.isEnum()) {
                    String enumName = (String)((ODocument)iLinked).field(iFieldName);
                    Class<?> enumClass = type;
                    fieldValue = Enum.valueOf(enumClass, enumName);
                } else {
                    Class<?> fieldClass = iEntityManager.getEntityClass(type.getSimpleName());
                    if (fieldClass != null) {
                        propagate = !iObj2RecHandler.existsUserObjectByRID(((ODocument)iLinked).getIdentity());
                        fieldValue = iObj2RecHandler.getUserObjectByRecord((ODocument)iLinked, iFetchPlan);
                    }
                }
                OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, OObjectSerializerHelper.unserializeFieldValue(iPojo, iFieldName, fieldValue));
                return propagate ? fieldValue : null;
            }
        });
        OObjectSerializerHelper.invokeCallback(iPojo, iRecord, OAfterDeserialization.class);
        OProfiler.getInstance().stopChrono("Object.fromStream", timer);
        return iPojo;
    }

    public static String setObjectID(ORID iIdentity, Object iPojo) {
        List<Field> properties;
        if (iPojo == null) {
            return null;
        }
        Class<?> pojoClass = iPojo.getClass();
        String idFieldName = fieldIds.get(pojoClass);
        if (idFieldName != null && (properties = OObjectSerializerHelper.getClassFields(pojoClass)) != null) {
            for (Field p : properties) {
                if (!p.getName().equals(idFieldName)) continue;
                Class<?> fieldType = p.getType();
                if (ORID.class.isAssignableFrom(fieldType)) {
                    OObjectSerializerHelper.setFieldValue(iPojo, idFieldName, iIdentity);
                    break;
                }
                if (Number.class.isAssignableFrom(fieldType)) {
                    OObjectSerializerHelper.setFieldValue(iPojo, idFieldName, iIdentity != null ? Long.valueOf(iIdentity.getClusterPosition()) : null);
                    break;
                }
                if (fieldType.equals(String.class)) {
                    OObjectSerializerHelper.setFieldValue(iPojo, idFieldName, iIdentity != null ? iIdentity.toString() : null);
                    break;
                }
                if (fieldType.equals(Object.class)) {
                    OObjectSerializerHelper.setFieldValue(iPojo, idFieldName, iIdentity);
                    break;
                }
                OLogManager.instance().warn(OObjectSerializerHelper.class, "@Id field has been declared as %s while the supported are: ORID, Number, String, Object", new Object[]{fieldType});
                break;
            }
        }
        return idFieldName;
    }

    public static ORecordId getObjectID(ODatabasePojoAbstract<?> iDb, Object iPojo) {
        Object id;
        String idFieldName = fieldIds.get(iPojo.getClass());
        if (idFieldName != null && (id = OObjectSerializerHelper.getFieldValue(iPojo, idFieldName)) != null) {
            if (id instanceof ORecordId) {
                return (ORecordId)id;
            }
            if (id instanceof Number) {
                OClass cls = iDb.getMetadata().getSchema().getClass(iPojo.getClass());
                if (cls == null) {
                    throw new OConfigurationException("Class " + iPojo.getClass() + " is not managed by current database");
                }
                return new ORecordId(cls.getDefaultClusterId(), ((Number)id).longValue());
            }
            if (id instanceof String) {
                return new ORecordId((String)id);
            }
        }
        return null;
    }

    public static boolean hasObjectID(Object iPojo) {
        String idFieldName = fieldIds.get(iPojo.getClass());
        return idFieldName != null;
    }

    public static String setObjectVersion(Integer iVersion, Object iPojo) {
        List<Field> properties;
        if (iPojo == null) {
            return null;
        }
        Class<?> pojoClass = iPojo.getClass();
        String vFieldName = fieldVersions.get(pojoClass);
        if (vFieldName != null && (properties = OObjectSerializerHelper.getClassFields(pojoClass)) != null) {
            for (Field p : properties) {
                if (!p.getName().equals(vFieldName)) continue;
                Class<?> fieldType = p.getType();
                if (Number.class.isAssignableFrom(fieldType)) {
                    OObjectSerializerHelper.setFieldValue(iPojo, vFieldName, iVersion);
                    break;
                }
                if (fieldType.equals(String.class)) {
                    OObjectSerializerHelper.setFieldValue(iPojo, vFieldName, String.valueOf(iVersion));
                    break;
                }
                if (fieldType.equals(Object.class)) {
                    OObjectSerializerHelper.setFieldValue(iPojo, vFieldName, iVersion);
                    break;
                }
                OLogManager.instance().warn(OObjectSerializerHelper.class, "@Version field has been declared as %s while the supported are: Number, String, Object", new Object[]{fieldType});
                break;
            }
        }
        return vFieldName;
    }

    public static int getObjectVersion(Object iPojo) {
        Object ver;
        String idFieldName = fieldVersions.get(iPojo.getClass());
        if (idFieldName != null && (ver = OObjectSerializerHelper.getFieldValue(iPojo, idFieldName)) != null) {
            if (ver instanceof Number) {
                return ((Number)ver).intValue();
            }
            if (ver instanceof String) {
                return Integer.parseInt((String)ver);
            }
        }
        throw new OObjectNotDetachedException("Can't retrieve the object's VERSION for '" + iPojo + "' because hasn't been detached");
    }

    public static boolean hasObjectVersion(Object iPojo) {
        String idFieldName = fieldVersions.get(iPojo.getClass());
        return idFieldName != null;
    }

    public static ODocument toStream(Object iPojo, ODocument iRecord, OEntityManager iEntityManager, OClass schemaClass, OUserObject2RecordHandler iObj2RecHandler, ODatabaseObjectTx db, boolean iSaveOnlyDirty) {
        Object id;
        if (iSaveOnlyDirty && !iRecord.isDirty()) {
            return iRecord;
        }
        long timer = OProfiler.getInstance().startChrono();
        Integer identityRecord = System.identityHashCode(iRecord);
        if (((Set)OSerializationThreadLocal.INSTANCE.get()).contains(identityRecord)) {
            return iRecord;
        }
        ((Set)OSerializationThreadLocal.INSTANCE.get()).add(identityRecord);
        Class<?> pojoClass = iPojo.getClass();
        List<Field> properties = OObjectSerializerHelper.getClassFields(pojoClass);
        String idFieldName = fieldIds.get(pojoClass);
        if (idFieldName != null && (id = OObjectSerializerHelper.getFieldValue(iPojo, idFieldName)) != null) {
            if (id instanceof ORecordId) {
                iRecord.setIdentity((ORecordId)id);
            } else if (id instanceof Number) {
                ((ORecordId)iRecord.getIdentity()).clusterId = schemaClass.getDefaultClusterId();
                ((ORecordId)iRecord.getIdentity()).clusterPosition = ((Number)id).longValue();
            } else if (id instanceof String) {
                ((ORecordId)iRecord.getIdentity()).fromString((String)id);
            } else if (id.getClass().equals(Object.class)) {
                iRecord.setIdentity((ORecordId)id);
            } else {
                OLogManager.instance().warn(OObjectSerializerHelper.class, "@Id field has been declared as %s while the supported are: ORID, Number, String, Object", new Object[]{id.getClass()});
            }
        }
        String vFieldName = fieldVersions.get(pojoClass);
        boolean versionConfigured = false;
        if (vFieldName != null) {
            versionConfigured = true;
            Object ver = OObjectSerializerHelper.getFieldValue(iPojo, vFieldName);
            if (ver != null) {
                if (ver instanceof Number) {
                    iRecord.setVersion(((Number)ver).intValue());
                } else if (ver instanceof String) {
                    iRecord.setVersion(Integer.parseInt((String)ver));
                } else if (ver.getClass().equals(Object.class)) {
                    iRecord.setVersion((Integer)ver);
                } else {
                    OLogManager.instance().warn(OObjectSerializerHelper.class, "@Version field has been declared as %s while the supported are: Number, String, Object", new Object[]{ver.getClass()});
                }
            }
        }
        if (!versionConfigured && iRecord.getDatabase().getTransaction() instanceof OTransactionOptimistic) {
            throw new OTransactionException("Can't involve an object of class '" + pojoClass + "' in an Optimistic Transaction commit because it doesn't define @Version or @OVersion and therefore can't handle MVCC");
        }
        iRecord.setClassName(schemaClass != null ? schemaClass.getName() : null);
        OObjectSerializerHelper.invokeCallback(iPojo, iRecord, OBeforeSerialization.class);
        for (Field p : properties) {
            String fieldName = p.getName();
            if (fieldName.equals(idFieldName) || fieldName.equals(vFieldName)) continue;
            Object fieldValue = OObjectSerializerHelper.serializeFieldValue(iPojo, fieldName, OObjectSerializerHelper.getFieldValue(iPojo, fieldName));
            OProperty schemaProperty = schemaClass != null ? schemaClass.getProperty(fieldName) : null;
            fieldValue = OObjectSerializerHelper.typeToStream(fieldValue, schemaProperty != null ? schemaProperty.getType() : null, iEntityManager, iObj2RecHandler, db, iSaveOnlyDirty);
            iRecord.field(fieldName, fieldValue);
        }
        iObj2RecHandler.registerUserObject(iPojo, iRecord);
        OObjectSerializerHelper.invokeCallback(iPojo, iRecord, OAfterSerialization.class);
        ((Set)OSerializationThreadLocal.INSTANCE.get()).remove(identityRecord);
        OProfiler.getInstance().stopChrono("Object.toStream", timer);
        return iRecord;
    }

    public static Object serializeFieldValue(Object iPojo, String iFieldName, Object iFieldValue) {
        for (Class<?> classContext : serializerContexts.keySet()) {
            if (classContext == null || !classContext.isInstance(iPojo)) continue;
            return serializerContexts.get(classContext).serializeFieldValue(iPojo, iFieldName, iFieldValue);
        }
        if (serializerContexts.get(null) != null) {
            return serializerContexts.get(null).serializeFieldValue(iPojo, iFieldName, iFieldValue);
        }
        return iFieldValue;
    }

    public static Object unserializeFieldValue(Object iPojo, String iFieldName, Object iFieldValue) {
        for (Class<?> classContext : serializerContexts.keySet()) {
            if (classContext == null || !classContext.isInstance(iPojo)) continue;
            return serializerContexts.get(classContext).unserializeFieldValue(iPojo, iFieldName, iFieldValue);
        }
        if (serializerContexts.get(null) != null) {
            return serializerContexts.get(null).unserializeFieldValue(iPojo, iFieldName, iFieldValue);
        }
        return iFieldValue;
    }

    public static Class<?> getGenericMultivalueType(Field p) {
        ParameterizedType pt;
        Type genericType = p.getGenericType();
        if (genericType != null && genericType instanceof ParameterizedType && (pt = (ParameterizedType)genericType).getActualTypeArguments() != null && pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof Class) {
            return (Class)pt.getActualTypeArguments()[0];
        }
        return null;
    }

    private static Object typeToStream(Object iFieldValue, OType iType, OEntityManager iEntityManager, OUserObject2RecordHandler iObj2RecHandler, ODatabaseObjectTx db, boolean iSaveOnlyDirty) {
        if (iFieldValue == null) {
            return null;
        }
        if (!OType.isSimpleType(iFieldValue)) {
            Class<?> fieldClass = iFieldValue.getClass();
            if (fieldClass.isArray()) {
                iFieldValue = OObjectSerializerHelper.multiValueToStream(Arrays.asList(iFieldValue), iType, iEntityManager, iObj2RecHandler, db, iSaveOnlyDirty);
            } else if (Collection.class.isAssignableFrom(fieldClass)) {
                iFieldValue = OObjectSerializerHelper.multiValueToStream(iFieldValue, iType, iEntityManager, iObj2RecHandler, db, iSaveOnlyDirty);
            } else if (Map.class.isAssignableFrom(fieldClass)) {
                iFieldValue = OObjectSerializerHelper.multiValueToStream(iFieldValue, iType, iEntityManager, iObj2RecHandler, db, iSaveOnlyDirty);
            } else if (fieldClass.isEnum()) {
                iFieldValue = ((Enum)iFieldValue).name();
                iType = OType.STRING;
            } else if ((fieldClass = iEntityManager.getEntityClass(fieldClass.getSimpleName())) != null) {
                ODocument linkedDocument = (ODocument)iObj2RecHandler.getRecordByUserObject(iFieldValue, true);
                Object pojo = iFieldValue;
                iFieldValue = OObjectSerializerHelper.toStream(pojo, linkedDocument, iEntityManager, linkedDocument.getSchemaClass(), iObj2RecHandler, db, iSaveOnlyDirty);
                iObj2RecHandler.registerUserObject(pojo, linkedDocument);
            } else {
                throw new OSerializationException("Linked type [" + iFieldValue.getClass() + ":" + iFieldValue + "] can't be serialized because is not part of registered entities. To fix this error register this class");
            }
        }
        return iFieldValue;
    }

    private static Object multiValueToStream(Object iMultiValue, OType iType, OEntityManager iEntityManager, OUserObject2RecordHandler iObj2RecHandler, ODatabaseObjectTx db, boolean iSaveOnlyDirty) {
        OType linkedType;
        Collection sourceValues;
        if (iMultiValue == null) {
            return null;
        }
        if (iMultiValue instanceof Collection) {
            sourceValues = iMultiValue;
        } else {
            if (iMultiValue instanceof OLazyObjectMap) {
                ((OLazyObjectMap)((Object)iMultiValue)).assignDatabase(db);
            }
            sourceValues = ((Map)((Object)iMultiValue)).values();
        }
        if (iType == null) {
            if (sourceValues.size() == 0) {
                return iMultiValue;
            }
            Object firstValue = sourceValues.iterator().next();
            if (firstValue == null) {
                return iMultiValue;
            }
            iType = OType.isSimpleType(firstValue) ? (iMultiValue instanceof List ? OType.EMBEDDEDLIST : (iMultiValue instanceof Set ? OType.EMBEDDEDSET : OType.EMBEDDEDMAP)) : (iMultiValue instanceof List ? OType.LINKLIST : (iMultiValue instanceof Set ? OType.LINKSET : OType.LINKMAP));
        }
        HashMap result = iMultiValue;
        if (iType.equals((Object)OType.EMBEDDEDSET) || iType.equals((Object)OType.LINKSET)) {
            result = new HashSet();
        } else if (iType.equals((Object)OType.EMBEDDEDLIST) || iType.equals((Object)OType.LINKLIST)) {
            result = new ArrayList();
        }
        if (iType.equals((Object)OType.LINKLIST) || iType.equals((Object)OType.LINKSET) || iType.equals((Object)OType.LINKMAP)) {
            linkedType = OType.LINK;
        } else if (iType.equals((Object)OType.EMBEDDEDLIST) || iType.equals((Object)OType.EMBEDDEDSET) || iType.equals((Object)OType.EMBEDDEDMAP)) {
            linkedType = OType.EMBEDDED;
        } else {
            throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " must be a multi value type (collection or map)");
        }
        if (iMultiValue instanceof Set) {
            for (Object o : sourceValues) {
                ((Collection)((Object)result)).add(OObjectSerializerHelper.typeToStream(o, linkedType, iEntityManager, iObj2RecHandler, db, iSaveOnlyDirty));
            }
        } else if (iMultiValue instanceof List) {
            if (sourceValues instanceof OLazyObjectList) {
                ((OLazyObjectList)sourceValues).assignDatabase(db);
            }
            for (int i = 0; i < sourceValues.size(); ++i) {
                ((List)((Object)result)).add(OObjectSerializerHelper.typeToStream(((List)sourceValues).get(i), linkedType, iEntityManager, iObj2RecHandler, db, iSaveOnlyDirty));
            }
        } else if (iMultiValue instanceof OLazyObjectMap) {
            result = ((OLazyObjectMap)((Object)iMultiValue)).getUnderlying();
        } else {
            result = new HashMap();
            for (Map.Entry entry : ((Map)((Object)iMultiValue)).entrySet()) {
                ((Map)result).put(entry.getKey(), OObjectSerializerHelper.typeToStream(entry.getValue(), linkedType, iEntityManager, iObj2RecHandler, db, iSaveOnlyDirty));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Field> getClassFields(Class<?> iClass) {
        HashMap<String, List<Field>> hashMap = classes;
        synchronized (hashMap) {
            if (classes.containsKey(iClass.getName())) {
                return classes.get(iClass.getName());
            }
            ArrayList<Field> properties = new ArrayList<Field>();
            classes.put(iClass.getName(), properties);
            Class<Object> currentClass = iClass;
            while (currentClass != Object.class) {
                for (Field f : currentClass.getDeclaredFields()) {
                    Method m;
                    String getterName;
                    Object ann;
                    int fieldModifier = f.getModifiers();
                    if (Modifier.isStatic(fieldModifier) || Modifier.isNative(fieldModifier) || Modifier.isTransient(fieldModifier)) continue;
                    String fieldName = f.getName();
                    Class<?> fieldType = f.getType();
                    properties.add(f);
                    boolean autoBinding = true;
                    if (f.getAnnotation(OAccess.class) == null || f.getAnnotation(OAccess.class).value() == OAccess.OAccessType.PROPERTY) {
                        autoBinding = true;
                    } else if (jpaAccessClass != null && (ann = f.getAnnotation(jpaAccessClass)) != null) {
                        autoBinding = true;
                    }
                    if (f.getAnnotation(ODocumentInstance.class) != null) {
                        boundDocumentFields.put(iClass, fieldName);
                    }
                    boolean idFound = false;
                    if (f.getAnnotation(OId.class) != null) {
                        fieldIds.put(iClass, fieldName);
                        idFound = true;
                    } else if (jpaIdClass != null && f.getAnnotation(jpaIdClass) != null) {
                        fieldIds.put(iClass, fieldName);
                        idFound = true;
                    }
                    if (idFound) {
                        if (fieldType.isPrimitive()) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' can't be a literal to manage the Record Id", new Object[]{f.toString()});
                        } else if (!ORID.class.isAssignableFrom(fieldType) && fieldType != String.class && fieldType != Object.class && !Number.class.isAssignableFrom(fieldType)) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' can't be managed as type: %s", new Object[]{f.toString(), fieldType});
                        }
                    }
                    boolean vFound = false;
                    if (f.getAnnotation(OVersion.class) != null) {
                        fieldVersions.put(iClass, fieldName);
                        vFound = true;
                    } else if (jpaVersionClass != null && f.getAnnotation(jpaVersionClass) != null) {
                        fieldVersions.put(iClass, fieldName);
                        vFound = true;
                    }
                    if (vFound) {
                        if (fieldType.isPrimitive()) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' can't be a literal to manage the Version", new Object[]{f.toString()});
                        } else if (fieldType != String.class && fieldType != Object.class && !Number.class.isAssignableFrom(fieldType)) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' can't be managed as type: %s", new Object[]{f.toString(), fieldType});
                        }
                    }
                    if (autoBinding) {
                        try {
                            getterName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                            m = currentClass.getMethod(getterName, NO_ARGS);
                            getters.put(iClass.getName() + "." + fieldName, m);
                        }
                        catch (Exception e) {
                            OObjectSerializerHelper.registerFieldGetter(iClass, fieldName, f);
                        }
                    } else {
                        OObjectSerializerHelper.registerFieldGetter(iClass, fieldName, f);
                    }
                    if (autoBinding) {
                        try {
                            getterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                            m = currentClass.getMethod(getterName, f.getType());
                            setters.put(iClass.getName() + "." + fieldName, m);
                        }
                        catch (Exception e) {
                            OObjectSerializerHelper.registerFieldSetter(iClass, fieldName, f);
                        }
                        continue;
                    }
                    OObjectSerializerHelper.registerFieldSetter(iClass, fieldName, f);
                }
                OObjectSerializerHelper.registerCallbacks(iClass, currentClass);
                if (!(currentClass = currentClass.getSuperclass()).equals(ODocument.class)) continue;
                currentClass = Object.class;
            }
            return properties;
        }
    }

    private static void registerCallbacks(Class<?> iRootClass, Class<?> iCurrentClass) {
        for (Method m : iCurrentClass.getDeclaredMethods()) {
            for (Class<?> annotationClass : callbackAnnotationClasses) {
                if (m.getAnnotation(annotationClass) == null) continue;
                callbacks.put(iRootClass.getSimpleName() + "." + annotationClass.getSimpleName(), m);
            }
        }
    }

    public static void invokeCallback(Object iPojo, ODocument iDocument, Class<?> iAnnotation) {
        Method m = callbacks.get(iPojo.getClass().getSimpleName() + "." + iAnnotation.getSimpleName());
        if (m != null) {
            try {
                if (m.getParameterTypes().length > 0) {
                    m.invoke(iPojo, iDocument);
                } else {
                    m.invoke(iPojo, new Object[0]);
                }
            }
            catch (Exception e) {
                throw new OConfigurationException("Error on executing user callback '" + m.getName() + "' annotated with '" + iAnnotation.getSimpleName() + "'", e);
            }
        }
    }

    public static void bindSerializerContext(Class<?> iClassContext, OObjectSerializerContext iSerializerContext) {
        serializerContexts.put(iClassContext, iSerializerContext);
    }

    public static void unbindSerializerContext(Class<?> iClassContext) {
        serializerContexts.remove(iClassContext);
    }

    private static void registerFieldSetter(Class<?> iClass, String fieldName, Field f) {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        setters.put(iClass.getName() + "." + fieldName, f);
    }

    private static void registerFieldGetter(Class<?> iClass, String fieldName, Field f) {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        getters.put(iClass.getName() + "." + fieldName, f);
    }

    static {
        try {
            jpaIdClass = Class.forName("javax.persistence.Id");
            jpaVersionClass = Class.forName("javax.persistence.Version");
            jpaAccessClass = Class.forName("javax.persistence.Access");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

