/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.annotation.OAfterSerialization;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.object.ODatabaseObjectTx;
import com.orientechnologies.orient.core.db.object.OLazyObjectMap;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.entity.OEntityManagerInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORecordSerializerCSVAbstract
extends ORecordSerializerStringAbstract {
    public static final char FIELD_VALUE_SEPARATOR = ':';

    protected abstract ORecordSchemaAware<?> newObject(ODatabaseRecord var1, String var2);

    public Object fieldFromStream(ORecordInternal<?> iSourceRecord, OType iType, OClass iLinkedClass, OType iLinkedType, String iName, String iValue) {
        if (iValue == null) {
            return null;
        }
        ODatabaseRecord database = iSourceRecord.getDatabase();
        switch (iType) {
            case EMBEDDEDLIST: 
            case EMBEDDEDSET: {
                return this.embeddedCollectionFromStream(database, (ODocument)iSourceRecord, iType, iLinkedClass, iLinkedType, iValue);
            }
            case LINKLIST: 
            case LINKSET: {
                if (iValue.length() == 0) {
                    return null;
                }
                String value = iValue.startsWith("[") ? iValue.substring(1, iValue.length() - 1) : iValue;
                return iType == OType.LINKLIST ? new ORecordLazyList(iSourceRecord).setStreamedContent(new StringBuilder(value)) : new ORecordLazySet(iSourceRecord).setStreamedContent(new StringBuilder(value));
            }
            case LINKMAP: {
                if (iValue.length() == 0) {
                    return null;
                }
                String value = iValue.substring(1, iValue.length() - 1);
                ORecordLazyMap map = new ORecordLazyMap(iSourceRecord, 100);
                if (value.length() == 0) {
                    return map;
                }
                List<String> items = OStringSerializerHelper.smartSplit(value, ',', new char[0]);
                for (String item : items) {
                    List<String> entry;
                    if (item == null || item.length() <= 0 || (entry = OStringSerializerHelper.smartSplit(item, ':', new char[0])).size() <= 0) continue;
                    String mapValue = entry.get(1);
                    if (mapValue != null && mapValue.length() > 0) {
                        mapValue = mapValue.substring(1);
                    }
                    map.put(ORecordSerializerCSVAbstract.fieldTypeFromStream((ODocument)iSourceRecord, OType.STRING, entry.get(0)), new ORecordId(mapValue));
                }
                return map;
            }
            case EMBEDDEDMAP: {
                return this.embeddedMapFromStream((ODocument)iSourceRecord, iLinkedType, iValue);
            }
            case LINK: {
                if (iValue.length() > 1) {
                    int pos = iValue.indexOf("@");
                    if (pos > -1) {
                        iLinkedClass = database.getMetadata().getSchema().getClass(iValue.substring(1, pos));
                    } else {
                        pos = 0;
                    }
                    return new ORecordId(iValue.substring(pos + 1));
                }
                return null;
            }
            case EMBEDDED: {
                if (iValue.length() > 2) {
                    String value = iValue.substring(1, iValue.length() - 1);
                    return ORecordSerializerCSVAbstract.fieldTypeFromStream((ODocument)iSourceRecord, iType, value);
                }
                return null;
            }
        }
        return ORecordSerializerCSVAbstract.fieldTypeFromStream((ODocument)iSourceRecord, iType, iValue);
    }

    public Map<String, Object> embeddedMapFromStream(ODocument iSourceDocument, OType iLinkedType, String iValue) {
        if (iValue.length() == 0) {
            return null;
        }
        String value = iValue.substring(1, iValue.length() - 1);
        OTrackedMap map = iLinkedType == OType.LINK || iLinkedType == OType.EMBEDDED ? new ORecordLazyMap(iSourceDocument, 100) : new OTrackedMap(iSourceDocument);
        if (value.length() == 0) {
            return map;
        }
        List<String> items = OStringSerializerHelper.smartSplit(value, ',', new char[0]);
        if (map instanceof ORecordElement) {
            ((ORecordElement)map).setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        }
        for (String item : items) {
            Object mapValueObject;
            OType linkedType;
            List<String> entry;
            if (item == null || item.length() <= 0 || (entry = OStringSerializerHelper.smartSplit(item, ':', new char[0])).size() <= 0) continue;
            String mapValue = entry.get(1);
            if (iLinkedType == null) {
                if (mapValue.length() > 0) {
                    linkedType = ORecordSerializerCSVAbstract.getType(mapValue);
                    if (linkedType == OType.LINK && !(map instanceof ORecordLazyMap)) {
                        map = new ORecordLazyMap(iSourceDocument, 100);
                        ((ORecordElement)map).setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
                    }
                } else {
                    linkedType = OType.EMBEDDED;
                }
            } else {
                linkedType = iLinkedType;
            }
            if (linkedType == OType.EMBEDDED) {
                mapValue = mapValue.substring(1, mapValue.length() - 1);
            }
            if ((mapValueObject = ORecordSerializerCSVAbstract.fieldTypeFromStream(iSourceDocument, linkedType, mapValue)) != null && mapValueObject instanceof ODocument) {
                ((ODocument)mapValueObject).addOwner(iSourceDocument);
            }
            map.put(ORecordSerializerCSVAbstract.fieldTypeFromStream(iSourceDocument, OType.STRING, entry.get(0)), mapValueObject);
        }
        if (map instanceof ORecordElement) {
            ((ORecordElement)map).setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldToStream(ODocument iRecord, ODatabaseComplex<?> iDatabase, StringBuilder iOutput, OUserObject2RecordHandler iObjHandler, OType iType, OClass iLinkedClass, OType iLinkedType, String iName, Object iValue, Set<Integer> iMarshalledRecords, boolean iSaveOnlyDirty) {
        if (iValue == null) {
            return;
        }
        long timer = OProfiler.getInstance().startChrono();
        switch (iType) {
            case LINK: {
                OIdentifiable link = ORecordSerializerCSVAbstract.linkToStream(iOutput, iRecord, iValue);
                if (link != null) {
                    iRecord.field(iName, link);
                }
                OProfiler.getInstance().stopChrono("serializer.rec.str.link2string", timer);
                break;
            }
            case LINKLIST: {
                iOutput.append('[');
                if (iValue instanceof ORecordLazyList && ((ORecordLazyList)iValue).getStreamedContent() != null) {
                    iOutput.append((CharSequence)((ORecordLazyList)iValue).getStreamedContent());
                    OProfiler.getInstance().updateCounter("serializer.rec.str.linkList2string.cached", 1L);
                } else {
                    Iterator<OIdentifiable> it;
                    ORecordLazyList coll;
                    if (!(iValue instanceof ORecordLazyList)) {
                        coll = new ORecordLazyList(iRecord);
                        coll.addAll((Collection)iValue);
                        ((Collection)iValue).clear();
                        iRecord.field(iName, coll);
                        it = coll.rawIterator();
                    } else {
                        coll = (ORecordLazyList)iValue;
                        if (coll.getStreamedContent() != null) {
                            iOutput.append((CharSequence)coll.getStreamedContent());
                            OProfiler.getInstance().updateCounter("serializer.rec.str.linkList2string.cached", 1L);
                            it = coll.newItemsIterator();
                        } else {
                            it = coll.rawIterator();
                        }
                    }
                    if (it != null && it.hasNext()) {
                        StringBuilder buffer = new StringBuilder();
                        int items = 0;
                        while (it.hasNext()) {
                            if (items > 0) {
                                buffer.append(',');
                            }
                            OIdentifiable item = it.next();
                            ORecordSerializerCSVAbstract.linkToStream(buffer, iRecord, item);
                            ++items;
                        }
                        coll.convertRecords2Links();
                        iOutput.append((CharSequence)buffer);
                        coll.setStreamedContent(buffer);
                    }
                }
                iOutput.append(']');
                OProfiler.getInstance().stopChrono("serializer.rec.str.linkList2string", timer);
                break;
            }
            case LINKSET: {
                ORecordLazySet coll;
                if (!(iValue instanceof ORecordLazySet)) {
                    coll = new ORecordLazySet(iRecord);
                    coll.addAll((Collection)iValue);
                    ((Collection)iValue).clear();
                    iRecord.field(iName, coll);
                } else {
                    coll = (ORecordLazySet)iValue;
                }
                ORecordSerializerCSVAbstract.linkSetToStream(iOutput, iRecord, coll);
                OProfiler.getInstance().stopChrono("serializer.rec.str.linkSet2string", timer);
                break;
            }
            case LINKMAP: {
                iOutput.append('{');
                Map map = (Map)iValue;
                if (map instanceof OLazyObjectMap) {
                    ((OLazyObjectMap)map).setConvertToRecord(false);
                }
                boolean invalidMap = false;
                try {
                    int items = 0;
                    for (Map.Entry entry : map.entrySet()) {
                        if (items++ > 0) {
                            iOutput.append(',');
                        }
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iDatabase, OType.STRING, entry.getKey());
                        iOutput.append(':');
                        OIdentifiable link = ORecordSerializerCSVAbstract.linkToStream(iOutput, iRecord, entry.getValue());
                        if (link == null || invalidMap) continue;
                        invalidMap = true;
                    }
                    Object var21_27 = null;
                }
                catch (Throwable throwable) {
                    Object var21_28 = null;
                    if (map instanceof OLazyObjectMap) {
                        ((OLazyObjectMap)map).setConvertToRecord(true);
                    }
                    throw throwable;
                }
                if (map instanceof OLazyObjectMap) {
                    ((OLazyObjectMap)map).setConvertToRecord(true);
                }
                if (invalidMap) {
                    ORecordLazyMap newMap = new ORecordLazyMap(iRecord, 100);
                    for (Map.Entry entry : map.entrySet()) {
                        newMap.put(entry.getKey(), (OIdentifiable)entry.getValue());
                    }
                    map.clear();
                    iRecord.field(iName, newMap);
                }
                iOutput.append('}');
                OProfiler.getInstance().stopChrono("serializer.rec.str.linkMap2string", timer);
                break;
            }
            case EMBEDDED: {
                if (iValue instanceof ODocument) {
                    iOutput.append('(');
                    this.toString((ODocument)iValue, iOutput, null, iObjHandler, iMarshalledRecords, false);
                    iOutput.append(')');
                } else if (iValue != null) {
                    iOutput.append(iValue.toString());
                }
                OProfiler.getInstance().stopChrono("serializer.rec.str.embed2string", timer);
                break;
            }
            case EMBEDDEDLIST: {
                this.embeddedCollectionToStream(iDatabase, iObjHandler, iOutput, iLinkedClass, iLinkedType, iValue, iMarshalledRecords, iSaveOnlyDirty);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embedList2string", timer);
                break;
            }
            case EMBEDDEDSET: {
                this.embeddedCollectionToStream(iDatabase, iObjHandler, iOutput, iLinkedClass, iLinkedType, iValue, iMarshalledRecords, iSaveOnlyDirty);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embedSet2string", timer);
                break;
            }
            case EMBEDDEDMAP: {
                this.embeddedMapToStream(iDatabase, iObjHandler, iOutput, iLinkedClass, iLinkedType, iValue, iMarshalledRecords, iSaveOnlyDirty);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embedMap2string", timer);
                break;
            }
            default: {
                ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iDatabase, iType, iValue);
            }
        }
    }

    public static StringBuilder linkSetToStream(StringBuilder iOutput, ODocument iRecord, ORecordLazySet iSet) {
        Iterator<OIdentifiable> it;
        StringBuilder buffer;
        if (iSet.getStreamedContent() != null) {
            buffer = iSet.getStreamedContent();
            OProfiler.getInstance().updateCounter("serializer.rec.str.linkSet2string.cached", 1L);
            it = iSet.newItemsIterator();
        } else {
            buffer = new StringBuilder();
            it = iSet.rawIterator();
        }
        if (it != null && it.hasNext()) {
            int items = 0;
            while (it.hasNext()) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                OIdentifiable item = it.next();
                ORecordSerializerCSVAbstract.linkToStream(buffer, iRecord, item);
                ++items;
            }
        }
        iSet.convertRecords2Links();
        iOutput.append('[');
        iOutput.append((CharSequence)buffer);
        iOutput.append(']');
        iSet.setStreamedContent(buffer);
        return iOutput;
    }

    public void embeddedMapToStream(ODatabaseComplex<?> iDatabase, OUserObject2RecordHandler iObjHandler, StringBuilder iOutput, final OClass iLinkedClass, OType iLinkedType, Object iValue, Set<Integer> iMarshalledRecords, boolean iSaveOnlyDirty) {
        iOutput.append('{');
        if (iValue != null) {
            int items = 0;
            for (Map.Entry o : ((Map)iValue).entrySet()) {
                if (items > 0) {
                    iOutput.append(',');
                }
                if (o != null) {
                    ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iDatabase, OType.STRING, o.getKey());
                    iOutput.append(':');
                    if (o.getValue() instanceof ORecord) {
                        ODocument record = o.getValue() instanceof ODocument ? (ODocument)o.getValue() : OObjectSerializerHelper.toStream(o.getValue(), new ODocument((ODatabaseRecord)iDatabase, o.getValue().getClass().getSimpleName()), iDatabase instanceof ODatabaseObjectTx ? ((ODatabaseObjectTx)iDatabase).getEntityManager() : OEntityManagerInternal.INSTANCE, iLinkedClass, iObjHandler != null ? iObjHandler : new OUserObject2RecordHandler(){

                            @Override
                            public Object getUserObjectByRecord(ORecordInternal<?> iRecord, String iFetchPlan) {
                                return iRecord;
                            }

                            @Override
                            public ORecordInternal<?> getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
                                return new ODocument(iLinkedClass);
                            }

                            @Override
                            public boolean existsUserObjectByRID(ORID iRID) {
                                return false;
                            }

                            @Override
                            public void registerUserObject(Object iObject, ORecordInternal<?> iRecord) {
                            }
                        }, null, iSaveOnlyDirty);
                        iOutput.append('(');
                        this.toString(record, iOutput, null, iObjHandler, iMarshalledRecords, false);
                        iOutput.append(')');
                    } else if (o.getValue() instanceof Set) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iDatabase, OType.EMBEDDEDSET, o.getValue());
                    } else if (o.getValue() instanceof Collection) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iDatabase, OType.EMBEDDEDLIST, o.getValue());
                    } else if (o.getValue() instanceof Map) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iDatabase, OType.EMBEDDEDMAP, o.getValue());
                    } else {
                        if (iLinkedType == null) {
                            iLinkedType = OType.getTypeByClass(o.getValue().getClass());
                        }
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iDatabase, iLinkedType, o.getValue());
                    }
                }
                ++items;
            }
        }
        iOutput.append('}');
    }

    public Object embeddedCollectionFromStream(ODatabaseRecord iDatabase, ODocument iDocument, OType iType, OClass iLinkedClass, OType iLinkedType, String iValue) {
        char begin;
        AbstractCollection coll;
        String value;
        if (iValue.length() == 0) {
            return null;
        }
        String string = value = iValue.charAt(0) == '[' ? iValue.substring(1, iValue.length() - 1) : iValue;
        if (iLinkedType == OType.LINK) {
            Collection<OIdentifiable> coll2 = iDocument != null ? (iType == OType.EMBEDDEDLIST ? new ORecordLazyList(iDocument).setStreamedContent(new StringBuilder(value)) : new ORecordLazySet(iDocument).setStreamedContent(new StringBuilder(value))) : (iType == OType.EMBEDDEDLIST ? new ORecordLazyList(iDatabase).setStreamedContent(new StringBuilder(value)) : new ORecordLazySet(iDatabase).setStreamedContent(new StringBuilder(value)));
            return coll2;
        }
        AbstractCollection abstractCollection = coll = iType == OType.EMBEDDEDLIST ? new OTrackedList(iDocument) : new OTrackedSet(iDocument);
        if (value.length() == 0) {
            return coll;
        }
        if (iLinkedType == null && (begin = value.charAt(0)) == '#') {
            iLinkedType = OType.LINK;
        }
        if (coll instanceof ORecordElement) {
            ((ORecordElement)((Object)coll)).setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        }
        List<String> items = OStringSerializerHelper.smartSplit(value, ',', new char[0]);
        for (String item : items) {
            Object objectToAdd = null;
            if (item.length() > 2 && item.charAt(0) == '(') {
                if ((item = item.substring(1, item.length() - 1)).length() > 0) {
                    objectToAdd = (iLinkedClass = OStringSerializerHelper.getRecordClassName(iDatabase, item, iLinkedClass)) != null ? this.fromString(iDocument.getDatabase(), item, new ODocument(iDatabase, iLinkedClass.getName())) : ORecordSerializerCSVAbstract.fieldTypeFromStream(iDocument, iLinkedType, item);
                }
            } else {
                if (iLinkedType == null) {
                    throw new IllegalArgumentException("Linked type can't be null. Probably the serialized type has not stored the type along with data");
                }
                objectToAdd = ORecordSerializerCSVAbstract.fieldTypeFromStream(iDocument, iLinkedType, item);
            }
            if (objectToAdd == null) continue;
            if (objectToAdd instanceof ODocument && coll instanceof ORecordElement) {
                ((ODocument)objectToAdd).addOwner((ORecordElement)((Object)coll));
            }
            coll.add(objectToAdd);
        }
        if (coll instanceof ORecordElement) {
            ((ORecordElement)((Object)coll)).setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return coll;
    }

    public StringBuilder embeddedCollectionToStream(ODatabaseComplex<?> iDatabase, OUserObject2RecordHandler iObjHandler, StringBuilder iOutput, OClass iLinkedClass, OType iLinkedType, Object iValue, Set<Integer> iMarshalledRecords, boolean iSaveOnlyDirty) {
        iOutput.append('[');
        Iterator iterator = iValue instanceof Collection ? ((Collection)iValue).iterator() : null;
        int size = iValue instanceof Collection ? ((Collection)iValue).size() : Array.getLength(iValue);
        for (int i = 0; i < size; ++i) {
            OClass linkedClass;
            Object o = iValue instanceof Collection ? iterator.next() : Array.get(iValue, i);
            if (i > 0) {
                iOutput.append(',');
            }
            if (o == null) continue;
            OIdentifiable id = null;
            ODocument doc = null;
            if (!(o instanceof OIdentifiable)) {
                String fieldBound = OObjectSerializerHelper.getDocumentBoundField(o.getClass());
                if (fieldBound != null) {
                    OObjectSerializerHelper.invokeCallback(o, null, OBeforeSerialization.class);
                    doc = (ODocument)OObjectSerializerHelper.getFieldValue(o, fieldBound);
                    OObjectSerializerHelper.invokeCallback(o, doc, OAfterSerialization.class);
                    id = doc;
                }
                linkedClass = iLinkedClass;
            } else {
                id = (OIdentifiable)o;
                if (iLinkedType == null) {
                    iLinkedType = id.getIdentity().isValid() ? OType.LINK : OType.EMBEDDED;
                }
                if (id instanceof ODocument) {
                    doc = (ODocument)id;
                    if (id.getIdentity().isTemporary()) {
                        doc.save();
                    }
                    linkedClass = doc.getSchemaClass();
                } else {
                    linkedClass = null;
                }
            }
            if (id != null && iLinkedType != OType.LINK) {
                iOutput.append('(');
            }
            if (iLinkedType != OType.LINK && (linkedClass != null || doc != null)) {
                if (id == null) {
                    id = OObjectSerializerHelper.toStream(o, new ODocument((ODatabaseRecord)iDatabase, o.getClass().getSimpleName()), iDatabase instanceof ODatabaseObjectTx ? ((ODatabaseObjectTx)iDatabase).getEntityManager() : OEntityManagerInternal.INSTANCE, iLinkedClass, iObjHandler != null ? iObjHandler : new OUserObject2RecordHandler(){

                        @Override
                        public Object getUserObjectByRecord(ORecordInternal<?> iRecord, String iFetchPlan) {
                            return iRecord;
                        }

                        @Override
                        public ORecordInternal<?> getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
                            return new ODocument(linkedClass);
                        }

                        @Override
                        public boolean existsUserObjectByRID(ORID iRID) {
                            return false;
                        }

                        @Override
                        public void registerUserObject(Object iObject, ORecordInternal<?> iRecord) {
                        }
                    }, null, iSaveOnlyDirty);
                }
                this.toString(doc, iOutput, null, iObjHandler, iMarshalledRecords, false);
            } else {
                ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iDatabase, iLinkedType, o);
            }
            if (id == null || iLinkedType == OType.LINK) continue;
            iOutput.append(')');
        }
        iOutput.append(']');
        return iOutput;
    }

    private static OIdentifiable linkToStream(StringBuilder buffer, ORecordSchemaAware<?> iParentRecord, Object iLinked) {
        ORID rid;
        if (iLinked == null) {
            return null;
        }
        OIdentifiable resultRid = null;
        if (iLinked instanceof ORID) {
            rid = (ORID)iLinked;
            if (rid.isNew()) {
                ORecord<?> record = rid.getRecord();
                if (record.getDatabase().getTransaction().isActive()) {
                    OTransactionRecordEntry recordEntry = record.getDatabase().getTransaction().getRecordEntry(rid);
                    if (recordEntry != null) {
                        record.getDatabase().save((ORecordInternal)record, recordEntry.clusterName);
                    } else {
                        record.getDatabase().save((ORecordInternal)record);
                    }
                } else {
                    record.getDatabase().save((ORecordInternal)record);
                }
                rid = record.getIdentity();
            }
        } else {
            ODatabaseRecord db;
            String boundDocumentField;
            if (!(iLinked instanceof ORecordInternal) && (boundDocumentField = OObjectSerializerHelper.getDocumentBoundField(iLinked.getClass())) != null) {
                iLinked = OObjectSerializerHelper.getFieldValue(iLinked, boundDocumentField);
            }
            if (!(iLinked instanceof ORecordInternal)) {
                throw new IllegalArgumentException("Invalid object received. Expected a record but received type=" + iLinked.getClass().getName() + " and value=" + iLinked);
            }
            ORecordInternal iLinkedRecord = (ORecordInternal)iLinked;
            rid = iLinkedRecord.getIdentity();
            if (rid.isNew() || iLinkedRecord.isDirty()) {
                if (iLinkedRecord.getDatabase() == null && iParentRecord != null) {
                    iLinkedRecord.setDatabase(iParentRecord.getDatabase());
                }
                if (iLinkedRecord instanceof ODocument) {
                    OClass schemaClass = ((ODocument)iLinkedRecord).getSchemaClass();
                    iLinkedRecord.getDatabase().save(iLinkedRecord, schemaClass != null ? iLinkedRecord.getDatabase().getClusterNameById(schemaClass.getDefaultClusterId()) : null);
                } else {
                    iLinkedRecord.getDatabase().save(iLinkedRecord);
                }
                iLinkedRecord.getDatabase().registerUserObject(iLinkedRecord.getDatabase().getUserObjectByRecord(iLinkedRecord, null), iLinkedRecord);
                resultRid = iLinkedRecord;
            }
            if (iParentRecord != null && iParentRecord.getDatabase() instanceof ODatabaseRecord && !(db = iParentRecord.getDatabase()).isRetainRecords()) {
                resultRid = iLinkedRecord.getIdentity();
            }
        }
        if (rid.isValid()) {
            rid.toString(buffer);
        }
        return resultRid;
    }
}

