/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerHelper;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class OStreamSerializerAnyRecord
implements OStreamSerializer {
    public static final String NAME = "ar";
    public static final OStreamSerializerAnyRecord INSTANCE = new OStreamSerializerAnyRecord();

    public Object fromStream(ODatabaseRecord iDatabase, byte[] iStream) throws IOException {
        if (iStream == null || iStream.length == 0) {
            return null;
        }
        String stream = OBinaryProtocol.bytes2string(iStream);
        Class<?> cls = null;
        try {
            StringBuilder content = new StringBuilder();
            cls = OStreamSerializerHelper.readRecordType(stream, content);
            for (Constructor<?> c : cls.getDeclaredConstructors()) {
                Class<?>[] params = c.getParameterTypes();
                if (params.length != 2 || !params[0].isAssignableFrom(iDatabase.getClass()) || !params[1].equals(ORID.class)) continue;
                ORecord rec = (ORecord)c.newInstance(iDatabase, new ORecordId(content.toString()));
                return rec;
            }
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on unmarshalling content. Class %s", e, OSerializationException.class, new Object[]{cls.getName()});
        }
        OLogManager.instance().exception("Can'r unmarshall the record since the serialized object of class %s has no a constructor with right parameters: %s(%s, ORID)", null, OSerializationException.class, new Object[]{cls.getSimpleName(), cls.getSimpleName(), iDatabase.getClass().getSimpleName()});
        return null;
    }

    public byte[] toStream(ODatabaseRecord iDatabase, Object iObject) throws IOException {
        if (iObject == null) {
            return null;
        }
        if (((ORecord)iObject).getIdentity() == null) {
            throw new OSerializationException("Can't serialize record without identity. Store it before to serialize.");
        }
        StringBuilder buffer = OStreamSerializerHelper.writeRecordType(iObject.getClass(), new StringBuilder());
        buffer.append(((ORecord)iObject).getIdentity().toString());
        return OBinaryProtocol.string2bytes(buffer.toString());
    }

    public String getName() {
        return NAME;
    }
}

