/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.io.IOException;

public class OStreamSerializerRecord
implements OStreamSerializer {
    public static final String NAME = "l";
    public static final OStreamSerializerRecord INSTANCE = new OStreamSerializerRecord();

    public String getName() {
        return NAME;
    }

    public Object fromStream(ODatabaseRecord iDatabase, byte[] iStream) throws IOException {
        if (iStream == null || iStream.length == 0) {
            return null;
        }
        ORecordInternal<?> obj = Orient.instance().getRecordFactoryManager().newInstance(iDatabase);
        ORecordId rid = new ORecordId().fromStream(iStream);
        obj.setIdentity(rid.getClusterId(), rid.getClusterPosition());
        return obj;
    }

    public byte[] toStream(ODatabaseRecord iDatabase, Object iObject) throws IOException {
        if (iObject == null) {
            return null;
        }
        if (((ORecord)iObject).getIdentity() == null) {
            throw new OSerializationException("Can't serialize record without identity. Store it before to serialize.");
        }
        return ((ORecord)iObject).getIdentity().toStream();
    }
}

