/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.string;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStringSerializerAnyRuntime
implements OStringSerializer {
    public static final OStringSerializerAnyRuntime INSTANCE = new OStringSerializerAnyRuntime();
    private static final String NAME = "au";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object fromStream(ODatabaseComplex<?> iDatabase, String iStream) {
        if (iStream == null || iStream.length() == 0) {
            return null;
        }
        int pos = iStream.indexOf("|");
        if (pos < 0) {
            OLogManager.instance().error((Object)this, "Class signature not found in ANY element: " + iStream, OSerializationException.class);
        }
        String className = iStream.substring(0, pos);
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.getDeclaredConstructor(String.class).newInstance(iStream.substring(pos + 1));
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on unmarshalling content. Class: " + className, (Throwable)e, OSerializationException.class, new Object[0]);
            return null;
        }
    }

    @Override
    public StringBuilder toStream(ODatabaseComplex<?> iDatabase, StringBuilder iOutput, Object iObject) {
        if (iObject != null) {
            iOutput.append(iObject.getClass().getName());
            iOutput.append("|");
            iOutput.append(iObject.toString());
        }
        return iOutput;
    }
}

