/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLAlterCluster
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    protected String clusterName;
    protected int clusterId = -1;
    protected OCluster.ATTRIBUTES attribute;
    protected String value;

    public OCommandExecutorSQLAlterCluster parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 4);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_ALTER)) {
            throw new OCommandSQLParsingException("Keyword ALTER not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLUSTER)) {
            throw new OCommandSQLParsingException("Keyword CLUSTER not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>", this.text, oldPos);
        }
        this.clusterName = word.toString();
        Pattern p = Pattern.compile("([0-9]*)");
        Matcher m = p.matcher(this.clusterName);
        if (m.matches()) {
            this.clusterId = Integer.parseInt(this.clusterName);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos = pos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Missed the class's attribute to change", this.text, oldPos);
        }
        String attributeAsString = word.toString();
        try {
            this.attribute = OCluster.ATTRIBUTES.valueOf(attributeAsString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new OCommandSQLParsingException("Unknown class's attribute '" + attributeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OCluster.ATTRIBUTES.values()), this.text, oldPos);
        }
        this.value = this.text.substring(pos + 1).trim();
        if (this.value.length() == 0) {
            throw new OCommandSQLParsingException("Missed the property's value to change for attribute '" + (Object)((Object)this.attribute) + "'", this.text, oldPos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.attribute == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        OCluster cls = this.getCluster();
        if (cls == null) {
            throw new OCommandExecutionException("Cluster '" + this.clusterName + "' not found");
        }
        if (this.clusterId > -1 && this.clusterName.equals(String.valueOf(this.clusterId))) {
            this.clusterName = cls.getName();
        } else {
            this.clusterId = cls.getId();
        }
        try {
            cls.set(this.attribute, this.value);
        }
        catch (IOException ioe) {
            throw new OCommandExecutionException("Error altering cluster '" + this.clusterName + "'", ioe);
        }
        return null;
    }

    protected OCluster getCluster() {
        if (this.clusterId > -1) {
            return this.database.getStorage().getClusterById(this.clusterId);
        }
        return this.database.getStorage().getClusterById(this.database.getStorage().getClusterIdByName(this.clusterName));
    }
}

