/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLCreateClass
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_CLASS = "CLASS";
    public static final String KEYWORD_EXTENDS = "EXTENDS";
    private String className;
    private OClass superClass;
    private int[] clusterIds;

    public OCommandExecutorSQLCreateClass parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 1);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>", this.text, oldPos);
        }
        this.className = word.toString();
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class " + this.className + " already exists", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) > -1) {
            if (word.toString().equals(KEYWORD_EXTENDS)) {
                oldPos = pos;
                if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
                    throw new OCommandSQLParsingException("Syntax error after EXTENDS for class " + this.className + ". Expected the super-class name ", this.text, oldPos);
                }
                if (!this.database.getMetadata().getSchema().existsClass(word.toString())) {
                    throw new OCommandSQLParsingException("Super-class " + word + " not exists", this.text, oldPos);
                }
                this.superClass = this.database.getMetadata().getSchema().getClass(word.toString());
                oldPos = pos;
                pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false);
            }
            if (pos > -1) {
                String[] clusterIdsAsStrings = word.toString().split(",");
                if (clusterIdsAsStrings.length > 0) {
                    this.clusterIds = new int[clusterIdsAsStrings.length];
                    for (int i = 0; i < clusterIdsAsStrings.length; ++i) {
                        this.clusterIds[i] = Integer.parseInt(clusterIdsAsStrings[i]);
                        if (this.database.getStorage().getClusterById(this.clusterIds[i]) != null) continue;
                        throw new OCommandSQLParsingException("Cluster with id " + this.clusterIds[i] + " doesn't exists", this.text, oldPos);
                    }
                }
            } else {
                int clusterId = this.database.getStorage().getClusterIdByName(this.className);
                if (clusterId > -1) {
                    this.clusterIds = new int[]{clusterId};
                }
            }
        } else {
            int clusterId = this.database.getStorage().getClusterIdByName(this.className);
            if (clusterId > -1) {
                this.clusterIds = new int[]{clusterId};
            }
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.className == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        if (this.database.getMetadata().getSchema().existsClass(this.className)) {
            throw new OCommandExecutionException("Class " + this.className + " already exists");
        }
        OClassImpl sourceClass = (OClassImpl)((OSchemaProxy)this.database.getMetadata().getSchema()).createClassInternal(this.className, this.superClass, this.clusterIds);
        sourceClass.saveInternal();
        return this.database.getMetadata().getSchema().getClasses().size();
    }
}

