/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLDropClass
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_CLASS = "CLASS";
    private String className;

    public OCommandExecutorSQLDropClass parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 8);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found", this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found", this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>", this.text, pos);
        }
        this.className = word.toString();
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class is null", this.text, pos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.className == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        int clusterId = this.database.getMetadata().getSchema().getClass(this.className).getDefaultClusterId();
        ((OSchemaProxy)this.database.getMetadata().getSchema()).dropClassInternal(this.className);
        ((OSchemaProxy)this.database.getMetadata().getSchema()).saveInternal();
        this.deleteDefaultCluster(clusterId);
        return null;
    }

    protected void deleteDefaultCluster(int clusterId) {
        OCluster cluster = this.database.getStorage().getClusterById(clusterId);
        if (cluster.getName().equalsIgnoreCase(this.className) && this.isClusterDeletable(clusterId)) {
            this.database.getStorage().dropCluster(clusterId);
        }
    }

    protected boolean isClusterDeletable(int clusterId) {
        for (OClass iClass : this.database.getMetadata().getSchema().getClasses()) {
            for (int i : iClass.getClusterIds()) {
                if (i != clusterId) continue;
                return false;
            }
        }
        return true;
    }
}

