/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLRebuildIndex
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_REBUILD = "REBUILD";
    public static final String KEYWORD_INDEX = "INDEX";
    private String name;

    public OCommandExecutorSQLRebuildIndex parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 1);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_REBUILD)) {
            throw new OCommandSQLParsingException("Keyword REBUILD not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_INDEX)) {
            throw new OCommandSQLParsingException("Keyword INDEX not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected index name", this.text, oldPos);
        }
        this.name = word.toString();
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.name == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        if (this.name.equals("*")) {
            long totalIndexed = 0L;
            for (OIndex<?> idx : this.database.getMetadata().getIndexManager().getIndexes()) {
                if (!idx.isAutomatic()) continue;
                totalIndexed += idx.rebuild();
            }
            return totalIndexed;
        }
        OIndex<?> idx = this.database.getMetadata().getIndexManager().getIndex(this.name);
        if (idx == null) {
            throw new OCommandExecutionException("Index '" + this.name + "' not found");
        }
        if (!idx.isAutomatic()) {
            throw new OCommandExecutionException("Can't rebuild index '" + this.name + "' because it's manual and there aren't indications of what to index");
        }
        return idx.rebuild();
    }
}

