/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLTruncateClass
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_TRUNCATE = "TRUNCATE";
    public static final String KEYWORD_CLASS = "CLASS";
    private OClass schemaClass;

    public OCommandExecutorSQLTruncateClass parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 8);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_TRUNCATE)) {
            throw new OCommandSQLParsingException("Keyword TRUNCATE not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.text, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Expected class name", this.text, oldPos);
        }
        String className = word.toString();
        this.schemaClass = this.database.getMetadata().getSchema().getClass(className);
        if (this.schemaClass == null) {
            throw new OCommandSQLParsingException("Class '" + className + "' not found", this.text, oldPos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.schemaClass == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        long recs = this.schemaClass.count();
        try {
            this.schemaClass.truncate();
        }
        catch (IOException e) {
            throw new OCommandExecutionException("Error on executing command", e);
        }
        return recs;
    }
}

