/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLTruncateRecord
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_TRUNCATE = "TRUNCATE";
    public static final String KEYWORD_RECORD = "RECORD";
    private Set<String> records = new HashSet<String>();

    public OCommandExecutorSQLTruncateRecord parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 8);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_TRUNCATE)) {
            throw new OCommandSQLParsingException("Keyword TRUNCATE not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_RECORD)) {
            throw new OCommandSQLParsingException("Keyword RECORD not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.text, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Expected one or more records", this.text, oldPos);
        }
        if (word.charAt(0) == '[') {
            OStringSerializerHelper.getCollection(this.text, oldPos, this.records);
        } else {
            this.records.add(word.toString());
        }
        if (this.records.isEmpty()) {
            throw new OCommandSQLParsingException("Missed record(s)", this.text, oldPos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.records.isEmpty()) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        for (String rec : this.records) {
            try {
                ORecordId rid = new ORecordId(rec);
                this.database.getStorage().deleteRecord(rid, -1);
            }
            catch (Throwable e) {
                throw new OCommandExecutionException("Error on executing command", e);
            }
        }
        return this.records.size();
    }
}

