/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions;

import com.orientechnologies.orient.core.command.OCommandToParse;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSQLFunctionRuntime
extends OSQLFilterItemAbstract {
    public OSQLFunction function;
    public Object[] configuredParameters;
    public Object[] runtimeParameters;

    public OSQLFunctionRuntime(OCommandToParse iQueryToParse, String iText) {
        super(iQueryToParse, iText);
    }

    public boolean aggregateResults() {
        return this.function.aggregateResults(this.configuredParameters);
    }

    public boolean filterResult() {
        return this.function.filterResult();
    }

    public Object execute(ORecordSchemaAware<?> iRecord) {
        for (int i = 0; i < this.configuredParameters.length; ++i) {
            if (this.configuredParameters[i] instanceof OSQLFilterItemField) {
                this.runtimeParameters[i] = ((OSQLFilterItemField)this.configuredParameters[i]).getValue(iRecord);
                continue;
            }
            if (!(this.configuredParameters[i] instanceof OSQLFunctionRuntime)) continue;
            this.runtimeParameters[i] = ((OSQLFunctionRuntime)this.configuredParameters[i]).execute(iRecord);
        }
        Object functionResult = this.function.execute(iRecord, this.runtimeParameters);
        return this.transformValue(iRecord.getDatabase(), functionResult);
    }

    public Object getResult() {
        return this.transformValue(null, this.function.getResult());
    }

    public void setResult(Object iValue) {
        this.function.setResult(iValue);
    }

    @Override
    public Object getValue(ORecordInternal<?> iRecord) {
        return this.execute((ORecordSchemaAware)iRecord);
    }

    @Override
    public String getRoot() {
        return this.function.getName();
    }

    @Override
    protected void setRoot(OCommandToParse iQueryToParse, String iText) {
        int i;
        int beginParenthesis = iText.indexOf(40);
        String funcName = iText.substring(0, beginParenthesis);
        List<String> funcParamsText = OStringSerializerHelper.getParameters(iText);
        this.function = OSQLEngine.getInstance().getInlineFunction(funcName);
        if (this.function == null) {
            this.function = OSQLEngine.getInstance().getAggregationFunction(funcName);
        }
        if (this.function == null) {
            throw new OCommandSQLParsingException("Unknow function " + funcName + "()");
        }
        if (this.function.getMinParams() > -1 && funcParamsText.size() < this.function.getMinParams() || this.function.getMaxParams() > -1 && funcParamsText.size() > this.function.getMaxParams()) {
            throw new IllegalArgumentException("Syntax error. Expected: " + this.function.getSyntax());
        }
        this.configuredParameters = new Object[funcParamsText.size()];
        for (i = 0; i < funcParamsText.size(); ++i) {
            this.configuredParameters[i] = OSQLHelper.parseValue(null, iQueryToParse, funcParamsText.get(i));
        }
        this.runtimeParameters = new Object[this.configuredParameters.length];
        for (i = 0; i < this.configuredParameters.length; ++i) {
            if (this.configuredParameters[i] instanceof OSQLFilterItemField || this.configuredParameters[i] instanceof OSQLFunctionRuntime) continue;
            this.runtimeParameters[i] = this.configuredParameters[i];
        }
    }
}

