/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSQLFunctionSysdate
extends OSQLFunctionAbstract {
    public static final String NAME = "sysdate";
    private Date now = new Date();
    private SimpleDateFormat format;

    public OSQLFunctionSysdate() {
        super(NAME, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(ORecord<?> iCurrentRecord, Object[] iParameters) {
        if (iParameters.length == 0) {
            return this.now;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat((String)iParameters[0]);
        }
        SimpleDateFormat simpleDateFormat = this.format;
        synchronized (simpleDateFormat) {
            return this.format.format(this.now);
        }
    }

    @Override
    public boolean aggregateResults(Object[] configuredParameters) {
        return false;
    }

    @Override
    public String getSyntax() {
        return "Syntax error: sysdate([<format>])";
    }

    @Override
    public Object getResult() {
        this.format = null;
        return null;
    }
}

