/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OPropertyIndex;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryTargetOperator;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorContainsText
extends OQueryTargetOperator {
    private boolean ignoreCase = true;

    public OQueryOperatorContainsText(boolean iIgnoreCase) {
        super("CONTAINSTEXT", 5, false);
        this.ignoreCase = iIgnoreCase;
    }

    public OQueryOperatorContainsText() {
        super("CONTAINSTEXT", 5, false);
    }

    @Override
    public String getSyntax() {
        return "<left> CONTAINSTEXT[( noignorecase ] )] <right>";
    }

    @Override
    public Collection<OIdentifiable> filterRecords(ODatabaseComplex<?> iDatabase, List<String> iTargetClasses, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        String fieldName = iCondition.getLeft() instanceof OSQLFilterItemField ? iCondition.getLeft().toString() : iCondition.getRight().toString();
        String fieldValue = iCondition.getLeft() instanceof OSQLFilterItemField ? iCondition.getRight().toString() : iCondition.getLeft().toString();
        String className = iTargetClasses.get(0);
        OProperty prop = iDatabase.getMetadata().getSchema().getClass(className).getProperty(fieldName);
        if (prop == null) {
            return null;
        }
        OPropertyIndex index = prop.getIndex();
        if (index == null || !(index.getUnderlying() instanceof OIndexFullText)) {
            return null;
        }
        return (Collection)index.getUnderlying().get(fieldValue);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }
}

