/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorEquals
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorEquals() {
        super("=", 5, false);
    }

    @Override
    protected boolean evaluateExpression(ORecordInternal<?> iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        return OQueryOperatorEquals.equals(iLeft, iRight);
    }

    public static boolean equals(Object iLeft, Object iRight) {
        if (iLeft instanceof ORecord && iRight instanceof ORID) {
            return ((ORecord)iLeft).getIdentity().equals(iRight);
        }
        if (iRight instanceof ORecord && iLeft instanceof ORID) {
            return ((ORecord)iRight).getIdentity().equals(iLeft);
        }
        Object right = OType.convert(iRight, iLeft.getClass());
        if (right == null) {
            return false;
        }
        return iLeft.equals(right);
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iLeft instanceof OIdentifiable && iRight instanceof OIdentifiable) {
            return OIndexReuseType.NO_INDEX;
        }
        if (iRight == null || iLeft == null) {
            return OIndexReuseType.NO_INDEX;
        }
        return OIndexReuseType.INDEX_METHOD;
    }
}

