/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPhysicalPosition
implements OSerializableStream,
Comparable<OPhysicalPosition> {
    public int dataSegment;
    public long dataPosition;
    public byte type;
    public int version = 0;
    public int recordSize;

    public OPhysicalPosition() {
    }

    public OPhysicalPosition(int iDataSegment, long iPosition, byte iRecordType) {
        this.dataSegment = iDataSegment;
        this.dataPosition = iPosition;
        this.type = iRecordType;
    }

    public void copyTo(OPhysicalPosition iDest) {
        iDest.dataSegment = this.dataSegment;
        iDest.dataPosition = this.dataPosition;
        iDest.type = this.type;
        iDest.version = this.version;
        iDest.recordSize = this.recordSize;
    }

    public void copyFrom(OPhysicalPosition iSource) {
        iSource.copyTo(this);
    }

    public String toString() {
        return "dataSegment=" + this.dataSegment + ", recordPosition=" + this.dataPosition + ", type=" + this.type + ", recordSize=" + this.recordSize + ", v=" + this.version;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        int pos = 0;
        this.dataSegment = OBinaryProtocol.bytes2int(iStream, pos);
        this.dataPosition = OBinaryProtocol.bytes2long(iStream, pos += 4);
        this.type = iStream[pos += 8];
        this.recordSize = OBinaryProtocol.bytes2int(iStream, ++pos);
        this.version = OBinaryProtocol.bytes2int(iStream, pos += 4);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        byte[] buffer = new byte[21];
        int pos = 0;
        OBinaryProtocol.int2bytes(this.dataSegment, buffer, pos);
        OBinaryProtocol.long2bytes(this.dataPosition, buffer, pos += 4);
        buffer[pos += 8] = this.type;
        OBinaryProtocol.int2bytes(this.recordSize, buffer, ++pos);
        OBinaryProtocol.int2bytes(this.version, buffer, pos += 4);
        return buffer;
    }

    @Override
    public int compareTo(OPhysicalPosition iOther) {
        return (int)(this.dataPosition - iOther.dataPosition);
    }
}

