/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.resource.OSharedContainer;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface OStorage
extends OSharedContainer {
    public static final String CLUSTER_INTERNAL_NAME = "internal";
    public static final String CLUSTER_INDEX_NAME = "index";
    public static final String CLUSTER_DEFAULT_NAME = "default";
    public static final String DATA_DEFAULT_NAME = "default";

    public void open(String var1, String var2, Map<String, Object> var3);

    public void create(Map<String, Object> var1);

    public boolean exists();

    public void reload();

    public void delete();

    public void close();

    public void close(boolean var1);

    public boolean isClosed();

    public OLevel2RecordCache getLevel2Cache();

    public long createRecord(ORecordId var1, byte[] var2, byte var3);

    public ORawBuffer readRecord(ODatabaseRecord var1, ORecordId var2, String var3);

    public int updateRecord(ORecordId var1, byte[] var2, int var3, byte var4);

    public boolean deleteRecord(ORecordId var1, int var2);

    public void commit(OTransaction var1);

    public void rollback(OTransaction var1);

    public OStorageConfiguration getConfiguration();

    public int getClusters();

    public Set<String> getClusterNames();

    public OCluster getClusterById(int var1);

    public Collection<? extends OCluster> getClusterInstances();

    public int addCluster(String var1, CLUSTER_TYPE var2, Object ... var3);

    public boolean dropCluster(String var1);

    public boolean dropCluster(int var1);

    public int addDataSegment(String var1);

    public int addDataSegment(String var1, String var2);

    public long count(int var1);

    public long count(int[] var1);

    public long getSize();

    public long countRecords();

    public int getDefaultClusterId();

    public int getClusterIdByName(String var1);

    public String getClusterTypeByName(String var1);

    public String getPhysicalClusterNameById(int var1);

    public boolean checkForRecordValidity(OPhysicalPosition var1);

    public String getName();

    public String getURL();

    public long getVersion();

    public void synch();

    public int getUsers();

    public int addUser();

    public int removeUser();

    public Object command(OCommandRequestText var1);

    public long[] getClusterDataRange(int var1);

    public void renameCluster(String var1, String var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SIZE {
        TINY,
        MEDIUM,
        LARGE,
        HUGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CLUSTER_TYPE {
        PHYSICAL,
        LOGICAL,
        MEMORY;

    }
}

