/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.concur.resource.OSharedContainerImpl;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.concurrent.atomic.AtomicLong;

public abstract class OStorageAbstract
extends OSharedContainerImpl
implements OStorage {
    protected final String url;
    protected final String mode;
    protected OStorageConfiguration configuration;
    protected String name;
    protected AtomicLong version = new AtomicLong();
    protected OLevel2RecordCache level2Cache;
    protected volatile STATUS status = STATUS.CLOSED;
    protected OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());

    public OStorageAbstract(String iName, String iFilePath, String iMode) {
        this.name = OStringSerializerHelper.contains(iName, '/') ? iName.substring(iName.lastIndexOf("/") + 1) : iName;
        if (OStringSerializerHelper.contains(iName, ',')) {
            throw new IllegalArgumentException("Invalid character in storage name: " + this.name);
        }
        this.level2Cache = new OLevel2RecordCache(this);
        this.level2Cache.startup();
        this.url = iFilePath;
        this.mode = iMode;
    }

    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isClosed() {
        return this.status == STATUS.CLOSED;
    }

    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return ppos != null && ppos.version != -1;
    }

    public String getName() {
        return this.name;
    }

    public OLevel2RecordCache getLevel2Cache() {
        return this.level2Cache;
    }

    public String getURL() {
        return this.url;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean iForce) {
        if (!this.checkForClose(iForce)) {
            return;
        }
        for (Object resource : this.sharedResources.values()) {
            if (!(resource instanceof OCloseable)) continue;
            ((OCloseable)resource).close();
        }
        this.sharedResources.clear();
    }

    public long getVersion() {
        return this.version.get();
    }

    protected void incrementVersion() {
        this.version.incrementAndGet();
    }

    public boolean dropCluster(String iClusterName) {
        return this.dropCluster(this.getClusterIdByName(iClusterName));
    }

    protected boolean checkForClose(boolean iForce) {
        if (this.status == STATUS.CLOSED) {
            return false;
        }
        int remainingUsers = this.getUsers() > 0 ? this.removeUser() : 0;
        return iForce || !OGlobalConfiguration.STORAGE_KEEP_OPEN.getValueAsBoolean() && remainingUsers == 0;
    }

    public int getUsers() {
        return this.lock.getUsers();
    }

    public int addUser() {
        return this.lock.addUser();
    }

    public int removeUser() {
        return this.lock.removeUser();
    }

    public OSharedResourceAdaptive getLock() {
        return this.lock;
    }

    public long countRecords() {
        long tot = 0L;
        for (OCluster c : this.getClusterInstances()) {
            if (c == null) continue;
            tot += c.getEntries();
        }
        return tot;
    }

    public String toString() {
        return this.url != null ? this.url : "?";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum STATUS {
        CLOSED,
        OPEN,
        CLOSING;

    }
}

