/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public abstract class OFile {
    protected static final int SOFTLY_CLOSED_OFFSET = 8;
    private FileLock fileLock;
    protected File osFile;
    protected RandomAccessFile accessFile;
    protected FileChannel channel;
    protected int incrementSize = -50;
    protected int maxSize;
    protected int size;
    protected int filledUpTo;
    protected byte[] securityCode = new byte[32];
    protected String mode;
    protected static final int HEADER_SIZE = 1024;
    protected static final int HEADER_DATA_OFFSET = 128;
    protected static final int DEFAULT_SIZE = 15000000;
    protected static final int DEFAULT_INCREMENT_SIZE = -50;
    private static final int OPEN_RETRY_MAX = 10;
    private static final int OPEN_DELAY_RETRY = 100;
    private static final long LOCK_WAIT_TIME = 300L;
    private static final int LOCK_MAX_RETRIES = 10;

    public OFile(String iFileName, String iMode) throws IOException {
        this.init(iFileName, iMode);
    }

    protected abstract void writeHeader() throws IOException;

    protected abstract void readHeader() throws IOException;

    public abstract void writeHeaderLong(int var1, long var2) throws IOException;

    public abstract long readHeaderLong(int var1) throws IOException;

    protected abstract void setSoftlyClosed(boolean var1) throws IOException;

    protected abstract boolean isSoftlyClosed() throws IOException;

    public abstract void synch();

    public abstract void read(long var1, byte[] var3, int var4) throws IOException;

    public abstract short readShort(long var1) throws IOException;

    public abstract int readInt(long var1) throws IOException;

    public abstract long readLong(long var1) throws IOException;

    public abstract byte readByte(long var1) throws IOException;

    public abstract void writeInt(long var1, int var3) throws IOException;

    public abstract void writeLong(long var1, long var3) throws IOException;

    public abstract void writeShort(long var1, short var3) throws IOException;

    public abstract void writeByte(long var1, byte var3) throws IOException;

    public abstract void write(long var1, byte[] var3) throws IOException;

    public boolean open() throws IOException {
        boolean softlyClosed;
        if (!this.osFile.exists() || this.osFile.length() == 0L) {
            throw new FileNotFoundException("File: " + this.osFile.getAbsolutePath());
        }
        this.openChannel((int)this.osFile.length());
        OLogManager.instance().debug((Object)this, "Checking file integrity of " + this.osFile.getName() + "...", new Object[0]);
        int fileSize = this.size;
        this.readHeader();
        if (this.filledUpTo > 0 && this.filledUpTo > this.size) {
            OLogManager.instance().warn((Object)this, "Invalid OFile.filledUp value (%d). Reset the file size %d to the os file size: %d. Probably the file was not closed correctly last time", new Object[]{this.filledUpTo, this.size, fileSize});
            this.size = fileSize;
            this.writeHeader();
        }
        if (this.filledUpTo > this.size || this.filledUpTo < 0) {
            OLogManager.instance().error((Object)this, "Invalid filledUp size (=" + this.filledUpTo + "). The file could be corrupted", null, OStorageException.class, new Object[0]);
        }
        if (softlyClosed = this.isSoftlyClosed()) {
            this.setSoftlyClosed(false);
        }
        return softlyClosed;
    }

    public void create(int iStartSize) throws IOException {
        if (iStartSize == -1) {
            iStartSize = 15000000;
        }
        this.openChannel(iStartSize);
        this.filledUpTo = 0;
        this.writeHeader();
        this.setSoftlyClosed(false);
    }

    public void close() throws IOException {
        try {
            if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                this.unlock();
            }
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
                this.channel = null;
            }
            if (this.accessFile != null) {
                this.accessFile.close();
                this.accessFile = null;
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on closing file " + this.osFile.getAbsolutePath(), (Throwable)e, OIOException.class, new Object[0]);
        }
    }

    public void delete() throws IOException {
        this.close();
        if (this.osFile != null) {
            boolean deleted = this.osFile.delete();
            while (!deleted) {
                OMemoryWatchDog.freeMemory(100L);
                deleted = this.osFile.delete();
            }
        }
    }

    public void lock() throws IOException {
        for (int i = 0; i < 10; ++i) {
            try {
                this.fileLock = this.channel.tryLock(0L, 1L, false);
                break;
            }
            catch (OverlappingFileLockException e) {
                OLogManager.instance().debug((Object)this, "Can't open file '" + this.osFile.getAbsolutePath() + "' because it's locked. Waiting %d ms and retry %d/%d...", new Object[]{300L, i, 10});
                OMemoryWatchDog.freeMemory(300L);
                continue;
            }
        }
        if (this.fileLock == null) {
            throw new OLockException("File '" + this.osFile.getPath() + "' is locked by another process, maybe the database is in use by another process. Use the remote mode with a OrientDB server to allow multiple access to the same database.");
        }
    }

    public void unlock() throws IOException {
        if (this.fileLock != null) {
            try {
                this.fileLock.release();
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
            this.fileLock = null;
        }
    }

    public void changeSize(int iSize) {
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Changing file size to " + iSize + " bytes. " + this.toString(), new Object[0]);
        }
        if (iSize < this.filledUpTo) {
            OLogManager.instance().error((Object)this, "You can't size down the file to " + iSize + " bytes, since it's minor of than current space used: " + this.filledUpTo + " bytes", OIOException.class);
        }
    }

    public void removeTail(int iSize) throws IOException {
        if (this.filledUpTo < iSize) {
            iSize = 0;
        }
        this.filledUpTo -= iSize;
        this.writeHeader();
    }

    public void shrink(int iSize) throws IOException {
        if (iSize > this.filledUpTo) {
            return;
        }
        OLogManager.instance().debug((Object)this, "Shrinking filled file from " + this.filledUpTo + " to " + iSize + " bytes. " + this.toString(), new Object[0]);
        this.filledUpTo = iSize;
        this.writeHeader();
    }

    public int allocateSpace(int iSize) throws IOException {
        int offset = this.filledUpTo;
        if (this.getFreeSpace() < iSize) {
            int stepSizeInBytes;
            if (this.maxSize > 0 && this.maxSize - this.size < iSize) {
                throw new IllegalArgumentException("Can't enlarge file since the configured max size (" + OFileUtils.getSizeAsString((long)this.maxSize) + ") was reached! " + this.toString());
            }
            int newFileSize = this.size;
            int n = stepSizeInBytes = this.incrementSize > 0 ? this.incrementSize : -1 * this.size / 100 * this.incrementSize;
            while (newFileSize - this.filledUpTo <= iSize) {
                if (stepSizeInBytes > 0 && (this.maxSize == 0 || newFileSize + stepSizeInBytes < this.maxSize)) {
                    newFileSize += stepSizeInBytes;
                    continue;
                }
                newFileSize = this.maxSize;
            }
            this.changeSize(newFileSize);
        }
        this.filledUpTo += iSize;
        this.writeHeader();
        return offset;
    }

    protected long checkRegions(long iOffset, int iLength) {
        if (iOffset + (long)iLength > (long)this.filledUpTo) {
            throw new OIOException("You can't access outside the file size (" + this.filledUpTo + " bytes). You've requested portion " + iOffset + "-" + (iOffset + (long)iLength) + " bytes. File: " + this.toString());
        }
        return iOffset;
    }

    public int getFreeSpace() {
        return this.size - this.filledUpTo;
    }

    public int getFileSize() {
        return this.size;
    }

    public int getFilledUpTo() {
        return this.filledUpTo;
    }

    public boolean canOversize(int iRecordSize) {
        return this.maxSize - this.size > iRecordSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("File: ");
        builder.append(this.osFile.getName());
        if (this.accessFile != null) {
            builder.append(" os-size=");
            try {
                builder.append(this.accessFile.length());
            }
            catch (IOException e) {
                builder.append("?");
            }
        }
        builder.append(", stored=");
        builder.append(this.size);
        builder.append(", filled=");
        builder.append(this.filledUpTo);
        builder.append(", max=");
        builder.append(this.maxSize);
        builder.append("");
        return builder.toString();
    }

    public File getOsFile() {
        return this.osFile;
    }

    protected void init(String iFileName, String iMode) throws IOException {
        this.mode = iMode;
        this.osFile = new File(iFileName);
    }

    protected void openChannel(int iNewSize) throws IOException {
        OLogManager.instance().debug((Object)this, "[OFile.openChannel] Opening channel for file: " + this.osFile, new Object[0]);
        for (int i = 0; i < 10; ++i) {
            try {
                this.accessFile = new RandomAccessFile(this.osFile, this.mode);
                break;
            }
            catch (FileNotFoundException e) {
                if (i == 100) {
                    throw e;
                }
                this.osFile.getParentFile().mkdirs();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        this.accessFile.setLength(iNewSize);
        this.accessFile.seek(0L);
        this.channel = this.accessFile.getChannel();
        if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
            this.lock();
        }
        this.size = this.maxSize > 0 && iNewSize > this.maxSize ? this.maxSize : iNewSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public void setIncrementSize(int incrementSize) {
        this.incrementSize = incrementSize;
    }

    public boolean isOpen() {
        return this.accessFile != null;
    }

    public boolean exists() {
        return this.osFile != null && this.osFile.exists();
    }
}

