/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.storage.fs.OFile;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OFileClassic
extends OFile {
    protected ByteBuffer internalWriteBuffer = this.getBuffer(8);

    public OFileClassic(String iFileName, String iMode) throws IOException {
        super(iFileName, iMode);
    }

    public void close() throws IOException {
        this.setSoftlyClosed(true);
        if (this.internalWriteBuffer != null) {
            this.internalWriteBuffer = null;
        }
        super.close();
    }

    public void read(long iOffset, byte[] iDestBuffer, int iLenght) throws IOException {
        iOffset = this.checkRegions(iOffset, iLenght);
        ByteBuffer buffer = ByteBuffer.wrap(iDestBuffer);
        this.channel.read(buffer, iOffset);
    }

    public int readInt(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 4);
        return this.readData(iOffset, 4).getInt();
    }

    public long readLong(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 8);
        return this.readData(iOffset, 8).getLong();
    }

    public short readShort(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 2);
        return this.readData(iOffset, 2).getShort();
    }

    public byte readByte(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 1);
        return this.readData(iOffset, 1).get();
    }

    public void writeInt(long iOffset, int iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 4);
        ByteBuffer buffer = this.getWriteBuffer(4);
        buffer.putInt(iValue);
        this.writeData(buffer, iOffset);
    }

    public void writeLong(long iOffset, long iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 8);
        ByteBuffer buffer = this.getWriteBuffer(8);
        buffer.putLong(iValue);
        this.writeData(buffer, iOffset);
    }

    public void writeShort(long iOffset, short iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 4);
        ByteBuffer buffer = this.getWriteBuffer(2);
        buffer.putShort(iValue);
        this.writeData(buffer, iOffset);
    }

    public void writeByte(long iOffset, byte iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 1);
        ByteBuffer buffer = this.getWriteBuffer(1);
        buffer.put(iValue);
        this.writeData(buffer, iOffset);
    }

    public void write(long iOffset, byte[] iSourceBuffer) throws IOException {
        iOffset = this.checkRegions(iOffset, iSourceBuffer.length);
        this.channel.write(ByteBuffer.wrap(iSourceBuffer), iOffset);
    }

    public void changeSize(int iSize) {
        super.changeSize(iSize);
        try {
            this.channel.force(false);
            this.channel.close();
            this.openChannel(iSize);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on changing the file size to " + iSize + " bytes", (Throwable)e, OIOException.class, new Object[0]);
        }
    }

    public void synch() {
    }

    protected void readHeader() throws IOException {
        this.size = this.readData(0L, 4).getInt();
        this.filledUpTo = this.readData(4L, 4).getInt();
    }

    protected void writeHeader() throws IOException {
        ByteBuffer buffer = this.getWriteBuffer(8);
        buffer.putInt(this.size);
        buffer.putInt(this.filledUpTo);
        this.writeData(buffer, 0L);
    }

    public void writeHeaderLong(int iPosition, long iValue) throws IOException {
        ByteBuffer buffer = this.getWriteBuffer(8);
        buffer.putLong(iValue);
        this.writeData(buffer, 128 + iPosition);
    }

    public long readHeaderLong(int iPosition) throws IOException {
        return this.readData(128 + iPosition, 8).getLong();
    }

    public boolean isSoftlyClosed() throws IOException {
        return this.readData(8L, 1).get() == 1;
    }

    protected void setSoftlyClosed(boolean iValue) throws IOException {
        ByteBuffer buffer = this.getWriteBuffer(1);
        buffer.put((byte)(iValue ? 1 : 0));
        this.writeData(buffer, 8L);
        this.synch();
    }

    private ByteBuffer readData(long iOffset, int iSize) throws IOException {
        ByteBuffer buffer = this.getBuffer(iSize);
        this.channel.read(buffer, iOffset);
        buffer.rewind();
        return buffer;
    }

    private void writeData(ByteBuffer iBuffer, long iOffset) throws IOException {
        iBuffer.rewind();
        this.channel.write(iBuffer, iOffset);
    }

    private ByteBuffer getBuffer(int iLenght) {
        return ByteBuffer.allocate(iLenght);
    }

    private ByteBuffer getWriteBuffer(int iLenght) {
        if (iLenght <= 8) {
            return (ByteBuffer)this.internalWriteBuffer.rewind();
        }
        return this.getBuffer(iLenght);
    }
}

