/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import java.io.IOException;

public class OFileFactory {
    public static final String MMAP = "mmap";
    public static final String CLASSIC = "classic";

    public static OFile create(TYPE iType, String iFileName, String iOpenMode) throws IOException {
        return OFileFactory.create(iType.toString(), iFileName, iOpenMode);
    }

    public static OFile create(String iType, String iFileName, String iOpenMode) throws IOException {
        if (iType.equals(MMAP)) {
            return new OFileMMap(iFileName, iOpenMode);
        }
        if (iType.equals(CLASSIC)) {
            return new OFileClassic(iFileName, iOpenMode);
        }
        throw new IllegalArgumentException("Type " + iType + " not supported");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        MMAP,
        CLASSIC;

    }
}

