/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OMMapBufferEntry;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class OFileMMap
extends OFile {
    protected MappedByteBuffer headerBuffer;
    protected int bufferBeginOffset = -1;
    protected int bufferSize = 0;
    protected List<ByteBuffer> bufferPool = new ArrayList<ByteBuffer>(10);
    private static int BYTEBUFFER_POOLABLE_SIZE;
    private static OMMapManager.ALLOC_STRATEGY strategy;

    public OFileMMap(String iFileName, String iMode) throws IOException {
        super(iFileName, iMode);
        BYTEBUFFER_POOLABLE_SIZE = OGlobalConfiguration.FILE_MMAP_BUFFER_SIZE.getValueAsInteger();
        strategy = OMMapManager.ALLOC_STRATEGY.values()[OGlobalConfiguration.FILE_MMAP_STRATEGY.getValueAsInteger()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(long iOffset, byte[] iDestBuffer, int iLenght) throws IOException {
        OMMapBufferEntry entry = OMMapManager.request(this, iOffset = this.checkRegions(iOffset, iLenght), iLenght, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entry != null) {
            MappedByteBuffer mappedByteBuffer = entry.buffer;
            synchronized (mappedByteBuffer) {
                entry.buffer.position((int)(iOffset - entry.beginOffset));
                entry.buffer.get(iDestBuffer, 0, iLenght);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(iLenght);
            this.channel.read(buffer, iOffset + 1024L);
            buffer.rewind();
            buffer.get(iDestBuffer);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt(long iOffset) throws IOException {
        OMMapBufferEntry entry = OMMapManager.request(this, iOffset = this.checkRegions(iOffset, 4), 4, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entry != null) {
            MappedByteBuffer mappedByteBuffer = entry.buffer;
            synchronized (mappedByteBuffer) {
                return entry.buffer.getInt((int)(iOffset - entry.beginOffset));
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(4);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        int value = buffer.getInt();
        this.releaseByteBuffer(buffer);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong(long iOffset) throws IOException {
        OMMapBufferEntry entry = OMMapManager.request(this, iOffset = this.checkRegions(iOffset, 8), 8, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entry != null) {
            MappedByteBuffer mappedByteBuffer = entry.buffer;
            synchronized (mappedByteBuffer) {
                return entry.buffer.getLong((int)(iOffset - entry.beginOffset));
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(8);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        long value = buffer.getLong();
        this.releaseByteBuffer(buffer);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort(long iOffset) throws IOException {
        OMMapBufferEntry entry = OMMapManager.request(this, iOffset = this.checkRegions(iOffset, 2), 2, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entry != null) {
            MappedByteBuffer mappedByteBuffer = entry.buffer;
            synchronized (mappedByteBuffer) {
                return entry.buffer.getShort((int)(iOffset - entry.beginOffset));
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(2);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        short value = buffer.getShort();
        this.releaseByteBuffer(buffer);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte(long iOffset) throws IOException {
        OMMapBufferEntry entry = OMMapManager.request(this, iOffset = this.checkRegions(iOffset, 1), 1, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entry != null) {
            MappedByteBuffer mappedByteBuffer = entry.buffer;
            synchronized (mappedByteBuffer) {
                return entry.buffer.get((int)(iOffset - entry.beginOffset));
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(1);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        byte value = buffer.get();
        this.releaseByteBuffer(buffer);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInt(long iOffset, int iValue) throws IOException {
        OMMapBufferEntry entry = OMMapManager.request(this, iOffset = this.checkRegions(iOffset, 4), 4, OMMapManager.OPERATION_TYPE.WRITE, strategy);
        if (entry != null) {
            MappedByteBuffer mappedByteBuffer = entry.buffer;
            synchronized (mappedByteBuffer) {
                entry.buffer.putInt((int)(iOffset - entry.beginOffset), iValue);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(4);
            buffer.putInt(iValue);
            buffer.rewind();
            this.channel.write(buffer, iOffset + 1024L);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLong(long iOffset, long iValue) throws IOException {
        OMMapBufferEntry entry = OMMapManager.request(this, iOffset = this.checkRegions(iOffset, 8), 8, OMMapManager.OPERATION_TYPE.WRITE, strategy);
        if (entry != null) {
            MappedByteBuffer mappedByteBuffer = entry.buffer;
            synchronized (mappedByteBuffer) {
                entry.buffer.putLong((int)(iOffset - entry.beginOffset), iValue);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(8);
            buffer.putLong(iValue);
            buffer.rewind();
            this.channel.write(buffer, iOffset + 1024L);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeShort(long iOffset, short iValue) throws IOException {
        OMMapBufferEntry entry = OMMapManager.request(this, iOffset = this.checkRegions(iOffset, 2), 2, OMMapManager.OPERATION_TYPE.WRITE, strategy);
        if (entry != null) {
            MappedByteBuffer mappedByteBuffer = entry.buffer;
            synchronized (mappedByteBuffer) {
                entry.buffer.putShort((int)(iOffset - entry.beginOffset), iValue);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(2);
            buffer.putShort(iValue);
            buffer.rewind();
            this.channel.write(buffer, iOffset + 1024L);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeByte(long iOffset, byte iValue) throws IOException {
        OMMapBufferEntry entry = OMMapManager.request(this, iOffset = this.checkRegions(iOffset, 1), 1, OMMapManager.OPERATION_TYPE.WRITE, strategy);
        if (entry != null) {
            MappedByteBuffer mappedByteBuffer = entry.buffer;
            synchronized (mappedByteBuffer) {
                entry.buffer.put((int)(iOffset - entry.beginOffset), iValue);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(1);
            buffer.put(iValue);
            buffer.rewind();
            this.channel.write(buffer, iOffset + 1024L);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long iOffset, byte[] iSourceBuffer) throws IOException {
        block7: {
            if (iSourceBuffer.length == 0) {
                return;
            }
            iOffset = this.checkRegions(iOffset, iSourceBuffer.length);
            try {
                OMMapBufferEntry entry = OMMapManager.request(this, iOffset, iSourceBuffer.length, OMMapManager.OPERATION_TYPE.WRITE, strategy);
                if (entry != null) {
                    MappedByteBuffer mappedByteBuffer = entry.buffer;
                    synchronized (mappedByteBuffer) {
                        entry.buffer.position((int)(iOffset - entry.beginOffset));
                        entry.buffer.put(iSourceBuffer);
                        break block7;
                    }
                }
                ByteBuffer buffer = this.acquireByteBuffer(iSourceBuffer.length);
                buffer.put(iSourceBuffer);
                buffer.rewind();
                this.channel.write(buffer, iOffset + 1024L);
                this.releaseByteBuffer(buffer);
            }
            catch (BufferOverflowException e) {
                OLogManager.instance().error((Object)this, "Error on write in the range " + iOffset + "-" + (iOffset + (long)iSourceBuffer.length) + "." + this.toString(), (Throwable)e, OIOException.class, new Object[0]);
            }
        }
    }

    public void changeSize(int iSize) {
        super.changeSize(iSize);
        this.size = iSize;
    }

    public void synch() {
        this.headerBuffer.force();
    }

    protected void readHeader() {
        this.headerBuffer.rewind();
        this.size = this.headerBuffer.getInt();
        this.filledUpTo = this.headerBuffer.getInt();
    }

    protected void writeHeader() {
        this.headerBuffer.rewind();
        this.headerBuffer.putInt(this.size);
        this.headerBuffer.putInt(this.filledUpTo);
    }

    public void writeHeaderLong(int iPosition, long iValue) {
        if (this.headerBuffer != null) {
            this.headerBuffer.putLong(128 + iPosition, iValue);
        }
    }

    public long readHeaderLong(int iPosition) {
        return this.headerBuffer.getLong(128 + iPosition);
    }

    public void close() throws IOException {
        if (this.headerBuffer != null) {
            this.setSoftlyClosed(true);
            this.headerBuffer = null;
        }
        super.close();
        OMMapManager.flush();
    }

    public boolean isSoftlyClosed() {
        return this.headerBuffer.get(8) == 1;
    }

    protected void setSoftlyClosed(boolean iValue) {
        if (this.headerBuffer == null) {
            return;
        }
        this.headerBuffer.put(8, (byte)(iValue ? 1 : 0));
        this.synch();
    }

    MappedByteBuffer map(long iBeginOffset, int iSize) throws IOException {
        return this.channel.map(this.mode.equals("r") ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, iBeginOffset + 1024L, iSize);
    }

    protected void openChannel(int iNewSize) throws IOException {
        super.openChannel(iNewSize);
        this.headerBuffer = this.channel.map(this.mode.equals("r") ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, 1024L);
    }

    public boolean isClosed() {
        return this.headerBuffer == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer acquireByteBuffer(int iSize) {
        ByteBuffer buffer;
        if (iSize > BYTEBUFFER_POOLABLE_SIZE) {
            return ByteBuffer.allocateDirect(iSize);
        }
        OFileMMap oFileMMap = this;
        synchronized (oFileMMap) {
            buffer = this.bufferPool.isEmpty() ? ByteBuffer.allocate(BYTEBUFFER_POOLABLE_SIZE) : this.bufferPool.remove(0);
        }
        buffer.limit(iSize);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void releaseByteBuffer(ByteBuffer iBuffer) {
        if (iBuffer.limit() > BYTEBUFFER_POOLABLE_SIZE) {
            return;
        }
        iBuffer.rewind();
        OFileMMap oFileMMap = this;
        synchronized (oFileMMap) {
            this.bufferPool.add(iBuffer);
        }
    }
}

