/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMMapBufferEntry
implements Comparable<OMMapBufferEntry> {
    static Class<?> sunClass = null;
    OFileMMap file;
    MappedByteBuffer buffer;
    long beginOffset;
    int size;
    long counter;
    boolean pin;

    public OMMapBufferEntry(OFileMMap iFile, MappedByteBuffer buffer, long beginOffset, int size) {
        this.file = iFile;
        this.buffer = buffer;
        this.beginOffset = beginOffset;
        this.size = size;
        this.counter = 0L;
        this.pin = false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OMMapBufferEntry [file=").append(this.file).append(", beginOffset=").append(this.beginOffset).append(", size=").append(this.size).append("]");
        return builder.toString();
    }

    public void close() {
        if (this.file != null) {
            if (!this.file.isClosed()) {
                try {
                    this.file.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.file = null;
        }
        if (this.buffer != null && sunClass != null) {
            try {
                Method m = sunClass.getMethod("cleaner", new Class[0]);
                Object cleaner = m.invoke((Object)this.buffer, new Object[0]);
                cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on calling MMap buffer clean", (Throwable)e, new Object[0]);
            }
        }
        this.buffer = null;
        this.counter = 0L;
    }

    @Override
    public int compareTo(OMMapBufferEntry iOther) {
        return (int)(this.beginOffset - iOther.beginOffset);
    }
}

