/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import com.orientechnologies.orient.core.storage.fs.OMMapBufferEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMMapManager {
    private static final long MIN_MEMORY = 50000000L;
    private static final int FORCE_DELAY;
    private static final int FORCE_RETRY;
    private static OVERLAP_STRATEGY overlapStrategy;
    private static ALLOC_STRATEGY lastStrategy;
    private static int blockSize;
    private static long maxMemory;
    private static long totalMemory;
    private static List<OMMapBufferEntry> bufferPoolLRU;
    private static Map<OFileMMap, List<OMMapBufferEntry>> bufferPoolPerFile;

    public static OMMapBufferEntry request(OFileMMap iFile, long iBeginOffset, int iSize, OPERATION_TYPE iOperationType, ALLOC_STRATEGY iStrategy) {
        return OMMapManager.request(iFile, iBeginOffset, iSize, false, iOperationType, iStrategy);
    }

    public static synchronized OMMapBufferEntry request(OFileMMap iFile, long iBeginOffset, int iSize, boolean iForce, OPERATION_TYPE iOperationType, ALLOC_STRATEGY iStrategy) {
        int position;
        if (iStrategy == ALLOC_STRATEGY.MMAP_NEVER) {
            return null;
        }
        lastStrategy = iStrategy;
        OMMapBufferEntry entry = OMMapManager.searchBetweenLastBlocks(iFile, iBeginOffset, iSize);
        if (entry != null) {
            return entry;
        }
        List<OMMapBufferEntry> fileEntries = bufferPoolPerFile.get(iFile);
        if (fileEntries == null) {
            fileEntries = new ArrayList<OMMapBufferEntry>();
            bufferPoolPerFile.put(iFile, fileEntries);
        }
        if ((position = OMMapManager.searchEntry(fileEntries, iBeginOffset, iSize)) > -1) {
            return fileEntries.get(position);
        }
        int p = (position + 2) * -1;
        if (!OMMapManager.allocIfOverlaps(iBeginOffset, iSize, fileEntries, p)) {
            OProfiler.getInstance().updateCounter("OMMapManager.usedChannel", 1L);
            return null;
        }
        int bufferSize = OMMapManager.computeBestEntrySize(iFile, iBeginOffset, iSize, iForce, fileEntries, p);
        if (totalMemory + (long)bufferSize > maxMemory && (iStrategy == ALLOC_STRATEGY.MMAP_ONLY_AVAIL_POOL || iOperationType == OPERATION_TYPE.READ && iStrategy == ALLOC_STRATEGY.MMAP_WRITE_ALWAYS_READ_IF_AVAIL_POOL)) {
            OProfiler.getInstance().updateCounter("OMMapManager.usedChannel", 1L);
            return null;
        }
        entry = null;
        do {
            if (totalMemory + (long)bufferSize > maxMemory) {
                OMMapManager.freeResources();
            }
            if ((position = OMMapManager.searchEntry(fileEntries = bufferPoolPerFile.get(iFile), iBeginOffset, iSize)) > -1) {
                return fileEntries.get(position);
            }
            try {
                entry = OMMapManager.mapBuffer(iFile, iBeginOffset, bufferSize);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                maxMemory = maxMemory * 90L / 100L;
                OLogManager.instance().warn(OMMapManager.class, "Memory mapping error, try to reduce max memory to %d and retry...", (Throwable)e, new Object[]{maxMemory});
            }
        } while (entry == null && maxMemory > 50000000L);
        if (entry == null) {
            throw new OIOException("You can't access to the file portion " + iBeginOffset + "-" + iBeginOffset + iSize + " bytes");
        }
        totalMemory += (long)bufferSize;
        bufferPoolLRU.add(entry);
        p = (position + 2) * -1;
        if (p < 0) {
            p = 0;
        }
        if (fileEntries == null) {
            fileEntries = new ArrayList<OMMapBufferEntry>();
            bufferPoolPerFile.put(iFile, fileEntries);
        }
        fileEntries.add(p, entry);
        return entry;
    }

    private static void freeResources() {
        long memoryThreshold = (long)((double)maxMemory * 0.75);
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug(null, "Free mmmap blocks, at least %d MB...", new Object[]{(totalMemory - memoryThreshold) / 1000000L});
        }
        Collections.sort(bufferPoolLRU, new Comparator<OMMapBufferEntry>(){

            @Override
            public int compare(OMMapBufferEntry o1, OMMapBufferEntry o2) {
                return (int)(o1.counter - o2.counter);
            }
        });
        Iterator<OMMapBufferEntry> it = bufferPoolLRU.iterator();
        while (it.hasNext()) {
            OMMapBufferEntry entry = it.next();
            if (entry.pin) continue;
            OMMapManager.removeEntry(it, entry);
            if (totalMemory >= memoryThreshold) continue;
            break;
        }
    }

    private static OMMapBufferEntry searchBetweenLastBlocks(OFileMMap iFile, long iBeginOffset, int iSize) {
        if (bufferPoolLRU.size() > 0) {
            int min = Math.max(bufferPoolLRU.size() - 5, -1);
            for (int i = bufferPoolLRU.size() - 1; i > min; --i) {
                OMMapBufferEntry e = bufferPoolLRU.get(i);
                if (e.file != iFile || iBeginOffset < e.beginOffset || iBeginOffset + (long)iSize > e.beginOffset + (long)e.size) continue;
                OProfiler.getInstance().updateCounter("OMMapManager.reusedPageBetweenLast", 1L);
                ++e.counter;
                return e;
            }
        }
        return null;
    }

    public static synchronized void flush() {
        Iterator<OMMapBufferEntry> it = bufferPoolLRU.iterator();
        while (it.hasNext()) {
            OMMapBufferEntry entry = it.next();
            if (entry.file == null || !entry.file.isClosed()) continue;
            OMMapManager.removeEntry(it, entry);
            entry.close();
        }
    }

    private static boolean removeEntry(Iterator<OMMapBufferEntry> it, OMMapBufferEntry entry) {
        if (OMMapManager.commitBuffer(entry)) {
            it.remove();
            List<OMMapBufferEntry> file = bufferPoolPerFile.get(entry.file);
            if (file != null) {
                file.remove(entry);
                if (file.isEmpty()) {
                    bufferPoolPerFile.remove(entry.file);
                }
            }
            entry.buffer = null;
            totalMemory -= (long)entry.size;
            return true;
        }
        return false;
    }

    public static synchronized void removeFile(OFile file) throws IOException {
        List<OMMapBufferEntry> entries = bufferPoolPerFile.remove(file);
        if (entries != null) {
            for (OMMapBufferEntry entry : entries) {
                bufferPoolLRU.remove(entry);
                entry.close();
            }
            entries.clear();
        }
    }

    public static synchronized void shutdown() {
        for (OMMapBufferEntry entry : new ArrayList<OMMapBufferEntry>(bufferPoolLRU)) {
            entry.close();
        }
        bufferPoolLRU.clear();
        bufferPoolPerFile.clear();
        totalMemory = 0L;
    }

    public static long getMaxMemory() {
        return maxMemory;
    }

    public static void setMaxMemory(long iMaxMemory) {
        maxMemory = iMaxMemory;
    }

    public static long getTotalMemory() {
        return totalMemory;
    }

    public static int getBlockSize() {
        return blockSize;
    }

    public static void setBlockSize(int blockSize) {
        OMMapManager.blockSize = blockSize;
    }

    public static OVERLAP_STRATEGY getOverlapStrategy() {
        return overlapStrategy;
    }

    public static void setOverlapStrategy(int overlapStrategy) {
        OMMapManager.overlapStrategy = OVERLAP_STRATEGY.values()[overlapStrategy];
    }

    public static void setOverlapStrategy(OVERLAP_STRATEGY overlapStrategy) {
        OMMapManager.overlapStrategy = overlapStrategy;
    }

    public static synchronized int getOverlappedBlocks() {
        int count = 0;
        for (OFileMMap f : bufferPoolPerFile.keySet()) {
            count += OMMapManager.getOverlappedBlocks(f);
        }
        return count;
    }

    public static synchronized int getOverlappedBlocks(OFile iFile) {
        int count = 0;
        List<OMMapBufferEntry> blocks = bufferPoolPerFile.get(iFile);
        long lastPos = -1L;
        for (OMMapBufferEntry block : blocks) {
            if (lastPos > -1L && lastPos > block.beginOffset) {
                OLogManager.instance().warn(null, "Found overlapped block for file %s at position %d. Previous offset+size was %d", new Object[]{iFile, block.beginOffset, lastPos});
                ++count;
            }
            lastPos = block.beginOffset + (long)block.size;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OMMapBufferEntry mapBuffer(OFileMMap iFile, long iBeginOffset, int iSize) throws IOException {
        long timer = OProfiler.getInstance().startChrono();
        try {
            OMMapBufferEntry oMMapBufferEntry = new OMMapBufferEntry(iFile, iFile.map(iBeginOffset, iSize), iBeginOffset, iSize);
            return oMMapBufferEntry;
        }
        finally {
            OProfiler.getInstance().stopChrono("OMMapManager.loadPage", timer);
        }
    }

    private static int searchEntry(List<OMMapBufferEntry> fileEntries, long iBeginOffset, int iSize) {
        if (fileEntries == null || fileEntries.size() == 0) {
            return -1;
        }
        int high = fileEntries.size() - 1;
        if (high < 0) {
            return -1;
        }
        int low = 0;
        int mid = -1;
        while (low <= high) {
            mid = low + high >>> 1;
            OMMapBufferEntry e = fileEntries.get(mid);
            if (iBeginOffset >= e.beginOffset && iBeginOffset + (long)iSize <= e.beginOffset + (long)e.size) {
                OProfiler.getInstance().updateCounter("OMMapManager.reusedPage", 1L);
                ++e.counter;
                return mid;
            }
            if (low == high) {
                if (iBeginOffset > e.beginOffset) {
                    ++low;
                }
                return (low + 2) * -1;
            }
            if (iBeginOffset >= e.beginOffset) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return mid;
    }

    protected static boolean commitBuffer(OMMapBufferEntry iEntry) {
        long timer = OProfiler.getInstance().startChrono();
        boolean forceSucceed = false;
        for (int i = 0; i < FORCE_RETRY; ++i) {
            try {
                iEntry.buffer.force();
                forceSucceed = true;
                break;
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)iEntry, "Can't write memory buffer to disk. Retrying (" + (i + 1) + "/" + FORCE_RETRY + ")...", new Object[0]);
                OMemoryWatchDog.freeMemory(FORCE_DELAY);
                continue;
            }
        }
        if (!forceSucceed) {
            OLogManager.instance().debug((Object)iEntry, "Can't commit memory buffer to disk after %d retries", new Object[]{FORCE_RETRY});
        } else {
            OProfiler.getInstance().updateCounter("OMMapManager.pagesCommitted", 1L);
        }
        OProfiler.getInstance().stopChrono("OMMapManager.commitPages", timer);
        return forceSucceed;
    }

    private static boolean allocIfOverlaps(long iBeginOffset, int iSize, List<OMMapBufferEntry> fileEntries, int p) {
        if (overlapStrategy == OVERLAP_STRATEGY.OVERLAP) {
            return true;
        }
        boolean overlaps = false;
        OMMapBufferEntry entry = null;
        if (p > 0) {
            entry = fileEntries.get(p - 1);
            boolean bl = overlaps = entry.beginOffset <= iBeginOffset && entry.beginOffset + (long)entry.size >= iBeginOffset;
        }
        if (!overlaps && p < fileEntries.size() - 1) {
            entry = fileEntries.get(p);
            boolean bl = overlaps = iBeginOffset + (long)iSize >= entry.beginOffset;
        }
        if (overlaps) {
            OProfiler.getInstance().updateCounter("OMMapManager.overlappedPageUsingChannel", 1L);
            if (overlapStrategy == OVERLAP_STRATEGY.NO_OVERLAP_FLUSH_AND_USE_CHANNEL) {
                OMMapManager.commitBuffer(entry);
            }
            return false;
        }
        return true;
    }

    private static int computeBestEntrySize(OFileMMap iFile, long iBeginOffset, int iSize, boolean iForce, List<OMMapBufferEntry> fileEntries, int p) {
        int bufferSize;
        if (p > -1 && p < fileEntries.size()) {
            bufferSize = (int)(fileEntries.get((int)p).beginOffset - iBeginOffset);
            if (bufferSize < iSize) {
                bufferSize = iSize;
            }
            if (bufferSize < blockSize) {
                bufferSize = blockSize;
            }
        } else {
            int n = iForce ? iSize : (bufferSize = iSize < blockSize ? blockSize : iSize);
            if (iBeginOffset + (long)bufferSize > (long)iFile.getFileSize()) {
                bufferSize = (int)((long)iFile.getFileSize() - iBeginOffset);
            }
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Invalid range requested for file " + iFile + ". Requested " + iSize + " bytes from the address " + iBeginOffset + " while the total file size is " + iFile.getFileSize());
        }
        return bufferSize;
    }

    static {
        bufferPoolLRU = new ArrayList<OMMapBufferEntry>();
        bufferPoolPerFile = new HashMap<OFileMMap, List<OMMapBufferEntry>>();
        blockSize = OGlobalConfiguration.FILE_MMAP_BLOCK_SIZE.getValueAsInteger();
        FORCE_DELAY = OGlobalConfiguration.FILE_MMAP_FORCE_DELAY.getValueAsInteger();
        FORCE_RETRY = OGlobalConfiguration.FILE_MMAP_FORCE_RETRY.getValueAsInteger();
        maxMemory = OGlobalConfiguration.FILE_MMAP_MAX_MEMORY.getValueAsLong();
        OMMapManager.setOverlapStrategy(OGlobalConfiguration.FILE_MMAP_OVERLAP_STRATEGY.getValueAsInteger());
        OProfiler.getInstance().registerHookValue("mmap.totalMemory", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return totalMemory;
            }
        });
        OProfiler.getInstance().registerHookValue("mmap.maxMemory", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return maxMemory;
            }
        });
        OProfiler.getInstance().registerHookValue("mmap.blockSize", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return blockSize;
            }
        });
        OProfiler.getInstance().registerHookValue("mmap.blocks", new OProfiler.OProfilerHookValue(){

            public synchronized Object getValue() {
                return bufferPoolLRU.size();
            }
        });
        OProfiler.getInstance().registerHookValue("mmap.alloc.strategy", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return lastStrategy;
            }
        });
        OProfiler.getInstance().registerHookValue("mmap.overlap.strategy", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return overlapStrategy;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OVERLAP_STRATEGY {
        NO_OVERLAP_USE_CHANNEL,
        NO_OVERLAP_FLUSH_AND_USE_CHANNEL,
        OVERLAP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ALLOC_STRATEGY {
        MMAP_ALWAYS,
        MMAP_WRITE_ALWAYS_READ_IF_AVAIL_POOL,
        MMAP_WRITE_ALWAYS_READ_IF_IN_MEM,
        MMAP_ONLY_AVAIL_POOL,
        MMAP_NEVER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OPERATION_TYPE {
        READ,
        WRITE;

    }
}

