/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.orient.core.config.OStorageClusterHoleConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfiguration;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterPositionIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocalHole;
import com.orientechnologies.orient.core.storage.impl.local.OMultiFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.File;
import java.io.IOException;

public class OClusterLocal
extends OMultiFileSegment
implements OCluster {
    private static final String DEF_EXTENSION = ".ocl";
    private static final int RECORD_SIZE = 15;
    private static final int DEF_SIZE = 1000000;
    public static final String TYPE = "PHYSICAL";
    private int id;
    private long beginOffsetData = -1L;
    private long endOffsetData = -1L;
    protected final OClusterLocalHole holeSegment;

    public OClusterLocal(OStorageLocal iStorage, OStoragePhysicalClusterConfiguration iConfig) throws IOException {
        super(iStorage, iConfig, DEF_EXTENSION, 15);
        this.id = iConfig.getId();
        iConfig.holeFile = new OStorageClusterHoleConfiguration(iConfig, "${STORAGE_PATH}/" + iConfig.name, iConfig.fileType, iConfig.fileMaxSize);
        this.holeSegment = new OClusterLocalHole(this, iStorage, iConfig.holeFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(int iStartSize) throws IOException {
        this.acquireExclusiveLock();
        try {
            if (iStartSize == -1) {
                iStartSize = 1000000;
            }
            super.create(iStartSize);
            this.holeSegment.create();
            this.files[0].writeHeaderLong(0, this.beginOffsetData);
            this.files[0].writeHeaderLong(8, this.beginOffsetData);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            super.open();
            this.holeSegment.open();
            this.beginOffsetData = this.files[0].readHeaderLong(0);
            this.endOffsetData = this.files[0].readHeaderLong(8);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.acquireExclusiveLock();
        try {
            super.close();
            this.holeSegment.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.truncate();
            for (OFile file : this.files) {
                OMMapManager.removeFile(file);
                file.delete();
            }
            this.files = null;
            this.holeSegment.delete();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate() throws IOException {
        this.acquireExclusiveLock();
        try {
            long begin = this.getFirstEntryPosition();
            long end = this.getLastEntryPosition();
            OPhysicalPosition ppos = new OPhysicalPosition();
            for (long i = begin; i <= end; ++i) {
                this.getPhysicalPosition(i, ppos);
                if (!this.storage.checkForRecordValidity(ppos)) continue;
                this.storage.getDataSegment(ppos.dataSegment).deleteRecord(ppos.dataPosition);
            }
            super.truncate();
            this.holeSegment.truncate();
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    public void set(OCluster.ATTRIBUTES iAttribute, Object iValue) throws IOException {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (iAttribute) {
            case NAME: {
                this.setNameInternal(stringValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition getPhysicalPosition(long iPosition, OPhysicalPosition iPPosition) throws IOException {
        OPhysicalPosition oPhysicalPosition;
        iPosition *= 15L;
        this.acquireSharedLock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            OFile file = this.files[(int)pos[0]];
            long p = pos[1];
            iPPosition.dataSegment = file.readShort(p);
            iPPosition.dataPosition = file.readLong(p += 2L);
            iPPosition.type = file.readByte(p += 8L);
            iPPosition.version = file.readInt(++p);
            oPhysicalPosition = iPPosition;
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return oPhysicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalPosition(long iPosition, int iDataId, long iDataPosition, byte iRecordType, int iVersion) throws IOException {
        iPosition *= 15L;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            OFile file = this.files[(int)pos[0]];
            long p = pos[1];
            file.writeShort(p, (short)iDataId);
            file.writeLong(p += 2L, iDataPosition);
            file.writeByte(p += 8L, iRecordType);
            file.writeInt(++p, iVersion);
            Object var13_9 = null;
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalPosition(long iPosition, long iDataPosition) throws IOException {
        iPosition *= 15L;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            OFile file = this.files[(int)pos[0]];
            long p = pos[1];
            file.writeLong(p += 2L, iDataPosition);
            Object var10_6 = null;
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVersion(long iPosition, int iVersion) throws IOException {
        iPosition *= 15L;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            this.files[(int)pos[0]].writeInt(pos[1] + 2L + 8L + 1L, iVersion);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecordType(long iPosition, byte iRecordType) throws IOException {
        iPosition *= 15L;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            this.files[(int)pos[0]].writeByte(pos[1] + 2L + 8L, iRecordType);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhysicalPosition(long iPosition, OPhysicalPosition iPPosition) throws IOException {
        long position = iPosition * 15L;
        this.acquireExclusiveLock();
        try {
            long[] fetchPos;
            long currentPos;
            long[] pos = this.getRelativePosition(position);
            OFile file = this.files[(int)pos[0]];
            long p = pos[1];
            iPPosition.dataSegment = file.readShort(p);
            iPPosition.dataPosition = file.readLong(p += 2L);
            iPPosition.type = file.readByte(p += 8L);
            iPPosition.version = file.readInt(++p);
            this.holeSegment.pushPosition(position);
            file.writeInt(p, -1);
            if (iPosition == this.beginOffsetData) {
                if (this.getEntries() == 0L) {
                    this.beginOffsetData = -1L;
                } else {
                    ++this.beginOffsetData;
                    for (currentPos = position + 15L; currentPos < this.getFilledUpTo() && this.files[(int)(fetchPos = this.getRelativePosition(currentPos))[0]].readShort(fetchPos[1]) == -1; currentPos += 15L) {
                        ++this.beginOffsetData;
                    }
                }
                this.files[0].writeHeaderLong(0, this.beginOffsetData);
            }
            if (iPosition == this.endOffsetData) {
                if (this.getEntries() == 0L) {
                    this.endOffsetData = -1L;
                } else {
                    --this.endOffsetData;
                    for (currentPos = position - 15L; currentPos >= this.beginOffsetData && this.files[(int)(fetchPos = this.getRelativePosition(currentPos))[0]].readShort(fetchPos[1]) == -1; currentPos -= 15L) {
                        --this.endOffsetData;
                    }
                }
                this.files[0].writeHeaderLong(8, this.endOffsetData);
            }
            Object var14_9 = null;
        }
        catch (Throwable throwable) {
            Object var14_10 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHole(long iPosition) throws IOException {
        boolean bl;
        this.acquireExclusiveLock();
        try {
            bl = this.holeSegment.removeEntryWithPosition(iPosition * 15L);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addPhysicalPosition(int iDataSegmentId, long iPosition, byte iRecordType) throws IOException {
        long l;
        this.acquireExclusiveLock();
        try {
            long[] pos;
            long offset = this.holeSegment.popLastEntryPosition();
            if (offset > -1L) {
                pos = this.getRelativePosition(offset);
            } else {
                pos = this.allocateSpace(15);
                offset = this.getAbsolutePosition(pos);
            }
            OFile file = this.files[(int)pos[0]];
            long p = pos[1];
            file.writeShort(p, (short)iDataSegmentId);
            file.writeLong(p += 2L, iPosition);
            file.writeByte(p += 8L, iRecordType);
            long returnedPosition = offset / 15L;
            if (returnedPosition < this.beginOffsetData || this.beginOffsetData == -1L) {
                this.beginOffsetData = returnedPosition;
                this.files[0].writeHeaderLong(0, this.beginOffsetData);
            }
            if (this.endOffsetData > -1L && returnedPosition > this.endOffsetData) {
                this.endOffsetData = returnedPosition;
                this.files[0].writeHeaderLong(8, this.endOffsetData);
            }
            l = returnedPosition;
            Object var16_10 = null;
        }
        catch (Throwable throwable) {
            Object var16_11 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstEntryPosition() throws IOException {
        long l;
        this.acquireSharedLock();
        try {
            l = this.beginOffsetData;
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastEntryPosition() throws IOException {
        long l;
        this.acquireSharedLock();
        try {
            l = this.endOffsetData > -1L ? this.endOffsetData : this.getFilledUpTo() / 15L - 1L;
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntries() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.getFilledUpTo() / 15L - (long)this.holeSegment.getHoles();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    public int getId() {
        return this.id;
    }

    public OClusterPositionIterator absoluteIterator() throws IOException {
        return new OClusterPositionIterator(this);
    }

    public OClusterPositionIterator absoluteIterator(long iBeginRange, long iEndRange) throws IOException {
        return new OClusterPositionIterator(this, iBeginRange, iEndRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        long l;
        this.acquireSharedLock();
        try {
            l = super.getFilledUpTo();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    public String toString() {
        return this.name + " (id=" + this.id + ")";
    }

    public void lock() {
        this.acquireSharedLock();
    }

    public void unlock() {
        this.releaseSharedLock();
    }

    public String getType() {
        return TYPE;
    }

    public long getRecordsSize() throws IOException {
        long size = 0L;
        OClusterPositionIterator it = this.absoluteIterator();
        OPhysicalPosition pos = new OPhysicalPosition();
        while (it.hasNext()) {
            Long position = it.next();
            pos = this.getPhysicalPosition(position, pos);
            if (pos.dataPosition <= -1L) continue;
            size += (long)this.storage.getDataSegment(pos.dataSegment).getRecordSize(pos.dataPosition);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNameInternal(String iNewName) {
        if (this.storage.getClusterIdByName(iNewName) > -1) {
            throw new IllegalArgumentException("Cluster with name '" + iNewName + "' already exists");
        }
        this.acquireExclusiveLock();
        try {
            for (int i = 0; i < this.files.length; ++i) {
                File osFile = this.files[i].getOsFile();
                if (!osFile.getName().startsWith(this.name)) continue;
                File newFile = new File(this.storage.getStoragePath() + "/" + iNewName + osFile.getName().substring(osFile.getName().lastIndexOf(this.name) + this.name.length()));
                for (OStorageFileConfiguration conf : this.config.infoFiles) {
                    if (conf.parent.name.equals(this.name)) {
                        conf.parent.name = iNewName;
                    }
                    if (!conf.path.endsWith(osFile.getName())) continue;
                    conf.path = new String(conf.path.replace(osFile.getName(), newFile.getName()));
                }
                boolean renamed = osFile.renameTo(newFile);
                while (!renamed) {
                    OMemoryWatchDog.freeMemory(100L);
                    renamed = osFile.renameTo(newFile);
                }
            }
            this.config.name = iNewName;
            this.holeSegment.rename(this.name, iNewName);
            this.storage.renameCluster(this.name, iNewName);
            this.name = iNewName;
            this.storage.getConfiguration().update();
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }
}

