/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.File;
import java.io.IOException;

public class OClusterLocalHole
extends OSingleFileSegment {
    private static final int DEF_START_SIZE = 262144;
    private static final int RECORD_SIZE = 8;
    private OClusterLocal owner;

    public OClusterLocalHole(OClusterLocal iClusterLocal, OStorageLocal iStorage, OStorageFileConfiguration iConfig) throws IOException {
        super(iStorage, iConfig);
        this.owner = iClusterLocal;
    }

    public void defrag() throws IOException {
        OLogManager.instance().debug((Object)this, "Starting to defragment the segment %s of size=%d and filled=%d", new Object[]{this.file, this.file.getFileSize(), this.file.getFilledUpTo()});
        OLogManager.instance().debug((Object)this, "Defragmentation ended for segment %s. Current size=%d and filled=%d", new Object[]{this.file, this.file.getFileSize(), this.file.getFilledUpTo()});
    }

    public void create() throws IOException {
        this.file.create(262144);
    }

    public long pushPosition(long iPosition) throws IOException {
        int position = this.getHoles() * 8;
        this.file.allocateSpace(8);
        this.file.writeLong(position, iPosition);
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Pushed new hole at #%d containing the position #%d:%d", new Object[]{position / 8, this.owner.getId(), iPosition});
        }
        return position;
    }

    public long popLastEntryPosition() throws IOException {
        for (int pos = this.getHoles() - 1; pos >= 0; --pos) {
            long recycledPosition = this.file.readLong(pos * 8);
            if (recycledPosition <= -1L) continue;
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Recycling hole cluster #%d containing the position #%d:%d", new Object[]{pos, this.owner.getId(), recycledPosition});
            }
            this.file.removeTail((this.getHoles() - pos) * 8);
            return recycledPosition;
        }
        return -1L;
    }

    public long getEntryPosition(long iPosition) throws IOException {
        return this.file.readLong(iPosition * 8L);
    }

    public boolean removeEntryWithPosition(long iPosition) throws IOException {
        boolean canShrink = true;
        for (int pos = this.getHoles() - 1; pos >= 0; --pos) {
            long recycledPosition = this.file.readLong(pos * 8);
            if (recycledPosition == iPosition) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Removing hole #%d containing the position #%d:%d", new Object[]{pos, this.owner.getId(), recycledPosition});
                }
                this.file.writeLong(pos * 8, -1L);
                if (canShrink) {
                    this.file.removeTail((this.getHoles() - pos) * 8);
                }
                return true;
            }
            if (iPosition == -1L) continue;
            canShrink = false;
        }
        return false;
    }

    public void rename(String iOldName, String iNewName) {
        File osFile = this.file.getOsFile();
        if (osFile.getName().startsWith(iOldName)) {
            File newFile = new File(this.storage.getStoragePath() + "/" + iNewName + osFile.getName().substring(osFile.getName().lastIndexOf(iOldName) + iOldName.length()));
            boolean renamed = osFile.renameTo(newFile);
            while (!renamed) {
                OMemoryWatchDog.freeMemory(100L);
                renamed = osFile.renameTo(newFile);
            }
        }
    }

    public int getHoles() {
        return this.file.getFilledUpTo() / 8;
    }
}

