/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageTxConfiguration;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.local.OTxSegment;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import com.orientechnologies.orient.core.tx.OTxListener;
import java.io.IOException;
import java.util.ArrayList;

public class OStorageLocalTxExecuter {
    private final OStorageLocal storage;
    private final OTxSegment txSegment;

    public OStorageLocalTxExecuter(OStorageLocal iStorage, OStorageTxConfiguration iConfig) throws IOException {
        this.storage = iStorage;
        iConfig.path = "${STORAGE_PATH}/txlog.otx";
        this.txSegment = new OTxSegment(this.storage, iStorage.getConfiguration().txSegment);
    }

    public void open() throws IOException {
        this.txSegment.open();
    }

    public void create() throws IOException {
        this.txSegment.create(1000000);
    }

    public void close() throws IOException {
        this.txSegment.close();
    }

    protected long createRecord(int iTxId, OCluster iClusterSegment, ORecordId iRid, byte[] iContent, byte iRecordType) throws IOException {
        iRid.clusterPosition = -1L;
        try {
            int dataSegment = this.storage.getDataSegmentForRecord(iClusterSegment, iContent);
            ODataLocal data = this.storage.getDataSegment(dataSegment);
            iRid.clusterPosition = iClusterSegment.addPhysicalPosition(-1, -1L, iRecordType);
            long dataOffset = data.addRecord(iRid, iContent);
            iClusterSegment.setPhysicalPosition(iRid.clusterPosition, dataSegment, dataOffset, iRecordType, 0);
            this.txSegment.addLog((byte)0, iTxId, iRid.clusterId, iRid.clusterPosition, dataSegment, dataOffset, 0);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on creating entry in log segment: " + iClusterSegment, (Throwable)e, OTransactionException.class, new Object[0]);
        }
        return iRid.clusterPosition;
    }

    protected int updateRecord(int iTxId, OCluster iClusterSegment, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        try {
            OPhysicalPosition ppos = iClusterSegment.getPhysicalPosition(iRid.clusterPosition, new OPhysicalPosition());
            if (ppos == null) {
                throw new OTransactionException("Can't retrieve the updated record #" + iRid);
            }
            ORawBuffer buffer = new ORawBuffer(this.storage.getDataSegment(ppos.dataSegment).getRecord(ppos.dataPosition), ppos.version, ppos.type);
            if (iVersion > -1 && buffer.version != iVersion) {
                throw new OConcurrentModificationException("Can't update the record " + iRid + " because the version is not the latest one. Probably you are updating an old record or it has been modified by another user (db=v" + buffer.version + " your=v" + iVersion + ")");
            }
            ODataLocal dataSegment = this.storage.getDataSegment(this.storage.getDataSegmentForRecord(iClusterSegment, iContent));
            if (iContent != null) {
                long dataOffset = dataSegment.addRecord(iRid, iContent);
                iClusterSegment.setPhysicalPosition(iRid.clusterPosition, dataSegment.getId(), dataOffset, iRecordType, ++ppos.version);
            } else {
                long dataOffset = -1L;
            }
            dataSegment.updateRid(ppos.dataPosition, ORecordId.EMPTY_RECORD_ID);
            this.txSegment.addLog((byte)2, iTxId, iRid.clusterId, iRid.clusterPosition, ppos.dataSegment, ppos.dataPosition, ppos.version - 1);
            return ppos.version;
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on updating entry #" + iRid + " in log segment: " + iClusterSegment, (Throwable)e, OTransactionException.class, new Object[0]);
            return -1;
        }
    }

    protected void deleteRecord(int iTxId, OCluster iClusterSegment, long iPosition, int iVersion) {
        try {
            OPhysicalPosition ppos = iClusterSegment.getPhysicalPosition(iPosition, new OPhysicalPosition());
            if (!this.storage.checkForRecordValidity(ppos)) {
                return;
            }
            if (iVersion > -1 && ppos.version != iVersion) {
                throw new OConcurrentModificationException("Can't delete the record #" + iClusterSegment.getId() + ":" + iPosition + " because the version is not the latest one. Probably you are deleting an old record or it has been modified by another user (db=v" + ppos.version + " your=v" + iVersion + ")");
            }
            this.txSegment.addLog((byte)1, iTxId, iClusterSegment.getId(), iPosition, ppos.dataSegment, ppos.dataPosition, iVersion);
            iClusterSegment.removePhysicalPosition(iPosition, ppos);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on deleting entry #" + iPosition + " in log segment: " + iClusterSegment, (Throwable)e, OTransactionException.class, new Object[0]);
        }
    }

    public OTxSegment getTxSegment() {
        return this.txSegment;
    }

    public void commitAllPendingRecords(OTransaction iTx) throws IOException {
        ArrayList<OTransactionRecordEntry> tmpEntries = new ArrayList<OTransactionRecordEntry>();
        while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
            for (OTransactionRecordEntry oTransactionRecordEntry : iTx.getCurrentRecordEntries()) {
                tmpEntries.add(oTransactionRecordEntry);
            }
            iTx.clearRecordEntries();
            if (tmpEntries.size() <= 0) continue;
            for (OTransactionRecordEntry oTransactionRecordEntry : tmpEntries) {
                this.commitEntry(iTx, oTransactionRecordEntry, iTx.isUsingLog());
            }
        }
        OTransactionAbstract.updateCacheFromEntries(this.storage, iTx, iTx.getAllRecordEntries(), true);
    }

    public void clearLogEntries(OTransaction iTx) throws IOException {
        this.txSegment.clearLogEntries(iTx.getId());
    }

    private void commitEntry(OTransaction iTx, OTransactionRecordEntry txEntry, boolean iUseLog) throws IOException {
        OCluster cluster;
        if (txEntry.status != 2 && !txEntry.getRecord().isDirty()) {
            return;
        }
        ORecordId rid = (ORecordId)txEntry.getRecord().getIdentity();
        OCluster oCluster = cluster = txEntry.clusterName != null ? this.storage.getClusterByName(txEntry.clusterName) : this.storage.getClusterById(rid.clusterId);
        if (cluster.getName().equals("index")) {
            return;
        }
        if (!(cluster instanceof OClusterLocal)) {
            return;
        }
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.BEFORE_COMMIT);
        }
        switch (txEntry.status) {
            case 0: {
                break;
            }
            case 3: {
                byte[] stream = txEntry.getRecord().toStream();
                if (rid.isNew()) {
                    if (iTx.getDatabase().callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, txEntry.getRecord())) {
                        stream = txEntry.getRecord().toStream();
                    }
                    rid.clusterId = cluster.getId();
                    if (iUseLog) {
                        this.createRecord(iTx.getId(), cluster, rid, stream, txEntry.getRecord().getRecordType());
                    } else {
                        iTx.getDatabase().getStorage().createRecord(rid, stream, txEntry.getRecord().getRecordType());
                    }
                    iTx.getDatabase().callbackHooks(ORecordHook.TYPE.AFTER_CREATE, txEntry.getRecord());
                    break;
                }
                if (iUseLog) {
                    txEntry.getRecord().setVersion(this.updateRecord(iTx.getId(), cluster, rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType()));
                    break;
                }
                txEntry.getRecord().setVersion(iTx.getDatabase().getStorage().updateRecord(rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType()));
                break;
            }
            case 1: {
                byte[] stream = txEntry.getRecord().toStream();
                if (iTx.getDatabase().callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, txEntry.getRecord())) {
                    stream = txEntry.getRecord().toStream();
                }
                txEntry.getRecord().setVersion(this.updateRecord(iTx.getId(), cluster, rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType()));
                iTx.getDatabase().callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, txEntry.getRecord());
                break;
            }
            case 2: {
                iTx.getDatabase().callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, txEntry.getRecord());
                this.deleteRecord(iTx.getId(), cluster, rid.clusterPosition, txEntry.getRecord().getVersion());
                iTx.getDatabase().callbackHooks(ORecordHook.TYPE.AFTER_DELETE, txEntry.getRecord());
            }
        }
        txEntry.getRecord().unsetDirty();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.AFTER_COMMIT);
        }
    }
}

