/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordBrowsingListener;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemory;
import com.orientechnologies.orient.core.storage.impl.memory.ODataSegmentMemory;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStorageMemory
extends OStorageEmbedded {
    private final ODataSegmentMemory data = new ODataSegmentMemory();
    private final List<OClusterMemory> clusters = new ArrayList<OClusterMemory>();
    private int defaultClusterId = 0;

    public OStorageMemory(String iURL) {
        super(iURL, "memory:" + iURL, "rw");
        this.configuration = new OStorageConfiguration(this);
    }

    @Override
    public void create(Map<String, Object> iOptions) {
        this.addUser();
        this.lock.acquireExclusiveLock();
        try {
            try {
                this.addDataSegment("default");
                this.addCluster("internal", null, new Object[0]);
                this.addCluster("index", null, new Object[0]);
                this.defaultClusterId = this.addCluster("default", null, new Object[0]);
                this.configuration.create();
                this.status = OStorageAbstract.STATUS.OPEN;
            }
            catch (OStorageException e) {
                this.close();
                throw e;
            }
            catch (IOException e) {
                this.close();
                throw new OStorageException("Error on creation of storage: " + this.name, e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.addUser();
        if (this.status == OStorageAbstract.STATUS.OPEN) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            if (!this.exists()) {
                throw new OStorageException("Can't open the storage '" + this.name + "' because it not exists in path: " + this.url);
            }
            this.status = OStorageAbstract.STATUS.OPEN;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close(boolean iForce) {
        block5: {
            block4: {
                this.lock.acquireExclusiveLock();
                try {
                    if (!this.checkForClose(iForce)) {
                        Object var5_2 = null;
                        break block4;
                    }
                    this.status = OStorageAbstract.STATUS.CLOSING;
                    for (OClusterMemory c : this.clusters) {
                        if (c == null) continue;
                        c.close();
                    }
                    this.clusters.clear();
                    this.data.close();
                    this.level2Cache.shutdown();
                    super.close(iForce);
                    Orient.instance().unregisterStorage(this);
                    this.status = OStorageAbstract.STATUS.CLOSED;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.lock.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.lock.releaseExclusiveLock();
            return;
        }
        Object var5_3 = null;
        this.lock.releaseExclusiveLock();
    }

    @Override
    public void delete() {
        this.close(true);
    }

    @Override
    public void reload() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iClusterType, Object ... iParameters) {
        int n;
        this.lock.acquireExclusiveLock();
        try {
            int clusterId = this.clusters.size();
            for (int i = 0; i < this.clusters.size(); ++i) {
                if (this.clusters.get(i) != null) continue;
                clusterId = i;
                break;
            }
            OClusterMemory cluster = new OClusterMemory(clusterId, iClusterName.toLowerCase());
            if (clusterId == this.clusters.size()) {
                this.clusters.add(cluster);
            } else {
                this.clusters.set(clusterId, cluster);
            }
            n = clusterId;
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean dropCluster(int iClusterId) {
        this.lock.acquireExclusiveLock();
        try {
            block4: {
                try {
                    OCluster c = this.clusters.get(iClusterId);
                    if (c == null) break block4;
                    c.delete();
                    this.clusters.set(iClusterId, null);
                    this.getLevel2Cache().freeCluster(iClusterId);
                }
                catch (IOException iOException) {
                    Object var4_5 = null;
                    this.lock.releaseExclusiveLock();
                    return false;
                }
            }
            Object var4_4 = null;
            this.lock.releaseExclusiveLock();
            return false;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    @Override
    public int addDataSegment(String iDataSegmentName) {
        return 0;
    }

    @Override
    public int addDataSegment(String iSegmentName, String iSegmentFileName) {
        return this.addDataSegment(iSegmentName);
    }

    @Override
    public long createRecord(ORecordId iRid, byte[] iContent, byte iRecordType) {
        long l;
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireSharedLock();
        try {
            long offset = this.data.createRecord(iContent);
            OCluster cluster = this.getClusterById(iRid.clusterId);
            l = iRid.clusterPosition = cluster.addPhysicalPosition(0, offset, iRecordType);
            Object var12_9 = null;
        }
        catch (IOException e) {
            try {
                throw new OStorageException("Error on create record in cluster: " + iRid.clusterId, e);
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono("OStorageMemory.createRecord", timer);
                throw throwable;
            }
        }
        this.lock.releaseSharedLock();
        OProfiler.getInstance().stopChrono("OStorageMemory.createRecord", timer);
        return l;
    }

    @Override
    public ORawBuffer readRecord(ODatabaseRecord iDatabase, ORecordId iRid, String iFetchPlan) {
        return this.readRecord(this.getClusterById(iRid.clusterId), iRid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ORawBuffer readRecord(OCluster iClusterSegment, ORecordId iRid, boolean iAtomicLock) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireSharedLock();
        try {
            try {
                OPhysicalPosition ppos;
                block8: {
                    ORawBuffer oRawBuffer;
                    this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.SHARED);
                    long lastPos = iClusterSegment.getLastEntryPosition();
                    if (iRid.clusterPosition > lastPos) {
                        throw new ORecordNotFoundException("Record " + iRid + " is out cluster size. Valid range for cluster '" + iClusterSegment.getName() + "' is 0-" + lastPos);
                    }
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(iRid.clusterPosition, new OPhysicalPosition());
                        if (ppos != null) break block8;
                        oRawBuffer = null;
                        Object var11_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.SHARED);
                        throw throwable;
                    }
                    this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.SHARED);
                    Object var13_13 = null;
                    this.lock.releaseSharedLock();
                    OProfiler.getInstance().stopChrono("OStorageMemory.readRecord", timer);
                    return oRawBuffer;
                }
                ORawBuffer oRawBuffer = new ORawBuffer(this.data.readRecord(ppos.dataPosition), ppos.version, ppos.type);
                Object var11_11 = null;
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.SHARED);
                Object var13_14 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono("OStorageMemory.readRecord", timer);
                return oRawBuffer;
            }
            catch (IOException e) {
                throw new OStorageException("Error on read record in cluster: " + iClusterSegment.getId(), e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.readRecord", timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int updateRecord(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        long timer = OProfiler.getInstance().startChrono();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        this.lock.acquireSharedLock();
        try {
            try {
                OPhysicalPosition ppos;
                block8: {
                    int n;
                    this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = cluster.getPhysicalPosition(iRid.clusterPosition, new OPhysicalPosition());
                        if (ppos != null) break block8;
                        n = -1;
                        Object var11_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                        throw throwable;
                    }
                    this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                    Object var13_14 = null;
                    this.lock.releaseSharedLock();
                    OProfiler.getInstance().stopChrono("OStorageMemory.updateRecord", timer);
                    return n;
                }
                if (iVersion > -1 && ppos.version != iVersion) {
                    throw new OConcurrentModificationException("Can't update record " + iRid + " because the version is not the latest one. Probably you are updating an old record or it has been modified by another user (db=v" + ppos.version + " your=v" + iVersion + ")");
                }
                this.data.updateRecord(ppos.dataPosition, iContent);
                int n = ++ppos.version;
                Object var11_12 = null;
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                Object var13_15 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono("OStorageMemory.updateRecord", timer);
                return n;
            }
            catch (IOException e) {
                throw new OStorageException("Error on update record " + iRid, e);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.updateRecord", timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteRecord(ORecordId iRid, int iVersion) {
        long timer = OProfiler.getInstance().startChrono();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        this.lock.acquireSharedLock();
        try {
            try {
                OPhysicalPosition ppos;
                block8: {
                    boolean bl;
                    this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = cluster.getPhysicalPosition(iRid.clusterPosition, new OPhysicalPosition());
                        if (ppos != null) break block8;
                        bl = false;
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                        throw throwable;
                    }
                    this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                    Object var11_12 = null;
                    this.lock.releaseSharedLock();
                    OProfiler.getInstance().stopChrono("OStorageMemory.deleteRecord", timer);
                    return bl;
                }
                if (iVersion > -1 && ppos.version != iVersion) {
                    throw new OConcurrentModificationException("Can't delete record " + iRid + " because the version is not the latest one. Probably you are deleting an old record or it has been modified by another user (db=v" + ppos.version + " your=v" + iVersion + ")");
                }
                cluster.removePhysicalPosition(iRid.clusterPosition, null);
                this.data.deleteRecord(ppos.dataPosition);
                boolean bl = true;
                Object var9_10 = null;
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                Object var11_13 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono("OStorageMemory.deleteRecord", timer);
                return bl;
            }
            catch (IOException e) {
                throw new OStorageException("Error on delete record " + iRid, e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.deleteRecord", timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int iClusterId) {
        long l;
        OCluster cluster = this.getClusterById(iClusterId);
        this.lock.acquireSharedLock();
        try {
            l = cluster.getEntries();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return l;
    }

    @Override
    public long[] getClusterDataRange(int iClusterId) {
        long[] lArray;
        OCluster cluster = this.getClusterById(iClusterId);
        this.lock.acquireSharedLock();
        try {
            lArray = new long[]{cluster.getFirstEntryPosition(), cluster.getLastEntryPosition()};
            Object var5_5 = null;
        }
        catch (IOException e) {
            try {
                throw new OStorageException("Error on getting last entry position in cluster: " + iClusterId, e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
        }
        this.lock.releaseSharedLock();
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int[] iClusterIds) {
        long l;
        this.lock.acquireSharedLock();
        try {
            long tot = 0L;
            for (int i = 0; i < iClusterIds.length; ++i) {
                OCluster cluster = this.clusters.get(iClusterIds[i]);
                if (cluster == null) continue;
                tot += cluster.getEntries();
            }
            l = tot;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OCluster getClusterByName(String iClusterName) {
        OCluster oCluster;
        block4: {
            OCluster oCluster2;
            block3: {
                this.lock.acquireSharedLock();
                try {
                    for (int i = 0; i < this.clusters.size(); ++i) {
                        OCluster cluster = this.clusters.get(i);
                        if (cluster == null || !cluster.getName().equalsIgnoreCase(iClusterName)) continue;
                        oCluster2 = cluster;
                        Object var6_6 = null;
                        break block3;
                    }
                    oCluster = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.lock.releaseSharedLock();
                    throw throwable;
                }
            }
            this.lock.releaseSharedLock();
            return oCluster2;
        }
        Object var6_7 = null;
        this.lock.releaseSharedLock();
        return oCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getClusterIdByName(String iClusterName) {
        int n;
        block4: {
            int n2;
            block3: {
                iClusterName = iClusterName.toLowerCase();
                this.lock.acquireSharedLock();
                try {
                    for (int i = 0; i < this.clusters.size(); ++i) {
                        OCluster cluster = this.clusters.get(i);
                        if (cluster == null || !cluster.getName().equalsIgnoreCase(iClusterName)) continue;
                        n2 = cluster.getId();
                        Object var6_5 = null;
                        break block3;
                    }
                    n = -1;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.lock.releaseSharedLock();
                    throw throwable;
                }
            }
            this.lock.releaseSharedLock();
            return n2;
        }
        Object var6_6 = null;
        this.lock.releaseSharedLock();
        return n;
    }

    @Override
    public String getClusterTypeByName(String iClusterName) {
        return "MEMORY";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        String string;
        block4: {
            String string2;
            block3: {
                this.lock.acquireSharedLock();
                try {
                    for (int i = 0; i < this.clusters.size(); ++i) {
                        OCluster cluster = this.clusters.get(i);
                        if (cluster == null || cluster.getId() != iClusterId) continue;
                        string2 = cluster.getName();
                        Object var6_6 = null;
                        break block3;
                    }
                    string = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.lock.releaseSharedLock();
                    throw throwable;
                }
            }
            this.lock.releaseSharedLock();
            return string2;
        }
        Object var6_7 = null;
        this.lock.releaseSharedLock();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getClusterNames() {
        HashSet<String> hashSet;
        this.lock.acquireSharedLock();
        try {
            HashSet<String> result = new HashSet<String>();
            for (int i = 0; i < this.clusters.size(); ++i) {
                OCluster cluster = this.clusters.get(i);
                if (cluster == null) continue;
                result.add(cluster.getName());
            }
            hashSet = result;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit(OTransaction iTx) {
        this.lock.acquireExclusiveLock();
        try {
            try {
                ArrayList<OTransactionRecordEntry> tmpEntries = new ArrayList<OTransactionRecordEntry>();
                while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                    for (OTransactionRecordEntry oTransactionRecordEntry : iTx.getCurrentRecordEntries()) {
                        tmpEntries.add(oTransactionRecordEntry);
                    }
                    iTx.clearRecordEntries();
                    for (OTransactionRecordEntry oTransactionRecordEntry : tmpEntries) {
                        this.commitEntry(iTx.getId(), oTransactionRecordEntry);
                    }
                    tmpEntries.clear();
                }
                OTransactionAbstract.updateCacheFromEntries(this, iTx, iTx.getAllRecordEntries(), true);
            }
            catch (IOException e) {
                this.rollback(iTx);
                Object var6_9 = null;
                this.lock.releaseExclusiveLock();
                return;
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
    }

    @Override
    public void rollback(OTransaction iTx) {
    }

    @Override
    public void synch() {
    }

    public void browse(int[] iClusterId, ORecordBrowsingListener iListener, ORecord<?> iRecord) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        boolean bl;
        this.lock.acquireSharedLock();
        try {
            bl = this.clusters.size() > 0;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterById(int iClusterId) {
        OCluster oCluster;
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            oCluster = this.clusters.get(iClusterId);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return oCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClusters() {
        int n;
        this.lock.acquireSharedLock();
        try {
            n = this.clusters.size();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends OCluster> getClusterInstances() {
        Collection<OClusterMemory> collection;
        this.lock.acquireSharedLock();
        try {
            collection = Collections.unmodifiableCollection(this.clusters);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return collection;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        long size = 0L;
        this.lock.acquireSharedLock();
        try {
            size += this.data.getSize();
            for (OClusterMemory c : this.clusters) {
                if (c == null) continue;
                size += c.getSize();
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        block4: {
            boolean bl;
            if (ppos.dataSegment > 0) {
                return false;
            }
            this.lock.acquireSharedLock();
            try {
                if (ppos.dataPosition < (long)this.data.count()) break block4;
                bl = false;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
            this.lock.releaseSharedLock();
            return bl;
        }
        Object var4_4 = null;
        this.lock.releaseSharedLock();
        return true;
    }

    private void commitEntry(int iTxId, OTransactionRecordEntry txEntry) throws IOException {
        ORecordId rid = (ORecordId)txEntry.getRecord().getIdentity();
        OCluster cluster = txEntry.clusterName != null ? this.getClusterByName(txEntry.clusterName) : this.getClusterById(rid.clusterId);
        rid.clusterId = cluster.getId();
        switch (txEntry.status) {
            case 0: {
                break;
            }
            case 3: {
                if (!rid.isNew()) break;
                byte[] stream = txEntry.getRecord().toStream();
                if (rid.isNew()) {
                    this.createRecord(rid, stream, txEntry.getRecord().getRecordType());
                    break;
                }
                txEntry.getRecord().setVersion(this.updateRecord(rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType()));
                break;
            }
            case 1: {
                txEntry.getRecord().setVersion(this.updateRecord(rid, txEntry.getRecord().toStream(), txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType()));
                break;
            }
            case 2: {
                this.deleteRecord(rid, txEntry.getRecord().getVersion());
            }
        }
    }

    public OStorageConfigurationSegment getConfigurationSegment() {
        return null;
    }

    @Override
    public void renameCluster(String iOldName, String iNewName) {
        OClusterMemory cluster = (OClusterMemory)this.getClusterByName(iOldName);
        if (cluster != null) {
            try {
                cluster.set(OCluster.ATTRIBUTES.NAME, iNewName);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

