/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeDatabaseLazySave<K, V>
extends OMVRBTreeDatabase<K, V> {
    protected int maxUpdatesBeforeSave;
    protected int updates = 0;
    protected boolean transactionRunning = false;

    public OMVRBTreeDatabaseLazySave(ODatabaseRecord iDatabase, ORID iRID) {
        super(iDatabase, iRID);
    }

    public OMVRBTreeDatabaseLazySave(ODatabaseRecord iDatabase, String iClusterName, OStreamSerializer iKeySerializer, OStreamSerializer iValueSerializer) {
        super(iDatabase, iClusterName, iKeySerializer, iValueSerializer);
    }

    @Override
    public synchronized int commitChanges() {
        if (this.transactionRunning || this.maxUpdatesBeforeSave == 0 || this.maxUpdatesBeforeSave > 0 && ++this.updates >= this.maxUpdatesBeforeSave) {
            this.updates = 0;
            return this.lazySave();
        }
        return 0;
    }

    @Override
    public void clear() {
        super.clear();
        this.lazySave();
    }

    public int lazySave() {
        return super.commitChanges();
    }

    @Override
    public int optimize(boolean iForce) {
        if (this.optimization == -1) {
            return 0;
        }
        if (!iForce && this.optimization == 0) {
            return 0;
        }
        this.optimization = iForce ? 2 : 1;
        this.lazySave();
        return super.optimize(iForce);
    }

    public int getMaxUpdatesBeforeSave() {
        return this.maxUpdatesBeforeSave;
    }

    public void setMaxUpdatesBeforeSave(int iValue) {
        this.maxUpdatesBeforeSave = iValue;
    }

    @Override
    protected void config() {
        super.config();
        this.maxUpdatesBeforeSave = OGlobalConfiguration.MVRBTREE_LAZY_UPDATES.getValueAsInteger();
    }

    public void setRunningTransaction(boolean iTxRunning) {
        this.transactionRunning = iTxRunning;
        if (iTxRunning) {
            this.updates = 0;
            this.lazySave();
        }
    }
}

