/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeStorage;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeEntryStorage<K, V>
extends OMVRBTreeEntryPersistent<K, V> {
    public OMVRBTreeEntryStorage(OMVRBTreeEntry<K, V> iParent, int iPosition) {
        super(iParent, iPosition);
        this.record.setIdentity(this.pTree.getRecord().getIdentity().getClusterId(), -1L);
    }

    public OMVRBTreeEntryStorage(OMVRBTreePersistent<K, V> iTree, K key, V value, OMVRBTreeEntryPersistent<K, V> iParent) {
        super(iTree, key, value, iParent);
        this.record.setIdentity(this.pTree.getRecord().getIdentity().getClusterId(), -1L);
    }

    public OMVRBTreeEntryStorage(OMVRBTreePersistent<K, V> iTree, OMVRBTreeEntryPersistent<K, V> iParent, ORID iRecordId) throws IOException {
        super(iTree, iParent, iRecordId);
    }

    @Override
    public OMVRBTreeEntryStorage<K, V> load() throws IOException {
        ORawBuffer raw = ((OMVRBTreeStorage)this.tree).storage.readRecord(null, (ORecordId)this.record.getIdentity(), null);
        this.record.setVersion(raw.version);
        this.fromStream(raw.buffer);
        super.load();
        return this;
    }

    @Override
    public OMVRBTreeEntryStorage<K, V> save() {
        this.record.fromStream(this.toStream());
        if (this.record.getIdentity().isValid()) {
            this.record.setVersion(((OMVRBTreeStorage)this.tree).storage.updateRecord((ORecordId)this.record.getIdentity(), this.record.toStream(), -1, this.record.getRecordType()));
        } else {
            this.record.setIdentity(this.record.getIdentity().getClusterId(), ((OMVRBTreeStorage)this.tree).storage.createRecord((ORecordId)this.record.getIdentity(), this.record.toStream(), this.record.getRecordType()));
        }
        this.record.unsetDirty();
        super.save();
        return this;
    }

    @Override
    public OMVRBTreeEntryStorage<K, V> delete() throws IOException {
        if (this.getLeft() != null) {
            ((OMVRBTreeEntryPersistent)this.getLeft()).delete();
        }
        if (this.getRight() != null) {
            ((OMVRBTreeEntryPersistent)this.getRight()).delete();
        }
        ((OMVRBTreeStorage)this.tree).storage.deleteRecord((ORecordId)this.record.getIdentity(), this.record.getVersion());
        this.keys = null;
        this.values = null;
        super.delete();
        return this;
    }

    @Override
    protected Object keyFromStream(int iIndex) throws IOException {
        return this.pTree.keySerializer.fromStream(null, this.inStream.getAsByteArray(this.serializedKeys[iIndex]));
    }

    @Override
    protected Object valueFromStream(int iIndex) throws IOException {
        return this.pTree.valueSerializer.fromStream(null, this.inStream.getAsByteArray(this.serializedValues[iIndex]));
    }
}

