/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.collection.OMVRBTreeEventListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.memory.OLowMemoryException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.record.impl.ORecordBytesLazy;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.core.serialization.OMemoryOutputStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerFactory;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OMVRBTreePersistent<K, V>
extends OMVRBTree<K, V>
implements OMVRBTreeEventListener<K, V>,
OSerializableStream {
    protected OStreamSerializer keySerializer;
    protected OStreamSerializer valueSerializer;
    protected final Set<OMVRBTreeEntryPersistent<K, V>> recordsToCommit = new HashSet<OMVRBTreeEntryPersistent<K, V>>();
    protected final String clusterName;
    protected ORecordBytesLazy record;
    protected String fetchPlan;
    protected int optimizeThreshold;
    protected volatile int optimization = 0;
    private int insertionCounter = 0;
    protected int entryPointsSize;
    protected float optimizeEntryPointsFactor;
    private TreeMap<K, OMVRBTreeEntryPersistent<K, V>> entryPoints = new TreeMap();
    private Map<ORID, OMVRBTreeEntryPersistent<K, V>> cache = new HashMap<ORID, OMVRBTreeEntryPersistent<K, V>>();
    private final OMemoryOutputStream entryRecordBuffer;
    public static final byte CURRENT_PROTOCOL_VERSION = 0;

    public OMVRBTreePersistent(String iClusterName, ORID iRID) {
        this(iClusterName, null, null);
        this.record.setIdentity(iRID.getClusterId(), iRID.getClusterPosition());
    }

    public OMVRBTreePersistent(String iClusterName, OStreamSerializer iKeySerializer, OStreamSerializer iValueSerializer) {
        super(OGlobalConfiguration.MVRBTREE_NODE_PAGE_SIZE.getValueAsInteger(), ((Float)OGlobalConfiguration.MVRBTREE_LOAD_FACTOR.getValue()).floatValue());
        this.config();
        this.clusterName = iClusterName;
        this.record = new ORecordBytesLazy(this);
        this.keySerializer = iKeySerializer;
        this.valueSerializer = iValueSerializer;
        this.entryRecordBuffer = new OMemoryOutputStream(this.getPageSize() * 15);
        this.setListener(this);
    }

    public abstract OMVRBTreePersistent<K, V> load() throws IOException;

    public abstract OMVRBTreePersistent<K, V> save() throws IOException;

    protected abstract OMVRBTreeEntryPersistent<K, V> loadEntry(OMVRBTreeEntryPersistent<K, V> var1, ORID var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        long timer = OProfiler.getInstance().startChrono();
        try {
            if (this.root != null) {
                ((OMVRBTreeEntryPersistent)this.root).delete();
                super.clear();
                this.getListener().signalTreeChanged((OMVRBTree)this);
            }
            this.recordsToCommit.clear();
            this.entryPoints.clear();
            this.cache.clear();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on deleting the tree: " + this.record.getIdentity(), (Throwable)e, OStorageException.class, new Object[0]);
        }
        finally {
            OProfiler.getInstance().stopChrono("OMVRBTreePersistent.clear", timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        long timer = OProfiler.getInstance().startChrono();
        try {
            for (OMVRBTreeEntryPersistent<K, V> entryPoint : this.entryPoints.values()) {
                entryPoint.disconnectLinked(true);
            }
            this.entryPoints.clear();
            this.cache.clear();
            this.recordsToCommit.clear();
            this.root = null;
            this.load();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on unload the tree: " + this.record.getIdentity(), (Throwable)e, OStorageException.class, new Object[0]);
        }
        finally {
            OProfiler.getInstance().stopChrono("OMVRBTreePersistent.unload", timer);
        }
    }

    protected void optimize() {
        this.optimize(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int optimize(boolean iForce) {
        int n;
        int nodesInMemory;
        long timer;
        block38: {
            block37: {
                if (this.optimization == -1) {
                    return 0;
                }
                if (!iForce && this.optimization == 0) {
                    return 0;
                }
                this.optimization = -1;
                timer = OProfiler.getInstance().startChrono();
                if (this.root != null) break block37;
                int n2 = 0;
                Object var12_5 = null;
                this.optimization = 0;
                if (this.isRuntimeCheckEnabled()) {
                    if (this.entryPoints.size() > 0) {
                        for (OMVRBTreeEntryPersistent<K, V> entryPoint : this.entryPoints.values()) {
                            this.checkTreeStructure(entryPoint.getFirstInMemory());
                        }
                    } else {
                        this.checkTreeStructure(this.root);
                    }
                }
                OProfiler.getInstance().stopChrono("OMVRBTreePersistent.optimize", timer);
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Optimization completed in %d ms\n", new Object[]{System.currentTimeMillis() - timer});
                }
                return n2;
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Starting optimization of MVRB+Tree with %d items in memory...", new Object[]{this.cache.size()});
            }
            if (this.entryPoints.size() == 0) {
                this.addNodeAsEntrypoint((OMVRBTreeEntryPersistent)this.root);
            }
            this.config();
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Found %d items on disk, threshold=%f, entryPoints=%d, nodesInCache=%d", new Object[]{this.size, Float.valueOf((float)this.entryPointsSize * this.optimizeEntryPointsFactor), this.entryPoints.size(), this.cache.size()});
            }
            nodesInMemory = this.cache.size();
            if (iForce || !((float)nodesInMemory < (float)this.entryPointsSize * this.optimizeEntryPointsFactor)) break block38;
            int n3 = 0;
            Object var12_6 = null;
            this.optimization = 0;
            if (this.isRuntimeCheckEnabled()) {
                if (this.entryPoints.size() > 0) {
                    for (OMVRBTreeEntryPersistent<K, V> entryPoint : this.entryPoints.values()) {
                        this.checkTreeStructure(entryPoint.getFirstInMemory());
                    }
                } else {
                    this.checkTreeStructure(this.root);
                }
            }
            OProfiler.getInstance().stopChrono("OMVRBTreePersistent.optimize", timer);
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Optimization completed in %d ms\n", new Object[]{System.currentTimeMillis() - timer});
            }
            return n3;
        }
        try {
            this.lastSearchFound = false;
            this.lastSearchKey = null;
            this.lastSearchNode = null;
            int totalDisconnected = 0;
            if (nodesInMemory > this.entryPointsSize) {
                int distance = nodesInMemory / this.entryPointsSize + 1;
                HashSet<OMVRBTreeEntryPersistent> entryPointsToRemove = new HashSet<OMVRBTreeEntryPersistent>(nodesInMemory - this.entryPointsSize + 2);
                int currNode = 0;
                Iterator<OMVRBTreeEntryPersistent<K, V>> it = this.entryPoints.values().iterator();
                while (it.hasNext()) {
                    OMVRBTreeEntryPersistent currentNode = it.next();
                    if (currentNode == this.root || currentNode == this.lastSearchNode || !it.hasNext() || ++currNode % distance == 0) continue;
                    entryPointsToRemove.add(currentNode);
                    it.remove();
                }
                this.addNodeAsEntrypoint((OMVRBTreeEntryPersistent)this.lastSearchNode);
                this.addNodeAsEntrypoint((OMVRBTreeEntryPersistent)this.root);
                for (OMVRBTreeEntryPersistent currentNode : entryPointsToRemove) {
                    totalDisconnected += currentNode.disconnectLinked(false);
                }
            }
            if (this.isRuntimeCheckEnabled()) {
                for (OMVRBTreeEntryPersistent<K, V> entryPoint : this.entryPoints.values()) {
                    for (OMVRBTreeEntryPersistent e = (OMVRBTreeEntryPersistent)entryPoint.getFirstInMemory(); e != null; e = e.getNextInMemory()) {
                        e.checkEntryStructure();
                    }
                }
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "After optimization: %d items on disk, threshold=%f, entryPoints=%d, nodesInCache=%d", new Object[]{this.size, Float.valueOf((float)this.entryPointsSize * this.optimizeEntryPointsFactor), this.entryPoints.size(), this.cache.size()});
            }
            if (this.debug) {
                int i = 0;
                for (OMVRBTreeEntryPersistent<K, V> entryPoint : this.entryPoints.values()) {
                    System.out.println("- Entrypoint " + ++i + "/" + this.entryPoints.size() + ": " + entryPoint);
                }
            }
            n = totalDisconnected;
            Object var12_7 = null;
            this.optimization = 0;
        }
        catch (Throwable throwable) {
            block39: {
                Object var12_8 = null;
                this.optimization = 0;
                if (this.isRuntimeCheckEnabled()) {
                    if (this.entryPoints.size() > 0) {
                        for (OMVRBTreeEntryPersistent<K, V> entryPoint : this.entryPoints.values()) {
                            this.checkTreeStructure(entryPoint.getFirstInMemory());
                        }
                    } else {
                        this.checkTreeStructure(this.root);
                    }
                }
                OProfiler.getInstance().stopChrono("OMVRBTreePersistent.optimize", timer);
                if (!OLogManager.instance().isDebugEnabled()) break block39;
                OLogManager.instance().debug((Object)this, "Optimization completed in %d ms\n", new Object[]{System.currentTimeMillis() - timer});
            }
            throw throwable;
        }
        if (this.isRuntimeCheckEnabled()) {
            if (this.entryPoints.size() > 0) {
                for (OMVRBTreeEntryPersistent<K, V> entryPoint : this.entryPoints.values()) {
                    this.checkTreeStructure(entryPoint.getFirstInMemory());
                }
            } else {
                this.checkTreeStructure(this.root);
            }
        }
        OProfiler.getInstance().stopChrono("OMVRBTreePersistent.optimize", timer);
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Optimization completed in %d ms\n", new Object[]{System.currentTimeMillis() - timer});
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        V v;
        this.optimize();
        long timer = OProfiler.getInstance().startChrono();
        try {
            V v2 = this.internalPut(key, value);
            this.commitChanges();
            v = v2;
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            OProfiler.getInstance().stopChrono("OMVRBTreePersistent.put", timer);
            throw throwable;
        }
        OProfiler.getInstance().stopChrono("OMVRBTreePersistent.put", timer);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> map) {
        long timer = OProfiler.getInstance().startChrono();
        try {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.internalPut(entry.getKey(), entry.getValue());
            }
            this.commitChanges();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            OProfiler.getInstance().stopChrono("OMVRBTreePersistent.putAll", timer);
            throw throwable;
        }
        OProfiler.getInstance().stopChrono("OMVRBTreePersistent.putAll", timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V remove(Object key) {
        long timer;
        block10: {
            Object object;
            block9: {
                this.optimize();
                timer = OProfiler.getInstance().startChrono();
                try {
                    for (int i = 0; i < 10; ++i) {
                        try {
                            Object v = super.remove(key);
                            this.commitChanges();
                            object = v;
                        }
                        catch (OLowMemoryException e) {
                            OLogManager.instance().debug((Object)this, "Optimization required during remove %d/10", new Object[]{i});
                            this.optimize(true);
                            System.gc();
                            if (i > 0) {
                                try {
                                    Thread.sleep(300 * i);
                                }
                                catch (InterruptedException e1) {
                                    // empty catch block
                                }
                            }
                            this.optimization = -1;
                            continue;
                        }
                        Object var8_8 = null;
                        break block9;
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OProfiler.getInstance().stopChrono("OMVRBTreePersistent.remove", timer);
                    throw throwable;
                }
            }
            OProfiler.getInstance().stopChrono("OMVRBTreePersistent.remove", timer);
            return (V)object;
        }
        Object var8_9 = null;
        OProfiler.getInstance().stopChrono("OMVRBTreePersistent.remove", timer);
        throw new OLowMemoryException("OMVRBTreePersistent.remove()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int commitChanges() {
        int totalCommitted;
        long timer;
        block14: {
            timer = OProfiler.getInstance().startChrono();
            totalCommitted = 0;
            try {
                try {
                    if (this.record.isDirty()) {
                        this.save();
                    }
                    if (this.recordsToCommit.size() <= 0) break block14;
                    ArrayList<OMVRBTreeEntryPersistent<K, V>> tmp = new ArrayList<OMVRBTreeEntryPersistent<K, V>>();
                    while (this.recordsToCommit.iterator().hasNext()) {
                        tmp.addAll(this.recordsToCommit);
                        this.recordsToCommit.clear();
                        for (OMVRBTreeEntryPersistent oMVRBTreeEntryPersistent : tmp) {
                            if (!oMVRBTreeEntryPersistent.record.isDirty()) continue;
                            boolean wasNew = oMVRBTreeEntryPersistent.record.getIdentity().isNew();
                            oMVRBTreeEntryPersistent.save();
                            if (this.debug) {
                                System.out.printf("\nSaved %s tree node %s: parent %s, left %s, right %s", wasNew ? "new" : "", oMVRBTreeEntryPersistent.record.getIdentity(), oMVRBTreeEntryPersistent.parentRid, oMVRBTreeEntryPersistent.leftRid, oMVRBTreeEntryPersistent.rightRid);
                            }
                            if (!wasNew) continue;
                            if (oMVRBTreeEntryPersistent.record.getIdentity().getClusterPosition() < -1L) {
                                if (this.cache.get(oMVRBTreeEntryPersistent.record.getIdentity()) != oMVRBTreeEntryPersistent) {
                                    this.cache.put(oMVRBTreeEntryPersistent.record.getIdentity().copy(), oMVRBTreeEntryPersistent);
                                }
                            } else {
                                if (oMVRBTreeEntryPersistent.parent != null) {
                                    oMVRBTreeEntryPersistent.parent.markDirty();
                                }
                                if (oMVRBTreeEntryPersistent.left != null) {
                                    oMVRBTreeEntryPersistent.left.markDirty();
                                }
                                if (oMVRBTreeEntryPersistent.right != null) {
                                    oMVRBTreeEntryPersistent.right.markDirty();
                                }
                            }
                            this.cache.put(oMVRBTreeEntryPersistent.record.getIdentity(), oMVRBTreeEntryPersistent);
                        }
                        totalCommitted += tmp.size();
                        tmp.clear();
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().exception("Error on saving the tree", (Exception)e, OStorageException.class, new Object[0]);
                    Object var9_9 = null;
                    OProfiler.getInstance().stopChrono("OMVRBTreePersistent.commitChanges", timer);
                    return totalCommitted;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OProfiler.getInstance().stopChrono("OMVRBTreePersistent.commitChanges", timer);
                throw throwable;
            }
        }
        Object var9_8 = null;
        OProfiler.getInstance().stopChrono("OMVRBTreePersistent.commitChanges", timer);
        return totalCommitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OMVRBTreePersistent oMVRBTreePersistent;
        long timer = OProfiler.getInstance().startChrono();
        ORecordId rootRid = new ORecordId();
        try {
            OMemoryInputStream stream = new OMemoryInputStream(iStream);
            byte protocolVersion = stream.peek();
            if (protocolVersion != -1) {
                stream.getAsByte();
                if (protocolVersion != 0) {
                    throw new OSerializationException("The index has been created with a previous version of OrientDB. Soft transitions between version is a featured supported since 0.9.25. In order to use it with this version of OrientDB you need to export and import your database. " + protocolVersion + "<->" + 0);
                }
            }
            rootRid.fromStream(stream.getAsByteArrayFixed(10));
            this.size = stream.getAsInteger();
            this.lastPageSize = protocolVersion == -1 ? (int)stream.getAsShort() : stream.getAsInteger();
            this.serializerFromStream(stream);
            if (rootRid.isValid()) {
                this.root = this.loadEntry(null, rootRid);
            }
            oMVRBTreePersistent = this;
            Object var9_8 = null;
        }
        catch (Exception e) {
            try {
                OLogManager.instance().error((Object)this, "Error on unmarshalling OMVRBTreePersistent object from record: %s", (Throwable)e, OSerializationException.class, new Object[]{rootRid});
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OProfiler.getInstance().stopChrono("OMVRBTreePersistent.fromStream", timer);
                throw throwable;
            }
            OProfiler.getInstance().stopChrono("OMVRBTreePersistent.fromStream", timer);
            return this;
        }
        OProfiler.getInstance().stopChrono("OMVRBTreePersistent.fromStream", timer);
        return oMVRBTreePersistent;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        Object pRoot;
        long timer = OProfiler.getInstance().startChrono();
        Integer identityRecord = System.identityHashCode(this.record);
        Set marshalledRecords = (Set)OSerializationThreadLocal.INSTANCE.get();
        if (marshalledRecords.contains(identityRecord)) {
            return new byte[0];
        }
        marshalledRecords.add(identityRecord);
        OMemoryOutputStream stream = this.entryRecordBuffer;
        try {
            stream.add((byte)0);
            if (this.root != null) {
                pRoot = (OMVRBTreeEntryPersistent)this.root;
                if (((OMVRBTreeEntryPersistent)pRoot).record.getIdentity().isNew()) {
                    ((OMVRBTreeEntryPersistent)pRoot).save();
                }
                stream.addAsFixed(((OMVRBTreeEntryPersistent)pRoot).record.getIdentity().toStream());
            } else {
                stream.addAsFixed(ORecordId.EMPTY_RECORD_ID_STREAM);
            }
            stream.add(this.size);
            stream.add(this.lastPageSize);
            stream.add(this.keySerializer.getName());
            stream.add(this.valueSerializer.getName());
            this.record.fromStream(stream.getByteArray());
            pRoot = this.record.toStream();
            Object var8_7 = null;
            marshalledRecords.remove(identityRecord);
        }
        catch (IOException e) {
            try {
                throw new OSerializationException("Error on marshalling RB+Tree", e);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                marshalledRecords.remove(identityRecord);
                OProfiler.getInstance().stopChrono("OMVRBTreePersistent.toStream", timer);
                throw throwable;
            }
        }
        OProfiler.getInstance().stopChrono("OMVRBTreePersistent.toStream", timer);
        return pRoot;
    }

    public void signalTreeChanged(OMVRBTree<K, V> iTree) {
        this.record.setDirty();
    }

    public void signalNodeChanged(OMVRBTreeEntry<K, V> iNode) {
        this.recordsToCommit.add((OMVRBTreeEntryPersistent)iNode);
    }

    public int hashCode() {
        ORID rid = this.record.getIdentity();
        return rid == null ? 0 : rid.hashCode();
    }

    public ORecordBytes getRecord() {
        return this.record;
    }

    protected void adjustPageSize() {
    }

    public V get(Object iKey) {
        for (int i = 0; i < 10; ++i) {
            try {
                return (V)super.get(iKey);
            }
            catch (OLowMemoryException e) {
                OLogManager.instance().debug((Object)this, "Optimization required during load %d/10", new Object[]{i});
                this.optimize(true);
                System.gc();
                if (i <= 0) continue;
                try {
                    Thread.sleep(300 * i);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new OLowMemoryException("OMVRBTreePersistent.get()");
    }

    public V get(Object iKey, String iFetchPlan) {
        this.fetchPlan = iFetchPlan;
        return this.get(iKey);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    public int getOptimization() {
        return this.optimization;
    }

    public void setOptimization(int i) {
        if (i > 0 && this.optimization == -1) {
            return;
        }
        this.optimization = i;
    }

    protected void checkForOptimization() {
        if (this.optimization > 0) {
            throw new OLowMemoryException("Optimization level: " + this.optimization);
        }
    }

    public int getOptimizeThreshold() {
        return this.optimizeThreshold;
    }

    public void setOptimizeThreshold(int optimizeThreshold) {
        this.optimizeThreshold = optimizeThreshold;
    }

    public int getEntryPointSize() {
        return this.entryPointsSize;
    }

    public void setEntryPointSize(int entryPointSize) {
        this.entryPointsSize = entryPointSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("size=");
        buffer.append(this.size);
        if (this.size > 0) {
            int currPageIndex = this.pageIndex;
            buffer.append(" ");
            buffer.append(this.getFirstEntry().getFirstKey());
            buffer.append("-");
            buffer.append(this.getLastEntry().getLastKey());
            this.pageIndex = currPageIndex;
        }
        return buffer.toString();
    }

    private V internalPut(K key, V value) {
        ORecord rec;
        if (key instanceof ORecord && !(rec = (ORecord)key).getIdentity().isValid()) {
            rec.save();
        }
        if (value instanceof ORecord && !(rec = (ORecord)value).getIdentity().isValid()) {
            rec.save();
        }
        for (int i = 0; i < 10; ++i) {
            try {
                Object previous = super.put(key, value);
                if (this.optimizeThreshold > -1 && ++this.insertionCounter >= this.optimizeThreshold) {
                    this.insertionCounter = 0;
                    this.optimization = 2;
                    this.optimize(true);
                }
                return (V)previous;
            }
            catch (OLowMemoryException e) {
                OLogManager.instance().debug((Object)this, "Optimization required during put %d/10", new Object[]{i});
                this.optimize(true);
                System.gc();
                if (i <= 0) continue;
                try {
                    Thread.sleep(300 * i);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new OLowMemoryException("OMVRBTreePersistent.put()");
    }

    public Object getKeySerializer() {
        return this.keySerializer;
    }

    public Object getValueSerializer() {
        return this.valueSerializer;
    }

    protected OMVRBTreeEntry<K, V> getBestEntryPoint(K iKey) {
        if (!this.entryPoints.isEmpty()) {
            Map.Entry<K, OMVRBTreeEntryPersistent<K, Object>> closerNode = this.entryPoints.floorEntry(iKey);
            if (closerNode != null) {
                return closerNode.getValue();
            }
            closerNode = this.entryPoints.ceilingEntry(iKey);
            if (closerNode != null) {
                return closerNode.getValue();
            }
        }
        return super.getBestEntryPoint(iKey);
    }

    void removeEntryPoint(OMVRBTreeEntryPersistent<K, V> iEntry) {
        this.entryPoints.remove(iEntry);
    }

    synchronized void removeEntry(ORID iEntryId) {
        for (OMVRBTreeEntryPersistent<K, V> node : this.recordsToCommit) {
            if (!node.record.getIdentity().equals(iEntryId)) continue;
            this.recordsToCommit.remove(node);
            break;
        }
    }

    protected OMVRBTreeEntry<K, V> getFirstEntry() {
        Map.Entry<K, OMVRBTreeEntryPersistent<K, V>> entry;
        if (!this.entryPoints.isEmpty() && (entry = this.entryPoints.firstEntry()) != null) {
            OMVRBTreeEntryPersistent prev;
            OMVRBTreeEntryPersistent e = entry.getValue();
            do {
                if ((prev = (OMVRBTreeEntryPersistent)OMVRBTreePersistent.predecessor(e)) == null) continue;
                e = prev;
            } while (prev != null);
            if (e != null && e.getSize() > 0) {
                this.pageIndex = 0;
            }
            return e;
        }
        return super.getFirstEntry();
    }

    protected OMVRBTreeEntry<K, V> getLastEntry() {
        Map.Entry<K, OMVRBTreeEntryPersistent<K, V>> entry;
        if (!this.entryPoints.isEmpty() && (entry = this.entryPoints.lastEntry()) != null) {
            OMVRBTreeEntryPersistent next;
            OMVRBTreeEntryPersistent e = entry.getValue();
            do {
                if ((next = (OMVRBTreeEntryPersistent)OMVRBTreePersistent.successor(e)) == null) continue;
                e = next;
            } while (next != null);
            if (e != null && e.getSize() > 0) {
                this.pageIndex = e.getSize() - 1;
            }
            return e;
        }
        return super.getLastEntry();
    }

    protected void setRoot(OMVRBTreeEntry<K, V> iRoot) {
        if (iRoot == this.root) {
            return;
        }
        super.setRoot(iRoot);
        if (this.listener != null) {
            this.listener.signalTreeChanged((OMVRBTree)this);
        }
    }

    protected void config() {
        this.lastPageSize = OGlobalConfiguration.MVRBTREE_NODE_PAGE_SIZE.getValueAsInteger();
        this.pageLoadFactor = OGlobalConfiguration.MVRBTREE_LOAD_FACTOR.getValueAsFloat();
        this.optimizeEntryPointsFactor = OGlobalConfiguration.MVRBTREE_OPTIMIZE_ENTRYPOINTS_FACTOR.getValueAsFloat();
        this.optimizeThreshold = OGlobalConfiguration.MVRBTREE_OPTIMIZE_THRESHOLD.getValueAsInteger();
        this.entryPointsSize = OGlobalConfiguration.MVRBTREE_ENTRYPOINTS.getValueAsInteger();
    }

    protected void serializerFromStream(OMemoryInputStream stream) throws IOException {
        this.keySerializer = OStreamSerializerFactory.get(stream.getAsString());
        this.valueSerializer = OStreamSerializerFactory.get(stream.getAsString());
    }

    protected void rotateLeft(OMVRBTreeEntry<K, V> p) {
        if (this.debug && p != null) {
            System.out.printf("\nRotating to the left the node %s", ((OMVRBTreeEntryPersistent)p).record.getIdentity());
        }
        super.rotateLeft(p);
    }

    protected void rotateRight(OMVRBTreeEntry<K, V> p) {
        if (this.debug && p != null) {
            System.out.printf("\nRotating to the right the node %s", ((OMVRBTreeEntryPersistent)p).record.getIdentity());
        }
        super.rotateRight(p);
    }

    protected ODatabaseRecord getDatabase() {
        ODatabaseRecord database = (ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get();
        this.record.setDatabase(database);
        return database;
    }

    protected void removeNode(OMVRBTreeEntry<K, V> p) {
        this.removeNodeFromMemory((OMVRBTreeEntryPersistent)p);
        super.removeNode(p);
    }

    protected void removeNodeFromMemory(OMVRBTreeEntryPersistent<K, V> iNode) {
        if (iNode.record != null) {
            this.cache.remove(iNode.record.getIdentity());
        }
        if (iNode.getSize() > 0) {
            this.entryPoints.remove(iNode.getKeyAt(0));
        }
    }

    protected boolean isNodeEntryPoint(OMVRBTreeEntryPersistent<K, V> iNode) {
        if (iNode != null && iNode.getSize() > 0) {
            return this.entryPoints.containsKey(iNode.getKeyAt(0));
        }
        return false;
    }

    protected void addNodeAsEntrypoint(OMVRBTreeEntryPersistent<K, V> iNode) {
        if (iNode != null && iNode.getSize() > 0) {
            this.entryPoints.put(iNode.getKeyAt(0), iNode);
        }
    }

    protected void updateEntryPoint(K iOldKey, OMVRBTreeEntryPersistent<K, V> iNode) {
        OMVRBTreeEntryPersistent<K, V> node = this.entryPoints.remove(iOldKey);
        if (node != iNode) {
            OLogManager.instance().warn((Object)this, "Entrypoints nodes are different during update: old %s <-> new %s", new Object[]{node, iNode});
        }
        this.addNodeAsEntrypoint(node);
    }

    protected void addNodeInCache(OMVRBTreeEntryPersistent<K, V> iNode) {
        if (iNode.record != null) {
            this.cache.put(iNode.record.getIdentity(), iNode);
        }
    }

    protected OMVRBTreeEntryPersistent<K, V> searchNodeInCache(ORID iRid) {
        return this.cache.get(iRid);
    }

    public int getNumberOfNodesInCache() {
        return this.cache.size();
    }

    protected Set<ORID> getAllNodesInCache() {
        return this.cache.keySet();
    }

    protected void removeNodeFromCache(ORID iRid) {
        this.cache.remove(iRid);
    }
}

