/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteThread;
import com.orientechnologies.orient.core.engine.OEngineAbstract;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OEngineRemote
extends OEngineAbstract {
    public static final String NAME = "remote";
    private static final Map<String, OStorageRemote> sharedStorages = new ConcurrentHashMap<String, OStorageRemote>();

    @Override
    public OStorage createStorage(String iURL, Map<String, String> iConfiguration) {
        try {
            OStorageRemote sharedStorage = sharedStorages.get(iURL);
            if (sharedStorage == null) {
                sharedStorage = new OStorageRemote(iURL, "rw");
                sharedStorages.put(iURL, sharedStorage);
            }
            return new OStorageRemoteThread(sharedStorage);
        }
        catch (Throwable t) {
            OLogManager.instance().error((Object)this, "Error on opening database: " + iURL, t, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isShared() {
        return false;
    }
}

