/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OServerAdmin {
    private OStorageRemote storage;
    private int sessionId = -1;

    public OServerAdmin(String iURL) throws IOException {
        if (iURL.startsWith("remote")) {
            iURL = iURL.substring("remote".length() + 1);
        }
        if (!iURL.contains("/")) {
            iURL = iURL + "/";
        }
        this.storage = new OStorageRemote(iURL, "");
    }

    public OServerAdmin(OStorageRemote iStorage) {
        this.storage = iStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OServerAdmin connect(String iUserName, String iUserPassword) throws IOException {
        this.storage.createConnectionPool();
        try {
            OChannelBinaryClient network = this.storage.beginRequest((byte)2);
            try {
                network.writeString(iUserName);
                network.writeString(iUserPassword);
            }
            finally {
                this.storage.endRequest(network);
            }
            try {
                this.storage.beginResponse(network);
                this.sessionId = network.readInt();
                this.storage.setSessionId(this.sessionId);
            }
            finally {
                this.storage.endResponse(network);
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Can't connect to the remote server: " + this.storage.getName(), (Throwable)e, OStorageException.class, new Object[0]);
            this.storage.close(true);
        }
        return this;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OServerAdmin createDatabase(String iStorageMode) throws IOException {
        block7: {
            this.storage.checkConnection();
            try {
                if (this.storage.getName() == null || this.storage.getName().length() <= 0) {
                    OLogManager.instance().error((Object)this, "Can't create unnamed remote storage check your syntax", OStorageException.class);
                    break block7;
                }
                if (iStorageMode == null) {
                    iStorageMode = "csv";
                }
                OChannelBinaryClient network = this.storage.beginRequest((byte)4);
                try {
                    network.writeString(this.storage.getName());
                    network.writeString(iStorageMode);
                }
                finally {
                    this.storage.endRequest(network);
                }
                this.storage.getResponse(network);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Can't create the remote storage: " + this.storage.getName(), (Throwable)e, OStorageException.class, new Object[0]);
                this.storage.close(true);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsDatabase() throws IOException {
        this.storage.checkConnection();
        OChannelBinaryClient network = this.storage.beginRequest((byte)6);
        try {
            network.writeString(this.storage.getName());
        }
        finally {
            this.storage.endRequest(network);
        }
        try {
            this.storage.beginResponse(network);
            boolean bl = network.readByte() == 1;
            this.storage.endResponse(network);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.storage.endResponse(network);
                throw throwable;
            }
            catch (Exception e) {
                OLogManager.instance().exception("Error on checking existance of the remote storage: " + this.storage.getName(), e, OStorageException.class, new Object[0]);
                this.storage.close(true);
                return false;
            }
        }
    }

    @Deprecated
    public OServerAdmin deleteDatabase() throws IOException {
        return this.dropDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OServerAdmin dropDatabase() throws IOException {
        this.storage.checkConnection();
        try {
            OChannelBinaryClient network = this.storage.beginRequest((byte)7);
            try {
                network.writeString(this.storage.getName());
            }
            finally {
                this.storage.endRequest(network);
            }
            this.storage.getResponse(network);
        }
        catch (Exception e) {
            OLogManager.instance().exception("Can't delete the remote storage: " + this.storage.getName(), e, OStorageException.class, new Object[0]);
            this.storage.close(true);
        }
        for (OStorage s : Orient.instance().getStorages()) {
            if (!s.getURL().startsWith(this.getURL())) continue;
            s.removeResource(OSchema.class.getSimpleName());
            s.removeResource(OIndexManager.class.getSimpleName());
            s.removeResource(OSecurity.class.getSimpleName());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OServerAdmin shareDatabase(String iDatabaseName, String iDatabaseUserName, String iDatabaseUserPassword, String iRemoteName, boolean iSynchronousMode) throws IOException {
        this.storage.checkConnection();
        try {
            OChannelBinaryClient network = this.storage.beginRequest((byte)85);
            try {
                network.writeString(iDatabaseName);
                network.writeString(iDatabaseUserName);
                network.writeString(iDatabaseUserPassword);
                network.writeString(iRemoteName);
                network.writeByte((byte)(iSynchronousMode ? 1 : 0));
            }
            finally {
                this.storage.endRequest(network);
            }
            this.storage.getResponse(network);
            OLogManager.instance().debug((Object)this, "Database '%s' has been shared in mode '%s' with the server '%s'", new Object[]{iDatabaseName, iSynchronousMode, iRemoteName});
        }
        catch (Exception e) {
            OLogManager.instance().exception("Can't share the database: " + iDatabaseName, e, OStorageException.class, new Object[0]);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getGlobalConfigurations() throws IOException {
        this.storage.checkConnection();
        HashMap<String, String> config = new HashMap<String, String>();
        try {
            OChannelBinaryClient network = this.storage.beginRequest((byte)72);
            this.storage.endRequest(network);
            try {
                this.storage.beginResponse(network);
                int num = network.readShort();
                for (int i = 0; i < num; ++i) {
                    config.put(network.readString(), network.readString());
                }
            }
            finally {
                this.storage.endResponse(network);
            }
        }
        catch (Exception e) {
            OLogManager.instance().exception("Can't retrieve the configuration list", e, OStorageException.class, new Object[0]);
            this.storage.close(true);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGlobalConfiguration(OGlobalConfiguration iConfig) throws IOException {
        this.storage.checkConnection();
        OChannelBinaryClient network = this.storage.beginRequest((byte)70);
        network.writeString(iConfig.getKey());
        this.storage.beginResponse(network);
        try {
            String string = network.readString();
            this.storage.endResponse(network);
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.storage.endResponse(network);
                throw throwable;
            }
            catch (Exception e) {
                OLogManager.instance().exception("Can't retrieve the configuration value: " + iConfig.getKey(), e, OStorageException.class, new Object[0]);
                this.storage.close(true);
                return null;
            }
        }
    }

    public OServerAdmin setGlobalConfiguration(OGlobalConfiguration iConfig, Object iValue) throws IOException {
        this.storage.checkConnection();
        try {
            OChannelBinaryClient network = this.storage.beginRequest((byte)71);
            network.writeString(iConfig.getKey());
            network.writeString(iValue != null ? iValue.toString() : "");
            this.storage.getResponse(network);
        }
        catch (Exception e) {
            OLogManager.instance().exception("Can't set the configuration value: " + iConfig.getKey(), e, OStorageException.class, new Object[0]);
            this.storage.close(true);
        }
        return this;
    }

    public void close() {
        this.storage.close();
    }

    public void close(boolean iForce) {
        this.storage.close(iForce);
    }

    public String getURL() {
        return this.storage != null ? this.storage.getURL() : null;
    }
}

