/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.client.remote.ORemoteServerEventListener;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteThread;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import java.io.IOException;

public class OStorageRemoteServiceThread
extends OSoftThread {
    private final OStorageRemoteThread storage;
    private OChannelBinaryClient network;

    public OStorageRemoteServiceThread(OStorageRemoteThread iStorageRemote, OChannelBinaryClient iFirstChannel) {
        super("ClientService");
        this.storage = iStorageRemote;
        this.network = iFirstChannel;
        this.start();
    }

    protected void execute() throws Exception {
        try {
            try {
                this.storage.beginResponse(this.network);
            }
            catch (IOException ioe) {
                this.sendShutdown();
                this.storage.closeChannel(this.network);
                this.storage.handleException("Network connection lost", ioe);
                return;
            }
            byte request = this.network.readByte();
            switch (request) {
                case 79: {
                    ORecordInternal record = (ORecordInternal)OStorageRemote.readIdentifiable(this.network, null);
                    for (ORemoteServerEventListener listener : this.storage.getRemoteServerEventListeners()) {
                        listener.onRecordPulled(record);
                    }
                    this.storage.getLevel2Cache().updateRecord(record);
                    break;
                }
                case 100: {
                    byte[] clusterConfig = this.network.readBytes();
                    for (ORemoteServerEventListener listener : this.storage.getRemoteServerEventListeners()) {
                        listener.onClusterConfigurationChange(clusterConfig);
                    }
                    this.storage.updateClusterConfiguration(clusterConfig);
                }
            }
            this.network.endResponse();
        }
        catch (Exception e) {
            this.sendShutdown();
        }
    }
}

