/*
 * Decompiled with CFR 0.152.
 */
package play.modules.paginate.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.modules.paginate.strategy.RecordLocatorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByKeyRecordLocatorStrategy<K, T>
implements RecordLocatorStrategy<T> {
    private final List<K> index;
    private final List<T> values;
    private final Map<K, T> store;

    public ByKeyRecordLocatorStrategy() {
        this(new HashMap());
    }

    public ByKeyRecordLocatorStrategy(Map<K, T> store) {
        this.store = store;
        this.index = new ArrayList<K>(store.keySet());
        this.values = new ArrayList<T>(store.values());
    }

    @Override
    public List<T> fetchPage(int startRowIdx, int lastRowIdx) {
        List<K> keys = this.index.subList(startRowIdx, lastRowIdx);
        return this.findByKey(keys);
    }

    @Override
    public int count() {
        return this.index.size();
    }

    @Override
    public int indexOf(T t) {
        return this.values.indexOf(t);
    }

    @Override
    public int lastIndexOf(T t) {
        return this.values.lastIndexOf(t);
    }

    private List<T> findByKey(List<K> input) {
        ArrayList<T> output = new ArrayList<T>();
        for (K key : input) {
            output.add(this.store.get(key));
        }
        return output;
    }
}

