/*
 * Decompiled with CFR 0.152.
 */
package play.modules.paginate.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import play.modules.paginate.strategy.RecordLocatorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByValueRecordLocatorStrategy<T>
implements RecordLocatorStrategy<T> {
    private final List<T> values;

    public ByValueRecordLocatorStrategy() {
        this.values = new ArrayList<T>();
    }

    public ByValueRecordLocatorStrategy(List<T> values) {
        this.values = values;
    }

    @Override
    public List<T> fetchPage(int startRowIdx, int lastRowIdx) {
        if (this.values == null) {
            return Collections.emptyList();
        }
        List<T> pageValues = this.values.subList(startRowIdx, lastRowIdx);
        return pageValues;
    }

    @Override
    public int count() {
        return this.values.size();
    }

    @Override
    public int indexOf(T t) {
        return this.values.indexOf(t);
    }

    @Override
    public int lastIndexOf(T t) {
        return this.values.lastIndexOf(t);
    }
}

