/*
 * Decompiled with CFR 0.152.
 */
package play.modules.paginate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import play.Logger;
import play.Play;
import play.modules.paginate.strategy.RecordLocatorStrategy;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Paginator<K, T>
implements List<T>,
Serializable {
    private static final String DEFAULT_PAGE_PARAM = "page";
    private static final long serialVersionUID = -2064492602195638937L;
    private int pageSize = 20;
    private Map<Long, List<T>> pages = new HashMap<Long, List<T>>();
    private RecordLocatorStrategy<T> recordLocatorStrategy;
    private int pageNumber = 0;
    private Integer rowCount;
    private final String action;
    private String paramName;
    private final Map<String, Object> viewParams;
    private boolean boundaryControlsEnabled;
    private int pagesDisplayed;
    private static final int DEFAULT_PAGE_SIZE = 20;

    private Paginator() {
        Http.Request request = Http.Request.current();
        this.action = request != null ? request.action : null;
        Scope.Params params = Scope.Params.current();
        this.viewParams = new HashMap<String, Object>();
        if (params != null) {
            this.setParameterName(Play.configuration.getProperty("paginator.parameter.name", DEFAULT_PAGE_PARAM));
            this.viewParams.putAll(params.allSimple());
        } else {
            this.paramName = DEFAULT_PAGE_PARAM;
        }
        this.viewParams.remove("body");
        this.boundaryControlsEnabled = true;
        this.pagesDisplayed = 5;
    }

    protected Paginator(RecordLocatorStrategy recordLocatorStrategy) {
        this();
        this.recordLocatorStrategy = recordLocatorStrategy;
    }

    protected RecordLocatorStrategy getRecordLocatorStrategy() {
        return this.recordLocatorStrategy;
    }

    public String getCallbackURL(int page) {
        this.viewParams.put(this.paramName, String.valueOf(page));
        return Router.reverse((String)this.action, this.viewParams).url;
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException("PaginatingLists are immutable.");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("PaginatingLists are immutable.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("PaginatingLists are immutable.");
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            int idx = this.indexOf(it.next());
            if (idx >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int rowIndex) {
        int idx = rowIndex % this.pageSize;
        List<T> page = this.getPage(rowIndex);
        if (idx >= page.size()) {
            return null;
        }
        return page.get(idx);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Paginator<K, T> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public int getRowCount() {
        return this.size();
    }

    public String getParameterName() {
        return this.paramName;
    }

    public void setParameterName(String paramName) {
        this.paramName = paramName;
        this.parsePageParameter();
    }

    public int getPageNumber() {
        return this.pageNumber + 1;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber - 1;
    }

    public int getPageCount() {
        int numberOfFullPages;
        int numberOfRows = this.size();
        int numberOfPages = numberOfFullPages = numberOfRows / this.pageSize;
        if (numberOfRows % this.pageSize > 0) {
            ++numberOfPages;
        }
        return numberOfPages;
    }

    public List<T> getCurrentPage() {
        return this.getPage(this.getFirstRowIndex());
    }

    public boolean getHasPreviousPage() {
        return this.pageNumber != 0;
    }

    public boolean getHasNextPage() {
        return this.pageNumber < this.getPageCount() - 1;
    }

    public int getFirstRowIndex() {
        int startRow = this.pageNumber * this.pageSize;
        return startRow;
    }

    public int getLastRowIndex() {
        int startRow = this.getFirstRowIndex();
        int lastRow = Math.min(this.getRowCount(), startRow + this.pageSize);
        return lastRow - 1;
    }

    private List<T> getPage(int rowIndex) {
        if (this.pageSize == 0) {
            return new ArrayList();
        }
        int pageNumber = rowIndex / this.pageSize;
        int startRow = pageNumber * this.pageSize;
        Long key = startRow;
        List<T> page = this.pages.get(key);
        if (page == null) {
            page = this.fetchPage(startRow);
            this.pages.put(key, page);
        }
        return page;
    }

    public void previous() {
        if (this.getHasPreviousPage()) {
            this.setPageNumber(this.getPageNumber() - 1);
        }
    }

    public void next() {
        if (this.getHasNextPage()) {
            this.setPageNumber(this.getPageNumber() + 1);
        }
    }

    public boolean isBoundaryControlsEnabled() {
        return this.boundaryControlsEnabled;
    }

    public Paginator<K, T> setBoundaryControlsEnabled(boolean showBoundaryControls) {
        this.boundaryControlsEnabled = showBoundaryControls;
        return this;
    }

    public int getPagesDisplayed() {
        return this.pagesDisplayed;
    }

    public Paginator<K, T> setPagesDisplayed(int pagesDisplayed) {
        this.pagesDisplayed = pagesDisplayed;
        return this;
    }

    protected int getPagesLoaded() {
        return this.pages.keySet().size();
    }

    @Override
    public int indexOf(Object o) {
        return this.recordLocatorStrategy.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ListItr(this);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.recordLocatorStrategy.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ListItr(this);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ListItr(this, index);
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("PaginatingLists are immutable.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("PaginatingLists are immutable.");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("PaginatingLists are immutable.");
    }

    @Override
    public int size() {
        if (this.rowCount == null) {
            this.rowCount = this.recordLocatorStrategy.count();
        }
        return this.rowCount;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("PaginatingLists can not be transformed.");
    }

    @Override
    public T[] toArray() {
        throw new UnsupportedOperationException("PaginatingLists can not be transformed into arrays.");
    }

    private static int getLastRowForPage(int startRow, int pageSize, int rowCount) {
        int lastRow = startRow + pageSize;
        if (lastRow > rowCount) {
            lastRow = rowCount;
        }
        return lastRow;
    }

    private List<T> fetchPage(int startRowIdx) {
        int lastRowIdx = Paginator.getLastRowForPage(startRowIdx, this.pageSize, this.getRowCount());
        return this.recordLocatorStrategy.fetchPage(startRowIdx, lastRowIdx);
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        return false;
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("PaginatingLists are immutable.");
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("PaginatingLists are immutable.");
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        throw new UnsupportedOperationException("PaginatingLists can not be transformed into arrays.");
    }

    private void parsePageParameter() {
        Scope.Params params = Scope.Params.current();
        String page = params.get(this.paramName);
        if (page == null) {
            this.setPageNumber(1);
        } else {
            try {
                int pageNumber = Integer.parseInt(page);
                this.setPageNumber(pageNumber);
            }
            catch (Throwable t) {
                Logger.warn((Throwable)t, (String)"Error parsing page: %s", (Object[])new Object[]{page});
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListItr<K, T>
    implements Iterator<T>,
    ListIterator<T> {
        Paginator<K, T> theList;
        int currentIndex;
        int maxRecords;

        public ListItr(Paginator<K, T> list) {
            this(list, 0);
        }

        public ListItr(Paginator<K, T> list, int startIndex) {
            this.theList = list;
            this.currentIndex = startIndex;
            this.maxRecords = this.theList.size();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.maxRecords;
        }

        @Override
        public T next() {
            return this.theList.get(this.currentIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("PaginatingLists are immutable.");
        }

        @Override
        public void add(T arg0) {
            throw new UnsupportedOperationException("PaginatingLists are immutable.");
        }

        @Override
        public boolean hasPrevious() {
            return this.currentIndex > 0;
        }

        @Override
        public int nextIndex() {
            return this.currentIndex;
        }

        @Override
        public T previous() {
            return this.theList.get(--this.currentIndex);
        }

        @Override
        public int previousIndex() {
            return this.currentIndex - 1;
        }

        @Override
        public void set(T arg0) {
            throw new UnsupportedOperationException("PaginatingLists are immutable.");
        }
    }
}

