/*
 * Decompiled with CFR 0.152.
 */
package play.modules.paginate.strategy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceUnit;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import play.Play;
import play.db.jpa.JPA;
import play.exceptions.UnexpectedException;
import play.modules.paginate.strategy.RecordLocatorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPARecordLocatorStrategy<K, T>
implements RecordLocatorStrategy<T> {
    private String filter;
    private String keyFilter;
    private Object[] params;
    private String orderBy;
    private final Class<T> typeToken;
    private boolean useQueryCache;
    private String key = "id";
    private static final String SELECT = "SELECT ";

    public JPARecordLocatorStrategy(Class<T> typeToken) {
        this.typeToken = typeToken;
        String useQueryCacheStr = Play.configuration.getProperty("paginator.jpa.useQueryCache", "true");
        this.useQueryCache = Boolean.parseBoolean(useQueryCacheStr);
    }

    public JPARecordLocatorStrategy(Class<T> typeToken, List<K> keys) {
        this(typeToken);
        String preparedStatementParameters = StringUtils.repeat((String)"?,", (int)keys.size());
        preparedStatementParameters = preparedStatementParameters.substring(0, preparedStatementParameters.length() - 1);
        this.keyFilter = "IN (" + preparedStatementParameters + ")";
        this.params = keys.toArray();
    }

    public JPARecordLocatorStrategy(Class<T> typeToken, String filter, Object ... params) {
        this(typeToken);
        this.filter = filter;
        this.params = params;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void withKeyNamed(String key) {
        this.key = key;
    }

    public Class<T> getModel() {
        return this.typeToken;
    }

    @Override
    public int count() {
        return ((Long)this.query("COUNT(*)", false).getSingleResult()).intValue();
    }

    @Override
    public int indexOf(T t) {
        return -1;
    }

    @Override
    public int lastIndexOf(T t) {
        return -1;
    }

    @Override
    public List<T> fetchPage(int startRowIdx, int lastRowIdx) {
        List<T> pageValues = this.findByIndex(startRowIdx, lastRowIdx);
        return pageValues;
    }

    private List<T> findByIndex(int firstRowIdx, int lastRowIdx) {
        int pageSize = lastRowIdx - firstRowIdx;
        List returnMe = this.query(null, true).setFirstResult(firstRowIdx).setMaxResults(pageSize).getResultList();
        return returnMe;
    }

    protected Query query(String select, boolean applyOrderBy) {
        StringBuilder hql = new StringBuilder();
        if (select != null) {
            if (!select.regionMatches(true, 0, SELECT, 0, SELECT.length())) {
                hql.append(SELECT);
            }
            hql.append(select);
            hql.append(' ');
        }
        hql.append("FROM " + this.getEntityName());
        if (this.filter != null) {
            hql.append(" WHERE " + this.filter);
        } else if (this.keyFilter != null) {
            hql.append(" WHERE " + this.key + " " + this.keyFilter);
        }
        if (applyOrderBy && this.orderBy != null) {
            hql.append(" ORDER BY " + this.orderBy);
        }
        EntityManager em = JPA.em();
        if (this.typeToken.isAnnotationPresent(PersistenceUnit.class)) {
            String unitName = this.typeToken.getAnnotation(PersistenceUnit.class).name();
            try {
                Method getJPAConfigMethod = JPA.class.getMethod("getJPAConfig", String.class);
                if (getJPAConfigMethod != null) {
                    Object config = getJPAConfigMethod.invoke(JPA.class, unitName);
                    Method getJPAContextMethod = config.getClass().getMethod("getJPAContext", new Class[0]);
                    Object context = getJPAContextMethod.invoke(config, new Object[0]);
                    Method emMethod = context.getClass().getMethod("em", new Class[0]);
                    em = (EntityManager)emMethod.invoke(context, new Object[0]);
                }
            }
            catch (SecurityException e) {
                throw new UnexpectedException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new UnexpectedException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new UnexpectedException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
        Query query = em.createQuery(hql.toString());
        if (this.useQueryCache) {
            query.setHint("org.hibernate.cacheable", (Object)true);
        }
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                query.setParameter(i + 1, this.params[i]);
            }
        }
        return query;
    }

    private String getEntityName() {
        String entityName = this.typeToken.getAnnotation(Entity.class).name();
        if (entityName.length() == 0) {
            entityName = this.typeToken.getSimpleName();
        }
        return entityName;
    }
}

