/*
 * Decompiled with CFR 0.152.
 */
package play.modules.pdf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.allcolor.yahp.converter.IHtmlToPdfTransformer;
import org.apache.commons.io.FilenameUtils;
import play.Play;
import play.classloading.enhancers.LocalvariablesNamesEnhancer;
import play.data.validation.Validation;
import play.exceptions.PlayException;
import play.exceptions.TemplateNotFoundException;
import play.exceptions.UnexpectedException;
import play.modules.pdf.RenderPDFTemplate;
import play.mvc.Http;
import play.mvc.Scope;
import play.vfs.VirtualFile;

public class PDF {
    public static void renderPDF(Object ... args) {
        OutputStream os = null;
        PDF.writePDF(os, args);
    }

    public static void writePDF(File file, Object ... args) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            PDF.writePDF(os, new Object[0]);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static void writePDF(OutputStream out, Object ... args) {
        Http.Request request = Http.Request.current();
        String format = request.format;
        PDFDocument singleDoc = new PDFDocument();
        MultiPDFDocuments docs = null;
        if (args.length > 0) {
            if (args[0] instanceof String && LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.getAllLocalVariableNames((Object)args[0]).isEmpty()) {
                singleDoc.template = args[0].toString();
            } else if (args[0] instanceof MultiPDFDocuments) {
                docs = (MultiPDFDocuments)args[0];
            }
            if (docs == null) {
                for (Object arg : args) {
                    if (!(arg instanceof Options)) continue;
                    singleDoc.options = (Options)arg;
                }
            }
        }
        if (docs == null) {
            docs = new MultiPDFDocuments();
            docs.add(singleDoc);
            if (singleDoc.template == null) {
                singleDoc.template = request.action.replace(".", "/") + "." + (format == null ? "html" : format);
            }
            docs.filename = singleDoc.options != null && singleDoc.options.filename != null ? singleDoc.options.filename : FilenameUtils.getBaseName((String)singleDoc.template) + ".pdf";
        }
        PDF.renderTemplateAsPDF(out, docs, args);
    }

    static String resolveTemplateName(String templateName, Http.Request request, String format) {
        VirtualFile template;
        if (templateName.startsWith("@")) {
            if (!(templateName = templateName.substring(1)).contains(".")) {
                templateName = request.controller + "." + templateName;
            }
            templateName = templateName.replace(".", "/") + "." + (format == null ? "html" : format);
        }
        if (!((template = Play.getVirtualFile((String)templateName)) != null && template.exists() || templateName.lastIndexOf("." + format) == -1)) {
            templateName = templateName.substring(0, templateName.lastIndexOf("." + format)) + ".html";
        }
        return templateName;
    }

    public static void renderTemplateAsPDF(OutputStream out, MultiPDFDocuments docs, Object ... args) {
        Scope.RenderArgs templateBinding = Scope.RenderArgs.current();
        for (Object o : args) {
            List names = LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.getAllLocalVariableNames((Object)o);
            for (String name : names) {
                templateBinding.put(name, o);
            }
        }
        templateBinding.put("session", (Object)Scope.Session.current());
        templateBinding.put("request", (Object)Http.Request.current());
        templateBinding.put("flash", (Object)Scope.Flash.current());
        templateBinding.put("params", (Object)Scope.Params.current());
        try {
            templateBinding.put("errors", (Object)Validation.errors());
        }
        catch (Exception ex) {
            throw new UnexpectedException((Throwable)ex);
        }
        try {
            if (out == null) {
                throw new RenderPDFTemplate(docs, templateBinding.data);
            }
            RenderPDFTemplate renderer = new RenderPDFTemplate(docs, templateBinding.data);
            renderer.writePDF(out, Http.Request.current(), Http.Response.current());
        }
        catch (TemplateNotFoundException ex) {
            if (ex.isSourceAvailable()) {
                throw ex;
            }
            StackTraceElement element = PlayException.getInterestingStrackTraceElement((Throwable)ex);
            if (element != null) {
                throw new TemplateNotFoundException(ex.getPath(), Play.classes.getApplicationClass(element.getClassName()), Integer.valueOf(element.getLineNumber()));
            }
            throw ex;
        }
    }

    public static class MultiPDFDocuments {
        public List<PDFDocument> documents = new LinkedList<PDFDocument>();
        public String filename;

        public MultiPDFDocuments(String filename) {
            this.filename = filename;
        }

        public MultiPDFDocuments() {
        }

        public MultiPDFDocuments add(PDFDocument singleDoc) {
            this.documents.add(singleDoc);
            return this;
        }

        public MultiPDFDocuments add(String template, Options options) {
            this.documents.add(new PDFDocument(template, options));
            return this;
        }
    }

    public static class PDFDocument {
        public String template;
        public Options options;
        List<IHtmlToPdfTransformer.CHeaderFooter> headerFooterList = new LinkedList<IHtmlToPdfTransformer.CHeaderFooter>();
        String content;

        public PDFDocument(String template, Options options) {
            this.template = template;
            this.options = options;
        }

        public PDFDocument() {
        }
    }

    public static class Options {
        public String FOOTER = null;
        public String FOOTER_TEMPLATE = null;
        public String HEADER = null;
        public String HEADER_TEMPLATE = null;
        public String ALL_PAGES = null;
        public String EVEN_PAGES = null;
        public String ODD_PAGES = null;
        public String filename = null;
        public IHtmlToPdfTransformer.PageSize pageSize = IHtmlToPdfTransformer.A4P;
    }
}

