/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.imageio.ImageIO;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.util.XRLog;
import play.Logger;
import play.Play;
import play.vfs.VirtualFile;

public class NaiveUserAgent
implements UserAgentCallback,
DocumentListener {
    private static final int DEFAULT_IMAGE_CACHE_SIZE = 16;
    protected LinkedHashMap _imageCache;
    private int _imageCacheCapacity;
    private String _baseURL;

    public NaiveUserAgent() {
        this(16);
    }

    public NaiveUserAgent(int imgCacheSize) {
        this._imageCacheCapacity = imgCacheSize;
        this._imageCache = new LinkedHashMap(this._imageCacheCapacity, 0.75f, true);
    }

    public void shrinkImageCache() {
        int ovr = this._imageCache.size() - this._imageCacheCapacity;
        Iterator it = this._imageCache.keySet().iterator();
        while (it.hasNext() && ovr-- > 0) {
            it.next();
            it.remove();
        }
    }

    public void clearImageCache() {
        this._imageCache.clear();
    }

    protected InputStream resolveAndOpenStream(String uri) {
        InputStream is = null;
        uri = this.resolveURI(uri);
        try {
            is = new URL(uri).openStream();
        }
        catch (MalformedURLException e) {
            XRLog.exception("bad URL given: " + uri, e);
        }
        catch (FileNotFoundException e) {
            XRLog.exception("item at URI " + uri + " not found");
        }
        catch (IOException e) {
            XRLog.exception("IO problem for " + uri, e);
        }
        return is;
    }

    @Override
    public CSSResource getCSSResource(String uri) {
        return new CSSResource(this.resolveAndOpenStream(uri));
    }

    @Override
    public ImageResource getImageResource(String uri) {
        ImageResource ir;
        block18: {
            InputStream is;
            ir = (ImageResource)this._imageCache.get(uri = this.resolveURI(uri));
            if (ir == null && (is = this.resolveAndOpenStream(uri)) != null) {
                try {
                    BufferedImage img = ImageIO.read(is);
                    if (img == null) {
                        throw new IOException("ImageIO.read() returned null");
                    }
                    ir = this.createImageResource(uri, img);
                    this._imageCache.put(uri, ir);
                }
                catch (FileNotFoundException e) {
                    XRLog.exception("Can't read image file; image at URI '" + uri + "' not found");
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    break block18;
                }
                catch (IOException e) {
                    try {
                        XRLog.exception("Can't read image file; unexpected problem for URI '" + uri + "'", e);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (ir == null) {
            ir = this.createImageResource(uri, null);
        }
        return ir;
    }

    protected ImageResource createImageResource(String uri, Image img) {
        return new ImageResource(uri, AWTFSImage.createImage(img));
    }

    @Override
    public XMLResource getXMLResource(String uri) {
        XMLResource xmlResource;
        InputStream inputStream = this.resolveAndOpenStream(uri);
        try {
            xmlResource = XMLResource.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return xmlResource;
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] getBinaryResource(String uri) {
        byte[] byArray;
        InputStream is;
        block13: {
            byte[] arrayOfByte1;
            int i;
            is = this.resolveAndOpenStream(uri);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            while ((i = is.read(buf)) != -1) {
                result.write(buf, 0, i);
            }
            is.close();
            is = null;
            byArray = arrayOfByte1 = result.toByteArray();
            if (is == null) break block13;
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
        catch (IOException e) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public boolean isVisited(String uri) {
        return false;
    }

    @Override
    public void setBaseURL(String url) {
        this._baseURL = url;
    }

    @Override
    public String resolveURI(String uri) {
        if (uri == null) {
            return null;
        }
        String ret = null;
        if (this._baseURL == null) {
            try {
                URL result = new URL(uri);
                this.setBaseURL(result.toExternalForm());
            }
            catch (MalformedURLException e) {
                try {
                    this.setBaseURL(new File(".").toURI().toURL().toExternalForm());
                }
                catch (Exception e1) {
                    XRLog.exception("The default NaiveUserAgent doesn't know how to resolve the base URL for " + uri);
                    return null;
                }
            }
        }
        try {
            VirtualFile file = Play.getVirtualFile((String)uri);
            Logger.debug((String)"Resolved uri %s to file %s", (Object[])new Object[]{uri, file});
            if (file != null && file.exists()) {
                return file.getRealFile().toURI().toURL().toExternalForm();
            }
            return new URL(uri).toString();
        }
        catch (MalformedURLException e) {
            XRLog.load(String.valueOf(uri) + " is not a URL; may be relative. Testing using parent URL " + this._baseURL);
            try {
                URL result = new URL(new URL(this._baseURL), uri);
                ret = result.toString();
            }
            catch (MalformedURLException e1) {
                XRLog.exception("The default NaiveUserAgent cannot resolve the URL " + uri + " with base URL " + this._baseURL);
            }
            return ret;
        }
    }

    @Override
    public String getBaseURL() {
        return this._baseURL;
    }

    @Override
    public void documentStarted() {
        this.shrinkImageCache();
    }

    @Override
    public void documentLoaded() {
    }

    @Override
    public void onLayoutException(Throwable t) {
    }

    @Override
    public void onRenderException(Throwable t) {
    }
}

