/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;

final class ClassStuff {
    private ClassStuff() {
    }

    static Object createFactory(String label, String defaultClass) throws FactoryConfigurationError {
        String name = null;
        ClassLoader loader = null;
        try {
            Method m = null;
            m = Thread.class.getMethod("getContextClassLoader", null);
            loader = (ClassLoader)m.invoke((Object)Thread.currentThread(), null);
        }
        catch (NoSuchMethodException e) {
            loader = ClassStuff.class.getClassLoader();
        }
        catch (NoSuchMethodError e) {
            loader = ClassStuff.class.getClassLoader();
        }
        catch (Throwable e) {
            throw new UnknownError(e.getMessage());
        }
        try {
            name = System.getProperty(label);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            String javaHome;
            File file;
            if (name == null && (file = new File(new File(javaHome = System.getProperty("java.home"), "lib"), "jaxp.properties")).exists()) {
                FileInputStream in = new FileInputStream(file);
                Properties props = new Properties();
                props.load(in);
                name = props.getProperty(label);
                in.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (name == null) {
            try {
                String service = "META-INF/services/" + label;
                InputStream in = loader == null ? ClassLoader.getSystemResourceAsStream(service) : loader.getResourceAsStream(service);
                if (in != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
                    name = reader.readLine();
                    in.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (name == null) {
            name = defaultClass;
        }
        try {
            Class<?> klass = loader == null ? Class.forName(name) : loader.loadClass(name);
            return klass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new FactoryConfigurationError(e, "Factory class " + name + " not found");
        }
        catch (IllegalAccessException e) {
            throw new FactoryConfigurationError(e, "Factory class " + name + " found but cannot be loaded");
        }
        catch (InstantiationException e) {
            throw new FactoryConfigurationError(e, "Factory class " + name + " loaded but cannot be instantiated" + " ((no default constructor?)");
        }
    }
}

