/*
 * Decompiled with CFR 0.152.
 */
package org.allcolor.yahp.converter;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class CClassLoaderConfig {
    private Map filesMap = new HashMap();
    private Map loadersInfoMap = new HashMap();

    public void addFile(String loaderPath, URL file) {
        ArrayList<URL> list = (ArrayList<URL>)this.filesMap.get(loaderPath);
        if (list == null) {
            list = new ArrayList<URL>();
            this.filesMap.put(loaderPath, list);
        }
        list.add(file);
    }

    public void addLoaderInfo(String loaderPath, CLoaderInfo info) {
        this.loadersInfoMap.put(loaderPath, info);
    }

    public final Map getFilesMap() {
        return this.filesMap;
    }

    public final Map getLoadersInfoMap() {
        return this.loadersInfoMap;
    }

    public static final class CLoaderInfo {
        private boolean mandatory;
        private boolean alone;
        private boolean resourceOnly;
        private boolean doNotForwardToParent;

        public CLoaderInfo(boolean mandatory, boolean alone, boolean only, boolean parent) {
            this.mandatory = mandatory;
            this.alone = alone;
            this.resourceOnly = only;
            this.doNotForwardToParent = parent;
        }

        public final boolean isAlone() {
            return this.alone;
        }

        public final boolean isDoNotForwardToParent() {
            return this.doNotForwardToParent;
        }

        public final boolean isMandatory() {
            return this.mandatory;
        }

        public final boolean isResourceOnly() {
            return this.resourceOnly;
        }
    }
}

