/*
 * Decompiled with CFR 0.152.
 */
package org.allcolor.yahp.converter;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;

public final class CMutex {
    private static final Object IDLOCK = new Object();
    private static int sid = 0;
    private int acquire = 0;
    private int id = -1;
    private final Object LOCK = new Object();
    private WeakReference owner = null;

    public static final void acquireMultiple(CMutex[] mutex) {
        Arrays.sort(mutex, new CMutexComparator());
        for (int i = 0; i < mutex.length; ++i) {
            mutex[i].acquire();
        }
    }

    public static final void acquireMultiple(long timeout, CMutex[] mutex) throws RuntimeException {
        Arrays.sort(mutex, new CMutexComparator());
        for (int i = 0; i < mutex.length; ++i) {
            try {
                mutex[i].acquire(timeout);
                continue;
            }
            catch (RuntimeException re) {
                for (int j = i - 1; j >= 0; --j) {
                    if (!mutex[j].isOwner()) continue;
                    mutex[j].release();
                }
                throw re;
            }
        }
    }

    public static final void releaseMultiple(CMutex[] mutex) {
        Arrays.sort(mutex, new CMutexComparator());
        for (int i = mutex.length - 1; i >= 0; --i) {
            mutex[i].release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMutex() {
        Object object = IDLOCK;
        synchronized (object) {
            this.id = sid++;
        }
    }

    public final void acquire() {
        boolean cont = true;
        while (cont) {
            try {
                cont = false;
                this.acquire(-1L);
            }
            catch (RuntimeException te) {
                cont = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void acquire(long timeout) throws RuntimeException {
        Object object = this.LOCK;
        synchronized (object) {
            long start = System.currentTimeMillis();
            while (this.owner != null) {
                if (this.owner.get() == Thread.currentThread()) {
                    ++this.acquire;
                    return;
                }
                try {
                    if (timeout == -1L) {
                        this.LOCK.wait();
                    } else {
                        this.LOCK.wait(timeout);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long end = System.currentTimeMillis();
                if (this.owner == null || timeout == -1L || end - start < timeout) continue;
                throw new RuntimeException("TimeoutException");
            }
            this.owner = new WeakReference<Thread>(Thread.currentThread());
            ++this.acquire;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOwner() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.owner != null && this.owner.get() == Thread.currentThread();
        }
    }

    public final void release() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.owner != null && this.owner.get() == Thread.currentThread()) {
                --this.acquire;
                if (this.acquire == 0) {
                    this.owner = null;
                    this.LOCK.notify();
                }
                return;
            }
            if (this.owner != null && this.owner.get() == null) {
                this.owner = null;
                this.acquire = 0;
                this.LOCK.notify();
            }
            throw new IllegalMonitorStateException(Thread.currentThread().getName() + " is not the owner of the lock. " + (this.owner != null ? ((Thread)this.owner.get()).getName() : "nobody") + " is the owner.");
        }
    }

    private static final class CMutexComparator
    implements Comparator {
        private CMutexComparator() {
        }

        public int compare(Object o1, Object o2) {
            CMutex m1 = (CMutex)o1;
            CMutex m2 = (CMutex)o2;
            return m1.id - m2.id;
        }
    }
}

