/*
 * Decompiled with CFR 0.152.
 */
package org.allcolor.yahp.converter;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.allcolor.yahp.converter.CMutex;

public final class CThreadContext {
    private static final Map contextLocal = new HashMap();
    private final Map valueMap = new HashMap();
    private final CMutex mutex = new CMutex();

    public static final CThreadContext getInstance() {
        SoftReference<CThreadContext> ref = (SoftReference<CThreadContext>)contextLocal.get(Thread.currentThread());
        CThreadContext context = null;
        if (ref == null || ref.get() == null) {
            context = new CThreadContext();
            ref = new SoftReference<CThreadContext>(context);
            contextLocal.put(Thread.currentThread(), ref);
        } else {
            context = (CThreadContext)ref.get();
        }
        return context;
    }

    public static void destroy() {
        contextLocal.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(String key) {
        try {
            this.mutex.acquire();
            Object v = this.valueMap.get(key);
            return v;
        }
        finally {
            try {
                this.mutex.release();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(String key, Object value) {
        try {
            this.mutex.acquire();
            if (value == null) {
                this.valueMap.remove(key);
            } else {
                this.valueMap.put(key, value);
            }
        }
        finally {
            try {
                this.mutex.release();
            }
            catch (Exception exception) {}
        }
    }
}

