/*
 * Decompiled with CFR 0.152.
 */
package org.allcolor.yahp.converter;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;
import java.util.Map;
import org.allcolor.yahp.converter.CJarLoaderURLStreamHandler;
import org.allcolor.yahp.converter.CMemoryURLHandler;

public class CYaHPURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private Map mapHandler = new Hashtable();
    private URLStreamHandlerFactory oldFactory = null;

    public CYaHPURLStreamHandlerFactory(URLStreamHandlerFactory oldFactory) {
        this.oldFactory = oldFactory;
        this.registerURLStreamHandler("yahpjarloader", CJarLoaderURLStreamHandler.getInstance());
        this.registerURLStreamHandler("yahpmemory", CMemoryURLHandler.getInstance());
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = (URLStreamHandler)this.mapHandler.get(protocol);
        if (handler != null) {
            return handler;
        }
        if (this.oldFactory == null) {
            try {
                String packageProperty = System.getProperty("java.protocol.handler.pkgs");
                String[] listPackages = packageProperty.split(",");
                for (int i = 0; i < listPackages.length; ++i) {
                    Class<?> cls;
                    block7: {
                        String element = listPackages[i];
                        String clsName = element + "." + protocol + ".Handler";
                        cls = null;
                        try {
                            cls = Class.forName(clsName);
                        }
                        catch (ClassNotFoundException e) {
                            ClassLoader cl = ClassLoader.getSystemClassLoader();
                            if (cl == null) break block7;
                            cls = cl.loadClass(clsName);
                        }
                    }
                    if (cls == null) continue;
                    return (URLStreamHandler)cls.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        return this.oldFactory.createURLStreamHandler(protocol);
    }

    public void registerURLStreamHandler(String protocol, URLStreamHandler handler) {
        this.mapHandler.put(protocol, handler);
    }
}

