/*
 * Decompiled with CFR 0.152.
 */
package org.allcolor.yahp.converter;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public interface IHtmlToPdfTransformer {
    public static final PageSize A0L = new PageSize(118.4, 83.2, 40.0);
    public static final PageSize A0P = new PageSize(83.2, 118.4, 1.0);
    public static final PageSize A10L = new PageSize(3.7, 2.6, 0.5);
    public static final PageSize A10P = new PageSize(2.6, 3.7, 0.5);
    public static final PageSize A11L = new PageSize(2.6, 1.85, 0.25);
    public static final PageSize A11P = new PageSize(1.85, 2.6, 0.25);
    public static final PageSize A12L = new PageSize(1.85, 1.3, 0.25);
    public static final PageSize A12P = new PageSize(1.3, 1.85, 0.25);
    public static final PageSize A13L = new PageSize(1.3, 0.925, 0.125);
    public static final PageSize A13P = new PageSize(0.925, 1.3, 0.125);
    public static final PageSize A14L = new PageSize(0.925, 0.65, 0.125);
    public static final PageSize A14P = new PageSize(0.65, 0.925, 0.125);
    public static final PageSize A1L = new PageSize(83.2, 59.2, 1.0);
    public static final PageSize A1P = new PageSize(59.2, 83.2, 1.0);
    public static final PageSize A2L = new PageSize(59.2, 41.6, 1.0);
    public static final PageSize A2P = new PageSize(41.6, 59.2, 1.0);
    public static final PageSize A3L = new PageSize(41.6, 29.6, 1.0);
    public static final PageSize A3P = new PageSize(29.6, 41.6, 1.0);
    public static final PageSize LETTERL = new PageSize(27.9, 21.6, 1.0);
    public static final PageSize LETTERP = new PageSize(21.6, 27.9, 1.0);
    public static final PageSize LEGALL = new PageSize(35.6, 21.6, 1.0);
    public static final PageSize LEGALP = new PageSize(21.6, 35.6, 1.0);
    public static final PageSize JUNIOR_LEGALL = new PageSize(20.3, 12.7, 1.0);
    public static final PageSize JUNIOR_LEGALP = new PageSize(12.7, 20.3, 1.0);
    public static final PageSize A4L = new PageSize(29.6, 20.8, 1.0);
    public static final PageSize A4P = new PageSize(20.8, 29.6, 1.0);
    public static final PageSize A5L = new PageSize(20.8, 14.8, 1.0);
    public static final PageSize A5P = new PageSize(14.8, 20.8, 1.0);
    public static final PageSize A6L = new PageSize(14.8, 10.4, 1.0);
    public static final PageSize A6P = new PageSize(10.4, 14.8, 1.0);
    public static final PageSize A7L = new PageSize(10.4, 7.4, 0.5);
    public static final PageSize A7P = new PageSize(7.4, 10.4, 0.5);
    public static final PageSize A8L = new PageSize(7.4, 5.2, 0.5);
    public static final PageSize A8P = new PageSize(5.2, 7.4, 0.5);
    public static final PageSize A9L = new PageSize(5.2, 3.7, 0.5);
    public static final PageSize A9P = new PageSize(3.7, 5.2, 0.5);
    public static final String DEFAULT_PDF_RENDERER = "org.allcolor.yahp.cl.converter.CHtmlToPdfFlyingSaucerTransformer";
    public static final String FLYINGSAUCER_PDF_RENDERER = "org.allcolor.yahp.cl.converter.CHtmlToPdfFlyingSaucerTransformer";
    public static final String FOP_TTF_FONT_PATH = "yahp.FOP_TTF_FONT_PATH";
    public static final String PDF_ALLOW_ASSEMBLY = "yahp.PDF_ALLOW_ASSEMBLY";
    public static final String PDF_ALLOW_COPY = "yahp.PDF_ALLOW_COPY";
    public static final String PDF_ALLOW_DEGRADED_PRINTING = "yahp.PDF_ALLOW_DEGRADED_PRINTING";
    public static final String PDF_ALLOW_FILLIN = "yahp.PDF_ALLOW_FILLIN";
    public static final String PDF_ALLOW_MODIFT_ANNOTATIONS = "yahp.PDF_ALLOW_MODIFT_ANNOTATIONS";
    public static final String PDF_ALLOW_MODIFY_CONTENTS = "yahp.PDF_ALLOW_MODIFY_CONTENTS";
    public static final String PDF_ALLOW_PRINTING = "yahp.PDF_ALLOW_PRINTING";
    public static final String PDF_ALLOW_SCREEN_READERS = "yahp.PDF_ALLOW_SCREEN_READERS";
    public static final String PDF_AUTHOR = "yahp.PDF_AUTHOR";
    public static final String PDF_CREATOR = "yahp.PDF_CREATOR";
    public static final String PDF_ENCRYPTION_PASSWORD = "yahp.PDF_ENCRYPTION_PASSWORD";
    public static final String PDF_PRODUCER = "yahp.PDF_PRODUCER";
    public static final String PDF_RENDERER_CLASS = "yahp.PDF_RENDERER_CLASS";
    public static final String PDF_SIGNING_KEYSTORE_PASSWORD = "yahp.PDF_SIGNING_KEYSTORE_PASSWORD";
    public static final String PDF_SIGNING_LOCATION = "yahp.PDF_SIGNING_LOCATION";
    public static final String PDF_SIGNING_PRIVATE_KEY_FILE = "yahp.PDF_SIGNING_PRIVATE_KEY_FILE";
    public static final String PDF_SIGNING_PRIVATE_KEY_PASSWORD = "yahp.PDF_SIGNING_PRIVATE_KEY_PASSWORD";
    public static final String PDF_SIGNING_REASON = "yahp.PDF_SIGNING_REASON";
    public static final String PDF_TITLE = "yahp.PDF_TITLE";
    public static final String USE_PDF_ENCRYPTION = "yahp.USE_PDF_ENCRYPTION";
    public static final String USE_PDF_SELF_SIGNING = "yahp.USE_PDF_SELF_SIGNING";
    public static final String USE_PDF_SIGNING = "yahp.USE_PDF_SIGNING";
    public static final String VERSION = "YaHP Converter v1.3 \u00c2\u00a720111121";

    public void transform(InputStream var1, String var2, PageSize var3, List var4, Map var5, OutputStream var6) throws CConvertException;

    public static final class PageSize {
        public static final double _1CMPIXEL = PageSize.getScreenResolution();
        private final int bmargin;
        private final double cmbmargin;
        private final double cmheight;
        private final double cmlmargin;
        private final double[] cmmargin = new double[4];
        private final double cmrmargin;
        private final double cmtmargin;
        private final double[] cmwh = new double[2];
        private final double cmwidth;
        private final int height;
        private final int lmargin;
        private final int[] margin = new int[4];
        private final int rmargin;
        private final int tmargin;
        private final int[] wh = new int[2];
        private final int width;

        private static final double getScreenResolution() {
            return 28.346456692913385;
        }

        public PageSize(double width, double height) {
            this(width, height, 0.0, 0.0, 0.0, 0.0);
        }

        public PageSize(double width, double height, double margin) {
            this(width, height, margin, margin, margin, margin);
        }

        public PageSize(double width, double height, double lmargin, double rmargin, double bmargin, double tmargin) {
            this((int)Math.round(_1CMPIXEL * width), (int)Math.round(_1CMPIXEL * height), (int)Math.round(_1CMPIXEL * lmargin), (int)Math.round(_1CMPIXEL * rmargin), (int)Math.round(_1CMPIXEL * bmargin), (int)Math.round(_1CMPIXEL * tmargin));
        }

        public PageSize(int width, int height) {
            this(width, height, 0, 0, 0, 0);
        }

        public PageSize(int width, int height, int margin) {
            this(width, height, margin, margin, margin, margin);
        }

        public PageSize(int width, int height, int lmargin, int rmargin, int bmargin, int tmargin) {
            if (width < 0 || height < 0 || lmargin < 0 || rmargin < 0 || bmargin < 0 || tmargin < 0) {
                throw new AssertionError((Object)("Margin / Width / height invalid, aborting. - lmargin: " + lmargin + " - rmargin: " + rmargin + " - bmargin: " + bmargin + " - tmargin: " + tmargin + " - w: " + width + " - h: " + height));
            }
            this.width = width;
            this.height = height;
            this.cmwidth = (double)width / _1CMPIXEL;
            this.cmheight = (double)height / _1CMPIXEL;
            this.lmargin = lmargin;
            this.rmargin = rmargin;
            this.bmargin = bmargin;
            this.tmargin = tmargin;
            this.cmlmargin = (double)lmargin / _1CMPIXEL;
            this.cmrmargin = (double)rmargin / _1CMPIXEL;
            this.cmbmargin = (double)bmargin / _1CMPIXEL;
            this.cmtmargin = (double)tmargin / _1CMPIXEL;
        }

        public double[] getCMMargin() {
            this.cmmargin[0] = this.cmlmargin;
            this.cmmargin[1] = this.cmrmargin;
            this.cmmargin[2] = this.cmbmargin;
            this.cmmargin[3] = this.cmtmargin;
            return this.cmmargin;
        }

        public double[] getCMSize() {
            this.cmwh[0] = this.cmwidth;
            this.cmwh[1] = this.cmheight;
            return this.cmwh;
        }

        public int[] getMargin() {
            this.margin[0] = this.lmargin;
            this.margin[1] = this.rmargin;
            this.margin[2] = this.bmargin;
            this.margin[3] = this.tmargin;
            return this.margin;
        }

        public int[] getSize() {
            this.wh[0] = this.width;
            this.wh[1] = this.height;
            return this.wh;
        }
    }

    public static class CHeaderFooter {
        public static final String ALL_PAGES = "all";
        public static final String EVEN_PAGES = "even";
        public static final String FOOTER = "footer";
        public static final String HEADER = "header";
        public static final String ODD_PAGES = "odd";
        private final String content;
        private final String sfor;
        private String type;

        public CHeaderFooter(String content, String type) {
            this(content, HEADER, ALL_PAGES);
            this.type = type;
            if (!type.equals(HEADER) && !type.equals(FOOTER)) {
                throw new IllegalArgumentException("type must be : [header|footer].");
            }
        }

        public CHeaderFooter(String content, String type, String sfor) {
            this.content = content;
            this.type = type;
            if (!type.equals(HEADER) && !type.equals(FOOTER)) {
                throw new IllegalArgumentException("type must be : [header|footer].");
            }
            if (!(sfor.equals(ALL_PAGES) || sfor.equals(ODD_PAGES) || sfor.equals(EVEN_PAGES))) {
                throw new IllegalArgumentException("for is either : all,even or odd.");
            }
            this.sfor = sfor;
        }

        public final String getContent() {
            return this.content;
        }

        public final String getSfor() {
            return this.sfor;
        }

        public final String getType() {
            return this.type;
        }
    }

    public static class CConvertException
    extends Exception {
        static final long serialVersionUID = -6405771637273004347L;

        public CConvertException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

