/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.extend.UserInterface;
import org.xhtmlrenderer.layout.BoxBuilder;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.ViewportBox;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swt.NaiveUserAgent;
import org.xhtmlrenderer.swt.SWTFontContext;
import org.xhtmlrenderer.swt.SWTFontResolver;
import org.xhtmlrenderer.swt.SWTOutputDevice;
import org.xhtmlrenderer.swt.SWTReplacedElementFactory;
import org.xhtmlrenderer.swt.SWTTextRenderer;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.XRLog;

public class PrinterRenderer
implements UserInterface {
    private final Printer _printer;
    private SharedContext _sharedContext;

    public PrinterRenderer(Printer printer) {
        this(printer, new NaiveUserAgent((Device)printer));
    }

    public PrinterRenderer(Printer printer, UserAgentCallback uac) {
        this._printer = printer;
        this._sharedContext = new SharedContext(uac, new SWTFontResolver((Device)printer), new SWTReplacedElementFactory(), new SWTTextRenderer(), printer.getDPI().y);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
    }

    public void dispose() {
        this._sharedContext.flushFonts();
        ((SWTReplacedElementFactory)this._sharedContext.getReplacedElementFactory()).clean();
        UserAgentCallback uac = this._sharedContext.getUac();
        if (uac instanceof NaiveUserAgent) {
            ((NaiveUserAgent)uac).disposeCache();
        }
    }

    protected LayoutContext newLayoutcontext(GC gc) {
        LayoutContext result = this._sharedContext.newLayoutContextInstance();
        result.setFontContext(new SWTFontContext(gc));
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        return result;
    }

    protected RenderingContext newRenderingContext(GC gc) {
        RenderingContext result = this._sharedContext.newRenderingContextInstance();
        result.setFontContext(new SWTFontContext(gc));
        result.setOutputDevice(new SWTOutputDevice(gc));
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Document doc, String url, NamespaceHandler nsh, String jobName, int startPage, int endPage) {
        if (Configuration.isTrue("xr.cache.stylesheets", true)) {
            this._sharedContext.getCss().flushStyleSheets();
        } else {
            this._sharedContext.getCss().flushAllStyleSheets();
        }
        this._sharedContext.reset();
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, this);
        if (!this._printer.startJob(jobName)) {
            return;
        }
        GC gc = new GC((Drawable)this._printer);
        RenderingContext c = null;
        try {
            BlockBox rootBox;
            LayoutContext layout = this.newLayoutcontext(gc);
            try {
                long start = System.currentTimeMillis();
                rootBox = BoxBuilder.createRootBox(layout, doc);
                PageBox first = Layer.createPageBox(layout, "first");
                rootBox.setContainingBlock(new ViewportBox(new Rectangle(0, 0, first.getContentWidth(layout), first.getContentHeight(layout))));
                rootBox.layout(layout);
                long end = System.currentTimeMillis();
                XRLog.layout(Level.INFO, "Layout took " + (end - start) + "ms");
            }
            catch (Throwable e) {
                XRLog.exception(e.getMessage(), e);
                if (c != null) {
                    ((SWTOutputDevice)c.getOutputDevice()).clean();
                }
                gc.dispose();
                this._printer.endJob();
                return;
            }
            Layer root = rootBox.getLayer();
            Dimension intrinsic_size = root.getPaintingDimension(layout);
            root.trimEmptyPages(layout, intrinsic_size.height);
            root.assignPagePaintingPositions(layout, (short)2);
            c = this.newRenderingContext(gc);
            List pages = root.getPages();
            c.setPageCount(pages.size());
            if (startPage < 0) {
                startPage = 0;
            } else if (startPage >= pages.size()) {
                startPage = pages.size() - 1;
            }
            if (endPage < 0 || endPage >= pages.size()) {
                endPage = pages.size() - 1;
            }
            Shape working = c.getOutputDevice().getClip();
            for (int i = startPage; i <= endPage; ++i) {
                PageBox page = (PageBox)pages.get(i);
                c.setPage(i, page);
                if (!this._printer.startPage()) {
                    return;
                }
                page.paintBackground(c, 0, (short)2);
                page.paintMarginAreas(c, 0, (short)2);
                page.paintBorder(c, 0, (short)2);
                Rectangle content = page.getPrintClippingBounds(c);
                c.getOutputDevice().clip(content);
                int top = -page.getPaintingTop() + page.getMarginBorderPadding(c, 3);
                int left = page.getMarginBorderPadding(c, 1);
                c.getOutputDevice().translate(left, top);
                root.paint(c);
                c.getOutputDevice().translate(-left, -top);
                c.getOutputDevice().setClip(working);
                this._printer.endPage();
            }
        }
        finally {
            if (c != null) {
                ((SWTOutputDevice)c.getOutputDevice()).clean();
            }
            gc.dispose();
            this._printer.endJob();
        }
    }

    public void print(String url, NamespaceHandler nsh, String jobName, int startPage, int endPage) {
        this.print(this.loadDocument(url), url, nsh, jobName, startPage, endPage);
    }

    protected Document loadDocument(String uri) {
        XMLResource xmlResource = this._sharedContext.getUac().getXMLResource(uri);
        if (xmlResource == null) {
            return null;
        }
        return xmlResource.getDocument();
    }

    public boolean isActive(Element e) {
        return false;
    }

    public boolean isFocus(Element e) {
        return false;
    }

    public boolean isHover(Element e) {
        return false;
    }

    public static void print(Printer printer, Document doc, String url, NamespaceHandler nsh, String jobName, int startPage, int endPage) {
        PrinterRenderer render = new PrinterRenderer(printer);
        render.print(doc, url, nsh, jobName, startPage, endPage);
        render.dispose();
    }

    public static void print(Printer printer, String url, NamespaceHandler nsh, String jobName, int startPage, int endPage) {
        PrinterRenderer render = new PrinterRenderer(printer);
        render.print(url, nsh, jobName, startPage, endPage);
        render.dispose();
    }

    public static void print(PrinterData printerData, Document doc, String url, NamespaceHandler nsh, String jobName) {
        Printer printer = new Printer(printerData);
        int startPage = -1;
        int endPage = -1;
        if (printerData.scope == 1) {
            startPage = printerData.startPage - 1;
            endPage = printerData.endPage - 1;
        }
        PrinterRenderer.print(printer, doc, url, nsh, jobName, startPage, endPage);
        printer.dispose();
    }

    public static void print(PrinterData printerData, String url, NamespaceHandler nsh, String jobName) {
        Printer printer = new Printer(printerData);
        int startPage = -1;
        int endPage = -1;
        if (printerData.scope == 1) {
            startPage = printerData.startPage - 1;
            endPage = printerData.endPage - 1;
        }
        PrinterRenderer.print(printer, url, nsh, jobName, startPage, endPage);
        printer.dispose();
    }

    public static void printDialog(Shell shell, Document doc, String url, NamespaceHandler nsh, String jobName) {
        PrintDialog dlg = new PrintDialog(shell);
        dlg.setText(jobName);
        PrinterData data = dlg.open();
        if (data != null) {
            PrinterRenderer.print(data, doc, url, nsh, jobName);
        }
    }

    public static void printDialog(Shell shell, String url, NamespaceHandler nsh, String jobName) {
        PrintDialog dlg = new PrintDialog(shell);
        dlg.setText(jobName);
        PrinterData data = dlg.open();
        if (data != null) {
            PrinterRenderer.print(data, url, nsh, jobName);
        }
    }
}

